/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.workbench.ui.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class CompositeRenderer
extends SWTPartRenderer {
    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MPart) || !(parent instanceof Composite)) {
            return null;
        }
        Widget parentWidget = (Widget)parent;
        String policy = "VerticalComposite";
        if (policy != null && (policy.equals("HorizontalComposite") || policy.equals("VerticalComposite"))) {
            return new Composite((Composite)parentWidget, 0);
        }
        return null;
    }

    public void postProcess(MUIElement element) {
        super.postProcess(element);
        String policy = "VerticalComposite";
        if (policy != null && policy.endsWith("Composite")) {
            Composite composite = (Composite)element.getWidget();
            Control[] children = composite.getChildren();
            GridLayout gl = new GridLayout(policy.startsWith("Horizontal") ? children.length : 1, false);
            gl.horizontalSpacing = 0;
            gl.verticalSpacing = 0;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            composite.setLayout((Layout)gl);
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                boolean grabV = !(child instanceof ToolBar);
                boolean grabH = !(child instanceof ToolBar);
                child.setLayoutData((Object)new GridData(4, 4, grabH, grabV));
                ++i;
            }
        }
    }
}

