/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MGenericStack;
import org.eclipse.e4.ui.model.application.MPlaceholder;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.workbench.swt.internal.AbstractPartRenderer;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.e4.workbench.ui.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyStackRenderer
extends SWTPartRenderer {
    private EventHandler lazyLoader = new EventHandler(){

        public void handleEvent(Event event) {
            Object element = event.getProperty("ChangedElement");
            if (!(element instanceof MGenericStack)) {
                return;
            }
            MGenericStack stack = (MGenericStack)element;
            LazyStackRenderer lsr = (LazyStackRenderer)((Object)stack.getRenderer());
            if (lsr == null) {
                return;
            }
            MUIElement oldSel = (MUIElement)event.getProperty("OldValue");
            if (oldSel != null) {
                ArrayList goingHidden = new ArrayList();
                LazyStackRenderer.this.hideElementRecursive(oldSel, goingHidden);
            }
            if (stack.getSelectedElement() != null) {
                lsr.showTab(stack.getSelectedElement());
            }
        }
    };

    public void init(IEventBroker eventBroker) {
        eventBroker.unsubscribe(this.lazyLoader);
        eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/ElementContainer", (String)"selectedElement"), this.lazyLoader);
    }

    public void contextDisposed(IEventBroker eventBroker) {
        eventBroker.unsubscribe(this.lazyLoader);
    }

    public void postProcess(MUIElement element) {
        if (!(element instanceof MGenericStack)) {
            return;
        }
        MGenericStack stack = (MGenericStack)element;
        MUIElement selPart = stack.getSelectedElement();
        if (selPart != null) {
            this.showTab(selPart);
        } else if (stack.getChildren().size() > 0) {
            selPart = (MUIElement)stack.getChildren().get(0);
            stack.setSelectedElement(selPart);
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> me) {
        Widget parentWidget = this.getParentWidget((MUIElement)me);
        if (parentWidget == null) {
            return;
        }
        for (MUIElement part : me.getChildren()) {
            if (!part.isToBeRendered()) continue;
            this.createTab(me, part);
        }
    }

    protected void createTab(MElementContainer<MUIElement> me, MUIElement part) {
    }

    protected void showTab(MUIElement element) {
        ArrayList<MUIElement> becomingVisible = new ArrayList<MUIElement>();
        MUIElement curSel = element.getParent().getSelectedElement();
        if (curSel != null) {
            this.showElementRecursive(curSel, becomingVisible);
        }
    }

    private void hideElementRecursive(MUIElement element, List<MUIElement> goingHidden) {
        if (element == null || element.getWidget() == null) {
            return;
        }
        if (element instanceof MWindow && element.getWidget() != null) {
            element.setVisible(false);
        }
        goingHidden.add(element);
        if (element instanceof MGenericStack) {
            MGenericStack container = (MGenericStack)element;
            MUIElement curSel = container.getSelectedElement();
            this.hideElementRecursive(curSel, goingHidden);
        } else if (element instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)element;
            for (MUIElement childElement : container.getChildren()) {
                this.hideElementRecursive(childElement, goingHidden);
            }
        }
    }

    private void showElementRecursive(MUIElement element, List<MUIElement> becomingVisible) {
        if (!element.isToBeRendered()) {
            return;
        }
        if (element instanceof MPlaceholder) {
            this.swap((MPlaceholder)element);
            element = ((MPlaceholder)element).getRef();
        }
        if (element instanceof MWindow && element.getWidget() != null) {
            element.setVisible(true);
        }
        becomingVisible.add(element);
        if (element instanceof MGenericStack) {
            MGenericStack container = (MGenericStack)element;
            MUIElement curSel = container.getSelectedElement();
            if (curSel == null && container.getChildren().size() > 0) {
                curSel = (MUIElement)container.getChildren().get(0);
            }
            if (curSel != null) {
                this.showElementRecursive(curSel, becomingVisible);
            }
        } else if (element instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)element;
            ArrayList kids = new ArrayList(container.getChildren());
            for (MUIElement childElement : kids) {
                this.showElementRecursive(childElement, becomingVisible);
            }
        }
    }

    public void swap(MPlaceholder placeholder) {
        MUIElement element = placeholder.getRef();
        MElementContainer elementParent = element.getParent();
        int elementIndex = elementParent.getChildren().indexOf((Object)element);
        MElementContainer phParent = placeholder.getParent();
        int phIndex = phParent.getChildren().indexOf((Object)placeholder);
        elementParent.getChildren().remove((Object)element);
        phParent.getChildren().remove((Object)placeholder);
        boolean onTop = element.isOnTop();
        boolean vis = element.isVisible();
        boolean tbr = element.isToBeRendered();
        String cd = element.getContainerData();
        element.setOnTop(placeholder.isOnTop());
        element.setVisible(placeholder.isVisible());
        element.setToBeRendered(placeholder.isToBeRendered());
        element.setContainerData(placeholder.getContainerData());
        placeholder.setOnTop(onTop);
        placeholder.setVisible(vis);
        placeholder.setToBeRendered(tbr);
        placeholder.setContainerData(cd);
        elementParent.getChildren().add(elementIndex, (Object)placeholder);
        phParent.getChildren().add(phIndex, (Object)element);
        if (elementParent.getSelectedElement() == element) {
            elementParent.setSelectedElement(null);
        }
        if (phParent.getSelectedElement() == null) {
            phParent.setSelectedElement(element);
        }
        if (element.getWidget() instanceof Control) {
            Control c = (Control)element.getWidget();
            Object phLayoutData = placeholder.getRenderer();
            placeholder.setRenderer(c.getLayoutData());
            c.setLayoutData(phLayoutData);
            if (phParent.getWidget() instanceof Composite) {
                CTabFolder ctf;
                AbstractPartRenderer renderer = (AbstractPartRenderer)phParent.getRenderer();
                Composite newParent = (Composite)renderer.getUIContainer(element);
                c.setParent(newParent);
                Control[] changed = new Control[]{c};
                MUIElement prevElement = null;
                for (MUIElement kid : phParent.getChildren()) {
                    if (kid == element) {
                        if (prevElement == null) {
                            c.moveAbove(null);
                            continue;
                        }
                        c.moveBelow((Control)prevElement.getWidget());
                        continue;
                    }
                    if (kid.getWidget() == null) continue;
                    prevElement = kid;
                }
                newParent.getShell().layout(changed, 6);
                if (newParent instanceof CTabFolder && (ctf = (CTabFolder)newParent).getSelection() == null) {
                    ctf.setSelection(0);
                }
            }
        }
    }
}

