/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MPerspective;
import org.eclipse.e4.ui.model.application.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.renderers.swt.LazyStackRenderer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PerspectiveStackRenderer
extends LazyStackRenderer {
    @Inject
    IPresentationEngine renderer;
    @Inject
    IEventBroker eventBroker;

    @PostConstruct
    public void init() {
        super.init(this.eventBroker);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MPerspectiveStack) || !(parent instanceof Composite)) {
            return null;
        }
        Composite perspStack = new Composite((Composite)parent, 0);
        IStylingEngine stylingEngine = (IStylingEngine)this.getContext(element).get(IStylingEngine.SERVICE_NAME);
        stylingEngine.setClassname((Object)perspStack, "perspectiveLayout");
        perspStack.setLayout((Layout)new StackLayout());
        return perspStack;
    }

    public void postProcess(MUIElement element) {
        super.postProcess(element);
        MPerspectiveStack ps = (MPerspectiveStack)element;
        if (ps.getSelectedElement() != null && ((MPerspective)ps.getSelectedElement()).getWidget() != null) {
            Control ctrl = (Control)((MPerspective)ps.getSelectedElement()).getWidget();
            Composite psComp = (Composite)ps.getWidget();
            StackLayout sl = (StackLayout)psComp.getLayout();
            sl.topControl = ctrl;
            psComp.layout();
        }
    }

    protected void showTab(MUIElement tabElement) {
        super.showTab(tabElement);
        Control ctrl = (Control)tabElement.getWidget();
        if (ctrl == null) {
            ctrl = (Control)this.renderer.createGui(tabElement);
        }
        Composite psComp = ctrl.getParent();
        StackLayout sl = (StackLayout)psComp.getLayout();
        sl.topControl = ctrl;
        psComp.layout();
        ctrl.moveAbove(null);
    }
}

