/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextChangeEvent;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.IRunAndTrack;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.core.di.annotations.PreDestroy;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MDirtyable;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MToolBar;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MUILabel;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.workbench.modeling.EPartService;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.e4.workbench.ui.internal.Trackable;
import org.eclipse.e4.workbench.ui.renderers.swt.LazyStackRenderer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackRenderer
extends LazyStackRenderer {
    private static final String FOLDER_DISPOSED = "folderDisposed";
    Image viewMenuImage;
    @Inject
    IStylingEngine stylingEngine;
    @Inject
    IEventBroker eventBroker;
    @Inject
    IPresentationEngine renderer;
    private EventHandler itemUpdater;
    private EventHandler dirtyUpdater;
    private boolean ignoreTabSelChanges = false;
    private ActivationJob activationJob = null;

    private synchronized void activateStack(MElementContainer<MUIElement> stack) {
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        if (ctf == null || ctf.isDisposed()) {
            return;
        }
        if (this.activationJob == null) {
            this.activationJob = new ActivationJob();
            this.activationJob.stackToActivate = stack;
            ctf.getDisplay().asyncExec((Runnable)this.activationJob);
        } else {
            this.activationJob.stackToActivate = stack;
        }
    }

    @PostConstruct
    public void init() {
        super.init(this.eventBroker);
        this.itemUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MUILabel) || !(objElement instanceof MUIElement)) {
                    return;
                }
                MUIElement uiElement = (MUIElement)objElement;
                MUILabel modelItem = (MUILabel)objElement;
                MElementContainer parent = uiElement.getParent();
                if (parent.getRenderer() != StackRenderer.this) {
                    return;
                }
                CTabItem item = StackRenderer.this.findItemForPart(uiElement);
                if (item == null) {
                    return;
                }
                String attName = (String)event.getProperty("AttName");
                if ("label".equals(attName)) {
                    String newName = (String)event.getProperty("NewValue");
                    item.setText(StackRenderer.this.getLabel((MUILabel)((MPart)uiElement), newName));
                } else if ("iconURI".equals(attName)) {
                    item.setImage(StackRenderer.this.getImage(modelItem));
                } else if ("tooltip".equals(attName)) {
                    String newTTip = (String)event.getProperty("NewValue");
                    item.setToolTipText(newTTip);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/UILabel"), this.itemUpdater);
        this.dirtyUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                boolean hasAsterisk;
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MPart)) {
                    return;
                }
                MPart uiElement = (MPart)objElement;
                MElementContainer parent = uiElement.getParent();
                if (parent.getRenderer() != StackRenderer.this) {
                    return;
                }
                CTabItem item = StackRenderer.this.findItemForPart((MUIElement)uiElement);
                if (item == null) {
                    return;
                }
                Boolean dirtyState = (Boolean)event.getProperty("NewValue");
                String text = item.getText();
                boolean bl = hasAsterisk = text.charAt(0) == '*';
                if (dirtyState.booleanValue()) {
                    if (!hasAsterisk) {
                        item.setText(String.valueOf('*') + text);
                    }
                } else if (hasAsterisk) {
                    item.setText(text.substring(1));
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/Dirtyable", (String)"dirty"), this.dirtyUpdater);
    }

    @PreDestroy
    public void contextDisposed() {
        super.contextDisposed(this.eventBroker);
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.dirtyUpdater);
    }

    private String getLabel(MUILabel itemPart, String newName) {
        if (newName == null) {
            newName = "";
        }
        if (itemPart instanceof MDirtyable && ((MDirtyable)itemPart).isDirty()) {
            newName = String.valueOf('*') + newName;
        }
        return newName;
    }

    public Object createWidget(MUIElement element, Object parent) {
        CTabFolder newWidget = null;
        if (!(element instanceof MPartStack) || !(parent instanceof Composite)) {
            return null;
        }
        Composite parentComposite = (Composite)parent;
        int styleModifier = 0;
        final CTabFolder ctf = new CTabFolder(parentComposite, 0x800 | styleModifier);
        this.bindWidget(element, ctf);
        ctf.setUnselectedCloseVisible(false);
        newWidget = ctf;
        final IEclipseContext folderContext = this.getContext(element);
        folderContext.set(FOLDER_DISPOSED, (Object)Boolean.FALSE);
        final IEclipseContext toplevelContext = this.getToplevelContext(element);
        final Trackable updateActiveTab = new Trackable(folderContext){

            public boolean notify(ContextChangeEvent event) {
                IEclipseContext child;
                if (event.getEventType() == 3) {
                    return false;
                }
                if (!this.participating) {
                    return true;
                }
                this.trackingContext.get(StackRenderer.FOLDER_DISPOSED);
                IEclipseContext currentActive = toplevelContext;
                while (currentActive != this.trackingContext && (child = (IEclipseContext)currentActive.get("activeChild")) != null && child != currentActive) {
                    currentActive = child;
                }
                String cssClassName = currentActive == this.trackingContext ? "active" : "inactive";
                StackRenderer.this.stylingEngine.setClassname((Object)ctf, cssClassName);
                if (ctf.getTopRight() != null) {
                    StackRenderer.this.stylingEngine.setClassname((Object)ctf.getTopRight(), cssClassName);
                }
                CTabItem[] items = ctf.getItems();
                int i = 0;
                while (i < items.length) {
                    StackRenderer.this.stylingEngine.setClassname((Object)items[i], cssClassName);
                    ++i;
                }
                return true;
            }
        };
        ctf.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                updateActiveTab.participating = false;
                folderContext.set(StackRenderer.FOLDER_DISPOSED, (Object)Boolean.TRUE);
            }
        });
        folderContext.runAndTrack((IRunAndTrack)updateActiveTab, null);
        return newWidget;
    }

    @Override
    protected void createTab(MElementContainer<MUIElement> stack, MUIElement part) {
        MUILabel itemPart = (MUILabel)part;
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        CTabItem cti = this.findItemForPart(part);
        if (cti != null) {
            if (part.getWidget() != null) {
                cti.setControl((Control)part.getWidget());
            }
            return;
        }
        int createFlags = 0;
        if (part instanceof MPart && ((MPart)part).isCloseable()) {
            createFlags |= 0x40;
        }
        int index = this.calcIndexFor(stack, part);
        cti = new CTabItem(ctf, createFlags, index);
        cti.setData("modelElement", (Object)part);
        cti.setText(this.getLabel(itemPart, itemPart.getLabel()));
        cti.setImage(this.getImage(itemPart));
        cti.setToolTipText(itemPart.getTooltip());
        if (part.getWidget() != null) {
            cti.setControl((Control)part.getWidget());
        }
    }

    private int calcIndexFor(MElementContainer<MUIElement> stack, MUIElement part) {
        int index = 0;
        for (MUIElement mPart : stack.getChildren()) {
            if (mPart == part) {
                return index;
            }
            if (!mPart.isToBeRendered()) continue;
            ++index;
        }
        return index;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        if (!(parentElement instanceof MPartStack) || !(element instanceof MPart)) {
            return;
        }
        this.createTab(parentElement, element);
    }

    private CTabItem findItemForPart(MUIElement part) {
        MElementContainer stack = part.getParent();
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        if (ctf == null) {
            return null;
        }
        CTabItem[] items = ctf.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("modelElement") == part) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        if (!(parentElement instanceof MPartStack) || !(child instanceof MPart)) {
            return;
        }
        CTabFolder ctf = (CTabFolder)parentElement.getWidget();
        if (ctf == null) {
            return;
        }
        CTabItem[] items = ctf.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("modelElement") == child) {
                items[i].setControl(null);
                items[i].dispose();
            }
            ++i;
        }
        if (parentElement.getSelectedElement() == child) {
            Control tb = ctf.getTopRight();
            if (tb != null) {
                ctf.setTopRight(null);
                tb.dispose();
            }
            MUIElement defaultSel = this.getFirstVisibleElement(parentElement);
            parentElement.setSelectedElement(defaultSel);
        }
    }

    private MUIElement getFirstVisibleElement(MElementContainer<MUIElement> stack) {
        for (MUIElement mPart : stack.getChildren()) {
            if (!mPart.isToBeRendered()) continue;
            return mPart;
        }
        return null;
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        super.hookControllerLogic(me);
        if (!(me instanceof MElementContainer)) {
            return;
        }
        final MElementContainer stack = (MElementContainer)me;
        CTabFolder ctf = (CTabFolder)me.getWidget();
        ctf.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (StackRenderer.this.ignoreTabSelChanges) {
                    return;
                }
                MPart newPart = (MPart)e.item.getData("modelElement");
                newPart.getParent().setSelectedElement((MUIElement)newPart);
                StackRenderer.this.activateStack((MElementContainer<MUIElement>)stack);
            }
        });
        CTabFolder2Adapter closeListener = new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                MPart part = (MPart)event.item.getData("modelElement");
                IEclipseContext partContext = part.getContext();
                EPartService partService = (EPartService)partContext.get(EPartService.class.getName());
                if (partService.savePart(part, true)) {
                    partService.hidePart(part);
                } else {
                    event.doit = false;
                }
            }
        };
        ctf.addCTabFolder2Listener((CTabFolder2Listener)closeListener);
        ctf.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                CTabFolder ctf = (CTabFolder)event.widget;
                MElementContainer stack = (MElementContainer)ctf.getData("modelElement");
                StackRenderer.this.activateStack((MElementContainer<MUIElement>)stack);
            }
        });
    }

    @Override
    protected void showTab(MUIElement element) {
        ToolBar tb;
        super.showTab(element);
        CTabFolder ctf = (CTabFolder)this.getParentWidget(element);
        CTabItem cti = this.findItemForPart(element);
        if (element.getWidget() == null) {
            Control tabCtrl = (Control)this.renderer.createGui(element);
            cti.setControl(tabCtrl);
        } else if (cti.getControl() == null) {
            cti.setControl((Control)element.getWidget());
        }
        this.ignoreTabSelChanges = true;
        ctf.setSelection(cti);
        this.ignoreTabSelChanges = false;
        if (ctf.getTopRight() != null) {
            ctf.getTopRight().dispose();
            ctf.setTopRight(null);
        }
        if ((tb = this.getToolbar(element)) != null) {
            if (tb.getSize().y > ctf.getTabHeight()) {
                ctf.setTabHeight(tb.getSize().y);
            }
            String cssClassName = (String)ctf.getData("org.eclipse.e4.ui.css.CssClassName");
            this.stylingEngine.setClassname((Object)tb, cssClassName);
            ctf.setTopRight((Control)tb, 131072);
            ctf.layout(true);
            ctf.notifyListeners(11, null);
        }
    }

    private ToolBar getToolbar(MUIElement element) {
        boolean hasTB;
        if (!(element instanceof MPart)) {
            return null;
        }
        MPart part = (MPart)element;
        boolean hasMenu = part.getMenus() != null && part.getMenus().size() > 0;
        boolean bl = hasTB = part.getToolbar() != null;
        if (!hasMenu && !hasTB) {
            return null;
        }
        CTabFolder ctf = (CTabFolder)this.getParentWidget((MUIElement)part);
        MToolBar tbModel = part.getToolbar();
        ToolBar tb = tbModel != null ? (ToolBar)this.renderer.createGui((MUIElement)tbModel, (Object)ctf) : new ToolBar((Composite)ctf, 0x800100);
        if (hasMenu) {
            this.addMenuButton(part, tb, (MMenu)part.getMenus().get(0));
        }
        tb.pack();
        return tb;
    }

    private void addMenuButton(MPart part, ToolBar tb, MMenu menu) {
        ToolItem ti = new ToolItem(tb, 8);
        ti.setImage(this.getViewMenuImage());
        ti.setHotImage(null);
        ti.setToolTipText("View Menu");
        ti.setData("theMenu", (Object)menu);
        ti.setData("thePart", (Object)part);
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StackRenderer.this.showMenu((ToolItem)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StackRenderer.this.showMenu((ToolItem)e.widget);
            }
        });
    }

    protected void showMenu(ToolItem item) {
        MMenu menuModel = (MMenu)item.getData("theMenu");
        MPart part = (MPart)item.getData("thePart");
        Control ctrl = (Control)part.getWidget();
        Menu menu = (Menu)this.renderer.createGui((MUIElement)menuModel, (Object)ctrl.getShell());
        Rectangle ib = item.getBounds();
        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
        menu.setLocation(displayAt);
        menu.setVisible(true);
        Display display = Display.getCurrent();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        menu.dispose();
    }

    private Image getViewMenuImage() {
        if (this.viewMenuImage == null) {
            Display d = Display.getCurrent();
            Image viewMenu = new Image((Device)d, 16, 16);
            Image viewMenuMask = new Image((Device)d, 16, 16);
            Display display = Display.getCurrent();
            GC gc = new GC((Drawable)viewMenu);
            GC maskgc = new GC((Drawable)viewMenuMask);
            gc.setForeground(display.getSystemColor(17));
            gc.setBackground(display.getSystemColor(25));
            int[] shapeArray = new int[]{6, 1, 15, 1, 11, 5, 10, 5};
            gc.fillPolygon(shapeArray);
            gc.drawPolygon(shapeArray);
            Color black = display.getSystemColor(2);
            Color white = display.getSystemColor(1);
            maskgc.setBackground(black);
            maskgc.fillRectangle(0, 0, 16, 16);
            maskgc.setBackground(white);
            maskgc.setForeground(white);
            maskgc.fillPolygon(shapeArray);
            maskgc.drawPolygon(shapeArray);
            gc.dispose();
            maskgc.dispose();
            ImageData data = viewMenu.getImageData();
            data.transparentPixel = data.getPixel(0, 0);
            this.viewMenuImage = new Image((Device)d, viewMenu.getImageData(), viewMenuMask.getImageData());
            viewMenu.dispose();
            viewMenuMask.dispose();
        }
        return this.viewMenuImage;
    }

    private class ActivationJob
    implements Runnable {
        public MElementContainer<MUIElement> stackToActivate = null;

        private ActivationJob() {
        }

        public void run() {
            StackRenderer.this.activationJob = null;
            if (this.stackToActivate != null && this.stackToActivate.getSelectedElement() != null) {
                StackRenderer.this.activate((MPart)this.stackToActivate.getSelectedElement());
            }
        }
    }
}

