/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.core.di.annotations.PreDestroy;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.model.application.ItemType;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MHandledItem;
import org.eclipse.e4.ui.model.application.MItem;
import org.eclipse.e4.ui.model.application.MParameter;
import org.eclipse.e4.ui.model.application.MToolItem;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MUILabel;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.e4.workbench.ui.renderers.swt.SWTPartRenderer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolItemRenderer
extends SWTPartRenderer {
    @Inject
    Logger logger;
    @Inject
    IEventBroker eventBroker;
    private EventHandler itemUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolItem)) {
                return;
            }
            MToolItem itemModel = (MToolItem)event.getProperty("ChangedElement");
            ToolItem toolItem = (ToolItem)itemModel.getWidget();
            if (toolItem == null) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            if ("label".equals(attName)) {
                ToolItemRenderer.this.setItemText(itemModel, toolItem);
            } else if ("iconURI".equals(attName)) {
                toolItem.setImage(ToolItemRenderer.this.getImage((MUILabel)itemModel));
            } else if ("tooltip".equals(attName)) {
                toolItem.setToolTipText(itemModel.getTooltip());
                toolItem.setImage(ToolItemRenderer.this.getImage((MUILabel)itemModel));
            }
        }
    };
    private EventHandler selectionUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolItem)) {
                return;
            }
            MToolItem itemModel = (MToolItem)event.getProperty("ChangedElement");
            ToolItem toolItem = (ToolItem)itemModel.getWidget();
            if (toolItem != null) {
                toolItem.setSelection(itemModel.isSelected());
            }
        }
    };

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/UILabel"), this.itemUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/Item", (String)"selected"), this.selectionUpdater);
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.selectionUpdater);
    }

    private ParameterizedCommand generateParameterizedCommand(MHandledItem item, IEclipseContext lclContext) {
        ECommandService cmdService = (ECommandService)lclContext.get(ECommandService.class.getName());
        HashMap<String, String> parameters = null;
        EList modelParms = item.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getTag(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = cmdService.createCommand(item.getCommand().getId(), parameters);
        item.setWbCommand(cmd);
        return cmd;
    }

    private void setItemText(MToolItem model, ToolItem item) {
        String text = model.getLabel();
        if (model instanceof MHandledItem) {
            TriggerSequence sequence;
            MHandledItem handledItem = (MHandledItem)model;
            IEclipseContext context = this.getContext((MUIElement)model);
            EBindingService bs = (EBindingService)context.get(EBindingService.class.getName());
            ParameterizedCommand cmd = handledItem.getWbCommand();
            if (cmd == null) {
                cmd = this.generateParameterizedCommand(handledItem, context);
            }
            if ((sequence = bs.getBestSequenceFor(handledItem.getWbCommand())) != null) {
                text = String.valueOf(text) + '\t' + sequence.format();
            }
            item.setText(text);
        } else {
            if (text == null) {
                text = "";
            }
            item.setText(text);
        }
    }

    public Object createWidget(MUIElement element, Object parent) {
        int flags;
        if (!(element instanceof MToolItem) || !(parent instanceof ToolBar)) {
            return null;
        }
        ToolBar tb = (ToolBar)parent;
        MToolItem itemModel = (MToolItem)element;
        int addIndex = this.calcVisibleIndex(element);
        if (itemModel.getType() == ItemType.SEPARATOR) {
            return new ToolItem(tb, 2, addIndex);
        }
        int n = flags = itemModel.getChildren().size() > 0 ? 4 : 0;
        if (itemModel.getType() == ItemType.PUSH) {
            flags |= 8;
        } else if (itemModel.getType() == ItemType.CHECK) {
            flags |= 0x20;
        } else if (itemModel.getType() == ItemType.RADIO) {
            flags |= 0x10;
        }
        ToolItem newItem = new ToolItem((ToolBar)parent, flags, addIndex);
        if (itemModel.getLabel() != null) {
            newItem.setText(itemModel.getLabel());
        }
        if (itemModel.getTooltip() != null) {
            newItem.setToolTipText(itemModel.getTooltip());
        }
        newItem.setImage(this.getImage((MUILabel)element));
        newItem.setEnabled(itemModel.isEnabled());
        newItem.setSelection(itemModel.isSelected());
        return newItem;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        MItem item;
        if (me instanceof MItem && ((item = (MItem)me).getType() == ItemType.CHECK || item.getType() == ItemType.RADIO)) {
            ToolItem ti = (ToolItem)me.getWidget();
            ti.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    item.setSelected(((ToolItem)e.widget).getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    item.setSelected(((ToolItem)e.widget).getSelection());
                }
            });
        }
        if (me instanceof MContribution && ((MContribution)me).getURI() != null) {
            item = (MToolItem)me;
            final MContribution contrib = (MContribution)me;
            final IEclipseContext lclContext = this.getContext(me);
            ToolItem ti = (ToolItem)me.getWidget();
            ti.addSelectionListener(new SelectionListener((MToolItem)item){
                private final /* synthetic */ MToolItem val$item;
                {
                    this.val$item = mToolItem;
                }

                public void widgetSelected(SelectionEvent e) {
                    block5: {
                        if (contrib.getObject() == null) {
                            IContributionFactory cf = (IContributionFactory)lclContext.get(IContributionFactory.class.getName());
                            contrib.setObject(cf.create(contrib.getURI(), lclContext));
                        }
                        try {
                            lclContext.set(MItem.class.getName(), (Object)this.val$item);
                            ContextInjectionFactory.invoke((Object)contrib.getObject(), (String)"execute", (IEclipseContext)lclContext);
                            lclContext.remove(MItem.class.getName());
                        }
                        catch (InvocationTargetException e1) {
                            if (ToolItemRenderer.this.logger != null) {
                                ToolItemRenderer.this.logger.error((Throwable)e1);
                            }
                        }
                        catch (InjectionException e1) {
                            if (ToolItemRenderer.this.logger == null) break block5;
                            ToolItemRenderer.this.logger.error((Throwable)e1);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else if (me instanceof MHandledItem) {
            item = (MHandledItem)me;
            final IEclipseContext lclContext = this.getContext(me);
            ToolItem ti = (ToolItem)me.getWidget();
            ti.addSelectionListener(new SelectionListener((MHandledItem)item){
                private final /* synthetic */ MHandledItem val$item;
                {
                    this.val$item = mHandledItem;
                }

                public void widgetSelected(SelectionEvent e) {
                    EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class.getName());
                    ParameterizedCommand cmd = this.val$item.getWbCommand();
                    if (cmd == null) {
                        cmd = ToolItemRenderer.this.generateParameterizedCommand(this.val$item, lclContext);
                    }
                    lclContext.set(MItem.class.getName(), (Object)this.val$item);
                    service.executeHandler(cmd);
                    lclContext.remove(MItem.class.getName());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }
}

