/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt.dnd;

import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MGenericStack;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MToolBar;
import org.eclipse.e4.ui.model.application.MToolItem;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.workbench.ui.renderers.swt.dnd.DragAndDropUtil;
import org.eclipse.e4.workbench.ui.renderers.swt.dnd.DragHost;
import org.eclipse.e4.workbench.ui.renderers.swt.dnd.Overlay;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DnDManager {
    DragAndDropUtil dndUtil;
    Overlay overlay;
    protected DragAndDropUtil.CursorInfo dndInfo;
    protected Point downPos;
    protected DragAndDropUtil.CursorInfo downInfo;
    private DragHost dragHost;
    private MUIElement curOverlayElement;
    private Display display;
    Listener keyListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.character == '\u001b' && DnDManager.this.dragHost != null) {
                DnDManager.this.cancelDrag();
            }
        }
    };
    Listener mouseButtonListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.button != 1) {
                DnDManager.this.downPos = null;
                return;
            }
            DragAndDropUtil.CursorInfo info = DnDManager.this.dndUtil.getCursorInfo();
            if (event.type == 3 && DnDManager.this.dragHost == null && info.curElement instanceof MGenericStack && info.itemElement != null) {
                DnDManager.this.downPos = new Point(event.x, event.y);
                DnDManager.this.downInfo = info;
            } else if (event.type == 4) {
                DnDManager.this.downPos = null;
                DnDManager.this.downInfo = null;
                if (DnDManager.this.dragHost != null) {
                    DragAndDropUtil.CursorInfo dropInfo = DnDManager.this.getDropInfo();
                    if (dropInfo.curElement == null) {
                        DnDManager.this.cancelDrag();
                    } else {
                        DnDManager.this.endDrag(dropInfo);
                    }
                }
            }
        }
    };
    Listener mouseMoveListener = new Listener(){

        public void handleEvent(Event event) {
            if (DnDManager.this.dragHost != null) {
                DragAndDropUtil.CursorInfo dropInfo = DnDManager.this.getDropInfo();
                if (dropInfo.curElement == null) {
                    DnDManager.this.setCursor(DnDManager.this.display.getSystemCursor(20));
                } else {
                    DnDManager.this.setCursor(DnDManager.this.display.getSystemCursor(21));
                }
                Point p = event.display.getCursorLocation();
                DnDManager.this.dragHost.setLocation(p.x, p.y);
                DnDManager.this.updateOverlay();
            }
            if (DnDManager.this.downPos != null) {
                Point curPos = new Point(event.x, event.y);
                int dx = Math.abs(DnDManager.this.downPos.x - curPos.x);
                int dy = Math.abs(DnDManager.this.downPos.y - curPos.y);
                if (dx > 8 || dy > 8) {
                    DnDManager.this.downPos = null;
                    DnDManager.this.startDrag(DnDManager.this.downInfo);
                }
            }
        }
    };
    private MWindow baseWindow;

    public DnDManager(MWindow window) {
        this.baseWindow = window;
        if (this.baseWindow.getWidget() instanceof Shell) {
            Shell ctrl = (Shell)this.baseWindow.getWidget();
            this.display = ctrl.getDisplay();
            this.enableDragging(true);
            this.dndUtil = new DragAndDropUtil(this.display);
            ctrl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!DnDManager.this.display.isDisposed()) {
                        DnDManager.this.enableDragging(false);
                    }
                }
            });
        }
    }

    protected DragAndDropUtil.CursorInfo getDropInfo() {
        DragAndDropUtil.CursorInfo dropInfo = this.dndUtil.getCursorInfo();
        MUIElement dragElement = this.dragHost.getDragElement();
        if (dragElement instanceof MToolItem && !(dropInfo.curElement instanceof MToolBar)) {
            dropInfo.curElement = null;
        } else if (dragElement instanceof MPart) {
            MElementContainer parent;
            MPartStack stack = null;
            if (dropInfo.curElement instanceof MPartStack) {
                stack = (MPartStack)dropInfo.curElement;
            } else if (dropInfo.curElement instanceof MPart && (parent = dropInfo.curElement.getParent()) instanceof MPartStack) {
                stack = (MPartStack)parent;
            }
            dropInfo.curElement = stack;
        }
        return dropInfo;
    }

    protected void updateOverlay() {
        DragAndDropUtil.CursorInfo info = this.dndUtil.getCursorInfo();
        if (info.itemRect == null) {
            this.overlay.clear();
        } else if (info.itemElement != this.curOverlayElement) {
            this.overlay.clear();
            this.overlay.addOutline(info.itemRect, 2);
            this.curOverlayElement = info.itemElement;
        }
    }

    protected void cancelDrag() {
        this.overlay.dispose();
        this.overlay = null;
        this.dragHost.cancel();
        this.dragHost = null;
        this.setCursor(null);
    }

    private void setCursor(Cursor cursor) {
        Shell shell = (Shell)this.baseWindow.getWidget();
        shell.setCursor(cursor);
    }

    protected void endDrag(DragAndDropUtil.CursorInfo dndInfo) {
        if (this.overlay != null) {
            this.overlay.dispose();
            this.overlay = null;
        }
        if (this.dragHost == null) {
            return;
        }
        if (dndInfo.curElement == null) {
            MWindow theWindow = this.dragHost.getModel();
            theWindow.setToBeRendered(false);
            theWindow.getTags().remove((Object)"dragHost");
            theWindow.setToBeRendered(true);
        } else {
            if (!(dndInfo.curElement instanceof MElementContainer)) {
                dndInfo.curElement = dndInfo.curElement.getParent();
            }
            this.dragHost.drop((MElementContainer<MUIElement>)((MElementContainer)dndInfo.curElement), dndInfo.itemIndex);
        }
        this.dragHost = null;
        this.setCursor(null);
    }

    protected void startDrag(DragAndDropUtil.CursorInfo dndInfo) {
        MUIElement dragElement = dndInfo.curElement;
        if (dndInfo.itemElement != null) {
            dragElement = dndInfo.itemElement;
        }
        if (dragElement != null) {
            this.overlay = new Overlay((Shell)this.baseWindow.getWidget());
            this.dragHost = new DragHost(dragElement);
        }
    }

    public void enableDragging(boolean enable) {
        if (enable) {
            this.display.addFilter(5, this.mouseMoveListener);
            this.display.addFilter(3, this.mouseButtonListener);
            this.display.addFilter(4, this.mouseButtonListener);
            this.display.addFilter(1, this.keyListener);
            MWindow dragWindow = this.findDragHost();
            if (dragWindow != null) {
                this.dragHost = new DragHost((Shell)dragWindow.getWidget());
            }
        } else {
            if (this.dragHost != null) {
                this.cancelDrag();
            }
            this.display.removeFilter(5, this.mouseMoveListener);
            this.display.removeFilter(3, this.mouseButtonListener);
            this.display.removeFilter(4, this.mouseButtonListener);
            this.display.removeFilter(1, this.keyListener);
        }
    }

    private MWindow findDragHost() {
        for (MUIElement element : this.baseWindow.getChildren()) {
            if (element.getTags() == null || element.getTags().indexOf((Object)"dragHost") < 0) continue;
            return (MWindow)element;
        }
        return null;
    }
}

