/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.internal;

import java.io.IOException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.ContextChangeEvent;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.IRunAndTrack;
import org.eclipse.e4.core.internal.contexts.IEclipseContextStrategy;
import org.eclipse.e4.core.internal.services.EclipseAdapter;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.services.ActiveContextsFunction;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContext;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPerspective;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.swt.Activator;
import org.eclipse.e4.workbench.ui.IExceptionHandler;
import org.eclipse.e4.workbench.ui.internal.ActiveChildLookupFunction;
import org.eclipse.e4.workbench.ui.internal.ActivePartLookupFunction;
import org.eclipse.e4.workbench.ui.internal.E4Workbench;
import org.eclipse.e4.workbench.ui.internal.ExceptionHandler;
import org.eclipse.e4.workbench.ui.internal.ReflectionContributionFactory;
import org.eclipse.e4.workbench.ui.internal.ResourceHandler;
import org.eclipse.e4.workbench.ui.internal.WorkbenchLogger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class E4Application
implements IApplication {
    private String[] args;
    private ResourceHandler handler;
    private Display display = null;

    public Display getApplicationDisplay() {
        if (this.display == null) {
            this.display = Display.getDefault();
        }
        return this.display;
    }

    public Object start(IApplicationContext applicationContext) throws Exception {
        this.getApplicationDisplay();
        E4Workbench workbench = this.createE4Workbench(applicationContext);
        workbench.createAndRunUI((MApplicationElement)workbench.getApplication());
        this.saveModel();
        workbench.close();
        return 0;
    }

    public void saveModel() {
        try {
            this.handler.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public E4Workbench createE4Workbench(IApplicationContext applicationContext) {
        IContributionFactory factory;
        this.args = (String[])applicationContext.getArguments().get("application.args");
        IEclipseContext appContext = E4Application.createDefaultContext();
        String lifeCycleURI = this.getArgValue("lifeCycleURI", applicationContext);
        Object lcManager = null;
        if (lifeCycleURI != null && (lcManager = (factory = (IContributionFactory)appContext.get(IContributionFactory.class.getName())).create(lifeCycleURI, appContext)) != null) {
            factory.call(lcManager, null, "postContextCreate", appContext, null);
        }
        MApplication appModel = this.loadApplicationModel(applicationContext, appContext);
        appModel.setContext(appContext);
        if (!E4Workbench.getServiceContext().containsKey(MApplication.class.getName())) {
            E4Workbench.getServiceContext().set(MApplication.class.getName(), (Object)appModel);
        }
        appContext.set(MApplication.class.getName(), (Object)appModel);
        if (lcManager != null) {
            IContributionFactory factory2 = (IContributionFactory)appContext.get(IContributionFactory.class.getName());
            factory2.call(lcManager, null, "processAdditions", appContext, null);
            factory2.call(lcManager, null, "processRemovals", appContext, null);
        }
        String xmiURI = this.getArgValue("applicationXMI", applicationContext);
        appContext.set("applicationXMI", (Object)xmiURI);
        String cssURI = this.getArgValue("applicationCSS", applicationContext);
        appContext.set("applicationCSS", (Object)cssURI);
        String cssResourcesURI = this.getArgValue("applicationCSSResources", applicationContext);
        appContext.set("applicationCSSResources", (Object)cssResourcesURI);
        String presentationURI = this.getArgValue("presentationURI", applicationContext);
        if (presentationURI == null) {
            presentationURI = "platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.swt.internal.PartRenderingEngine";
        }
        appContext.set("presentationURI", (Object)presentationURI);
        E4Workbench workbench = new E4Workbench((MApplicationElement)appModel, appContext);
        return workbench;
    }

    private MApplication loadApplicationModel(IApplicationContext appContext, IEclipseContext eclipseContext) {
        MApplication theApp = null;
        Location instanceLocation = Activator.getDefault().getInstanceLocation();
        String appModelPath = this.getArgValue("applicationXMI", appContext);
        Assert.isNotNull((Object)appModelPath, (String)"applicationXMI argument missing");
        URI initialWorkbenchDefinitionInstance = URI.createPlatformPluginURI((String)appModelPath, (boolean)true);
        boolean saveAndRestore = true;
        this.handler = new ResourceHandler(instanceLocation, initialWorkbenchDefinitionInstance, saveAndRestore, (Logger)eclipseContext.get(Logger.class.getName()));
        Resource resource = this.handler.loadMostRecentModel();
        theApp = (MApplication)resource.getContents().get(0);
        return theApp;
    }

    private String getArgValue(String argName, IApplicationContext appContext) {
        if (argName == null || argName.length() == 0) {
            return null;
        }
        int i = 0;
        while (i < this.args.length) {
            if (argName.equals(this.args[i])) {
                return this.args[i + 1];
            }
            i += 2;
        }
        return appContext.getBrandingProperty(argName);
    }

    public void stop() {
    }

    public static IEclipseContext createDefaultContext() {
        return E4Application.createDefaultContext(null);
    }

    public static IEclipseContext createDefaultContext(IEclipseContextStrategy strategy) {
        IEclipseContext serviceContext = E4Workbench.getServiceContext();
        final IEclipseContext appContext = EclipseContextFactory.create((IEclipseContext)serviceContext, (IEclipseContextStrategy)strategy);
        appContext.set("debugString", (Object)"WorkbenchAppContext");
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        ReflectionContributionFactory contributionFactory = new ReflectionContributionFactory(registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        appContext.set(Logger.class.getName(), ContextInjectionFactory.inject((Object)new WorkbenchLogger(), (IEclipseContext)appContext));
        appContext.set(Adapter.class.getName(), ContextInjectionFactory.inject((Object)new EclipseAdapter(), (IEclipseContext)appContext));
        appContext.set("debugString", (Object)"WorkbenchContext");
        appContext.set(ContextManager.class.getName(), (Object)new ContextManager());
        appContext.set("activeContexts", (Object)new ActiveContextsFunction());
        appContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        appContext.runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                Object o = appContext.get("e4ActivePart");
                if (o instanceof MPart) {
                    appContext.set("activePartId", (Object)((MPart)o).getId());
                }
                return true;
            }

            public String toString() {
                return "activePartId";
            }
        }, null);
        appContext.set("partServiceRoot", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, Object[] arguments) {
                MContext perceivedRoot = (MContext)context.get(MWindow.class.getName());
                if (perceivedRoot == null && (perceivedRoot = (MContext)context.get(MApplication.class.getName())) == null) {
                    return null;
                }
                IEclipseContext current = perceivedRoot.getContext();
                if (current == null) {
                    return null;
                }
                IEclipseContext next = (IEclipseContext)current.getLocal("activeChildContext");
                while (next != null) {
                    current = next;
                    next = (IEclipseContext)current.getLocal("activeChildContext");
                }
                Object object = current.get(MPerspective.class.getName());
                if (object == null) {
                    MUIElement window = (MUIElement)current.get(MWindow.class.getName());
                    MElementContainer parent = window.getParent();
                    while (parent != null && !(parent instanceof MApplication)) {
                        window = parent;
                        parent = parent.getParent();
                    }
                    return window;
                }
                return object;
            }
        });
        appContext.set(IExceptionHandler.class.getName(), (Object)exceptionHandler);
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set("activeShell", (Object)new ActiveChildLookupFunction("activeShell", "localActiveShell"));
        appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

            public void setClassname(Object widget, String classname) {
            }

            public void setId(Object widget, String id) {
            }

            public void style(Object widget) {
            }
        });
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        appContext.set(IEclipseContext.class.getName(), (Object)appContext);
        appContext.set(IShellProvider.class.getName(), (Object)new IShellProvider(){

            public Shell getShell() {
                return null;
            }
        });
        return appContext;
    }
}

