/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtiltities;
import org.eclipse.e4.workbench.ui.IResourceUtiltities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtility
implements ISWTResourceUtiltities {
    public static final String PROTOCOL = "bundle-resource://";
    private ImageRegistry IMAGE_REGISTRY = new ImageRegistry();
    private ColorRegistry COLOR_REGISTRY = new ColorRegistry();
    private final PackageAdmin packageAdmin;

    public ResourceUtility(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    public ImageDescriptor resolveIconResource(String resource) {
        String bundle = resource.substring(PROTOCOL.length(), resource.indexOf("/", PROTOCOL.length()));
        String path = resource.substring(bundle.length() + PROTOCOL.length());
        Image rv = this.IMAGE_REGISTRY.get(resource);
        if (rv == null) {
            ImageDescriptor desc = this.imageDescriptorFromPlugin(bundle, path);
            rv = desc.createImage();
            this.IMAGE_REGISTRY.put(resource, rv);
        }
        return ImageDescriptor.createFromImage((Image)rv);
    }

    private Bundle getBundle(String bundleName) {
        Bundle[] bundles = this.packageAdmin.getBundles(bundleName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public ImageDescriptor imageDescriptorFromPlugin(String pluginId, String imageFilePath) {
        if (pluginId == null || imageFilePath == null) {
            throw new IllegalArgumentException();
        }
        Bundle bundle = this.getBundle(pluginId);
        if ((bundle.getState() & 0x3C) == 0) {
            return null;
        }
        URL fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path(imageFilePath), null);
        if (fullPathString == null) {
            try {
                fullPathString = new URL(imageFilePath);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (fullPathString == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)fullPathString);
    }

    public ColorDescriptor getColor(String colorDefinition) {
        ColorDescriptor desc;
        RGB rgb = new RGB(255, 255, 255);
        if (colorDefinition.indexOf("rgb") != -1) {
            Pattern p = Pattern.compile("\\d+");
            Matcher m = p.matcher(colorDefinition);
            int valCount = 0;
            while (m.find()) {
                int val = 0;
                try {
                    val = Integer.parseInt(m.group());
                }
                catch (NumberFormatException numberFormatException) {}
                if (val < 0) {
                    val = 0;
                }
                if (val > 255) {
                    val = 255;
                }
                if (valCount == 0) {
                    rgb.red = val;
                } else if (valCount == 1) {
                    rgb.green = val;
                } else {
                    rgb.blue = val;
                }
                if (++valCount == 3) break;
            }
        }
        if (!this.COLOR_REGISTRY.hasValueFor(rgb.toString())) {
            this.COLOR_REGISTRY.put(rgb.toString(), rgb);
            desc = this.COLOR_REGISTRY.getColorDescriptor(rgb.toString());
        } else {
            desc = this.COLOR_REGISTRY.getColorDescriptor(rgb.toString());
        }
        return desc;
    }

    public IResourceUtiltities.Gradient<ColorDescriptor> getGradientColors(String gradientDefinition) {
        String[] gradientparts = gradientDefinition.split(";");
        String[] colors = gradientparts[0].split("-");
        ArrayList<ColorDescriptor> descs = new ArrayList<ColorDescriptor>(colors.length);
        int i = 0;
        String[] stringArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            String color = stringArray[n2];
            descs.add(this.getColor(color));
            ++n2;
        }
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(gradientparts[1]);
        ArrayList<Integer> vals = new ArrayList<Integer>();
        while (m.find()) {
            int val = 0;
            try {
                val = Integer.parseInt(m.group());
            }
            catch (NumberFormatException numberFormatException) {}
            if (val > 100) {
                val = 100;
            }
            vals.add(val);
        }
        int[] iVals = new int[vals.size()];
        i = 0;
        for (Integer v : vals) {
            iVals[i++] = v;
        }
        return new IResourceUtiltities.Gradient(descs, iVals, gradientparts.length == 3 && gradientparts[2].indexOf("true") != -1);
    }

    public ImageDescriptor imageDescriptorFromURI(URI iconPath) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(iconPath.toString()));
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("iconURI \"" + iconPath.toString() + "\" is invalid, no image will be shown");
            return null;
        }
    }
}

