/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.trim;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.core.di.annotations.PreDestroy;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ItemType;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MDirectToolItem;
import org.eclipse.e4.ui.model.application.MPerspective;
import org.eclipse.e4.ui.model.application.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.MToolBar;
import org.eclipse.e4.ui.model.application.MToolItem;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindowTrim;
import org.eclipse.e4.ui.model.application.SideValue;
import org.eclipse.e4.workbench.modeling.EModelService;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PerspectiveSwitcher {
    public static final String PERSPECTIVE_SWITCHER_ID = "org.eclipse.e4.ui.PerspectiveSwitcher";
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    private MToolBar perspectiveSwitcherTB;
    private EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MPerspective oldSel;
            MToolItem oldSelItem;
            if (PerspectiveSwitcher.this.perspectiveSwitcherTB == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MPerspectiveStack perspStack = (MPerspectiveStack)changedElement;
            if (!perspStack.isToBeRendered()) {
                return;
            }
            this.clearCurSelection();
            MToolItem psItem = PerspectiveSwitcher.this.getItemFor((MPerspective)perspStack.getSelectedElement());
            if (psItem != null) {
                psItem.setSelected(true);
            }
            if (event.getProperty("OldValue") instanceof MPerspective && (oldSelItem = PerspectiveSwitcher.this.getItemFor(oldSel = (MPerspective)event.getProperty("OldValue"))) != null) {
                oldSelItem.setSelected(false);
            }
        }

        private void clearCurSelection() {
            for (MToolItem ti : PerspectiveSwitcher.this.perspectiveSwitcherTB.getChildren()) {
                if (!ti.isSelected()) continue;
                ti.setSelected(false);
            }
        }
    };
    private EventHandler toBeRenderedHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (PerspectiveSwitcher.this.perspectiveSwitcherTB == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspective)) {
                return;
            }
            MPerspective persp = (MPerspective)changedElement;
            if (!persp.getParent().isToBeRendered()) {
                return;
            }
            if (changedElement.isToBeRendered()) {
                PerspectiveSwitcher.this.addPerspectiveItem(persp);
            } else {
                PerspectiveSwitcher.this.removePerspectiveItem(persp);
            }
        }
    };
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (PerspectiveSwitcher.this.perspectiveSwitcherTB == null) {
                return;
            }
            Object changedObj = event.getProperty("ChangedElement");
            if (!(changedObj instanceof MPerspectiveStack)) {
                return;
            }
            MPerspectiveStack perspStack = (MPerspectiveStack)changedObj;
            if (!perspStack.isToBeRendered()) {
                return;
            }
            String eventType = (String)event.getProperty("EventType");
            if ("ADD".equals(eventType)) {
                MPerspective added = (MPerspective)event.getProperty("NewValue");
                if (!added.isToBeRendered()) {
                    return;
                }
                MToolItem psItem = PerspectiveSwitcher.this.addPerspectiveItem(added);
                PerspectiveSwitcher.this.perspectiveSwitcherTB.getChildren().add((Object)psItem);
                ToolBar tb = (ToolBar)PerspectiveSwitcher.this.perspectiveSwitcherTB.getWidget();
                tb.pack();
                tb.getParent().layout(new Control[]{tb}, 4);
            } else if ("REMOVE".equals(eventType)) {
                MPerspective removed = (MPerspective)event.getProperty("OldValue");
                if (!removed.isToBeRendered()) {
                    return;
                }
                PerspectiveSwitcher.this.removePerspectiveItem(removed);
                ToolBar tb = (ToolBar)PerspectiveSwitcher.this.perspectiveSwitcherTB.getWidget();
                tb.pack();
                tb.getParent().layout(new Control[]{tb}, 4);
            }
        }
    };

    @PostConstruct
    void init(IEclipseContext context) {
        System.out.println("init");
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/ElementContainer", (String)"children"), this.childrenHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/UIElement", (String)"toBeRendered"), this.toBeRenderedHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/ElementContainer", (String)"selectedElement"), this.selectionHandler);
    }

    @PreDestroy
    private void removeListeners() {
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.selectionHandler);
    }

    public void postContextCreate(IEclipseContext context) {
        System.out.println("postContextCreate");
    }

    public void processAdditions(MApplication appModel) {
        System.out.println("processAdditions");
    }

    public void processRemovals(MApplication appModel) {
        System.out.println("processRemovals");
        this.perspectiveSwitcherTB = (MToolBar)this.modelService.find(PERSPECTIVE_SWITCHER_ID, (MUIElement)appModel);
        if (this.perspectiveSwitcherTB != null) {
            return;
        }
        List psList = this.modelService.findElements((MUIElement)appModel, null, MPerspectiveStack.class, null);
        for (MPerspectiveStack ps : psList) {
            if (!ps.isToBeRendered()) continue;
            this.addSwitcher(appModel, ps);
        }
    }

    private void addSwitcher(MApplication appModel, MPerspectiveStack ps) {
        List trimList = this.modelService.findElements((MUIElement)appModel, null, MWindowTrim.class, null);
        for (MWindowTrim trim : trimList) {
            if (trim.getSide() != SideValue.TOP) continue;
            this.perspectiveSwitcherTB = MApplicationFactory.eINSTANCE.createToolBar();
            this.perspectiveSwitcherTB.setId(PERSPECTIVE_SWITCHER_ID);
            for (MPerspective persp : ps.getChildren()) {
                if (!persp.isToBeRendered()) continue;
                MToolItem psItem = this.addPerspectiveItem(persp);
                psItem.setSelected(persp == ps.getSelectedElement());
            }
            trim.getChildren().add((Object)this.perspectiveSwitcherTB);
        }
    }

    private MToolItem addPerspectiveItem(MPerspective persp) {
        MDirectToolItem psItem = MApplicationFactory.eINSTANCE.createDirectToolItem();
        psItem.setId(persp.getId());
        psItem.setLabel(persp.getLabel());
        psItem.setIconURI(persp.getIconURI());
        psItem.setTooltip(persp.getTooltip());
        psItem.setType(ItemType.CHECK);
        psItem.setURI("platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.trim.SwitchPerspective");
        this.perspectiveSwitcherTB.getChildren().add((Object)psItem);
        return psItem;
    }

    protected MToolItem getItemFor(MPerspective persp) {
        return (MToolItem)this.modelService.find(persp.getId(), (MUIElement)this.perspectiveSwitcherTB);
    }

    private void removePerspectiveItem(MPerspective toRemove) {
        MToolItem psItem = this.getItemFor(toRemove);
        if (psItem != null) {
            this.perspectiveSwitcherTB.getChildren().remove((Object)psItem);
        }
    }
}

