/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MContext;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MGenericStack;
import org.eclipse.e4.ui.model.application.MGenericTile;
import org.eclipse.e4.ui.model.application.MPSCElement;
import org.eclipse.e4.ui.model.application.MPartSashContainer;
import org.eclipse.e4.ui.model.application.MPerspective;
import org.eclipse.e4.ui.model.application.MPlaceholder;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelServiceImpl
implements EModelService {
    private boolean match(MUIElement element, String id, Class clazz, List<String> tagsToMatch) {
        if (id != null && !id.equals(element.getId())) {
            return false;
        }
        if (clazz != null && !clazz.isInstance(element)) {
            return false;
        }
        if (tagsToMatch != null) {
            EList elementTags = element.getTags();
            for (String tag : tagsToMatch) {
                if (elementTags.contains((Object)tag)) continue;
                return false;
            }
        }
        return true;
    }

    private <T> void findElementsRecursive(MUIElement searchRoot, String id, Class<? extends T> type, List<String> tagsToMatch, List<T> elements) {
        if (this.match(searchRoot, id, type, tagsToMatch)) {
            elements.add(searchRoot);
        }
        if (searchRoot instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)searchRoot;
            EList children = container.getChildren();
            for (MUIElement child : children) {
                this.findElementsRecursive(child, id, type, tagsToMatch, elements);
            }
        }
    }

    @Override
    public <T> List<T> findElements(MUIElement searchRoot, String id, Class<T> clazz, List<String> tagsToMatch) {
        ArrayList elements = new ArrayList();
        this.findElementsRecursive(searchRoot, id, clazz, tagsToMatch, elements);
        return elements;
    }

    @Override
    public MUIElement find(String id, MUIElement searchRoot) {
        if (id == null || id.length() == 0) {
            return null;
        }
        List elements = this.findElements(searchRoot, id, null, null);
        if (elements.size() > 0) {
            return (MUIElement)elements.get(0);
        }
        return null;
    }

    @Override
    public IEclipseContext getContainingContext(MUIElement element) {
        MElementContainer curParent = element.getParent();
        while (curParent != null) {
            if (curParent instanceof MContext) {
                return ((MContext)curParent).getContext();
            }
            curParent = curParent.getParent();
        }
        return null;
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent) {
        this.move(element, newParent, -1, false);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, boolean leavePlaceholder) {
        this.move(element, newParent, -1, leavePlaceholder);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, int index) {
        this.move(element, newParent, index, false);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, int index, boolean leavePlaceholder) {
        MElementContainer curParent = element.getParent();
        int curIndex = curParent.getChildren().indexOf((Object)element);
        newParent.getChildren().add(index, (Object)element);
        if (leavePlaceholder) {
            MPlaceholder ph = MApplicationFactory.eINSTANCE.createPlaceholder();
            ph.setRef(element);
            curParent.getChildren().add(curIndex, (Object)ph);
        }
    }

    @Override
    public void swap(MPlaceholder placeholder) {
        MUIElement element = placeholder.getRef();
        MElementContainer elementParent = element.getParent();
        int elementIndex = elementParent.getChildren().indexOf((Object)element);
        MElementContainer phParent = placeholder.getParent();
        int phIndex = phParent.getChildren().indexOf((Object)placeholder);
        elementParent.getChildren().remove((Object)element);
        phParent.getChildren().remove((Object)placeholder);
        boolean onTop = element.isOnTop();
        boolean vis = element.isVisible();
        boolean tbr = element.isToBeRendered();
        element.setOnTop(placeholder.isOnTop());
        element.setVisible(placeholder.isVisible());
        element.setToBeRendered(placeholder.isToBeRendered());
        placeholder.setOnTop(onTop);
        placeholder.setVisible(vis);
        placeholder.setToBeRendered(tbr);
        elementParent.getChildren().add(elementIndex, (Object)placeholder);
        phParent.getChildren().add(phIndex, (Object)element);
    }

    public void selectStackElement(MGenericStack<MUIElement> stack, MUIElement element) {
        assert (stack.getChildren().indexOf((Object)element) >= 0);
        ArrayList<MUIElement> goingHidden = new ArrayList<MUIElement>();
        MUIElement curSel = stack.getSelectedElement();
        this.hideElementRecursive(curSel, goingHidden);
        ArrayList<MUIElement> becomingVisible = new ArrayList<MUIElement>();
        this.showElementRecursive(element, becomingVisible);
    }

    private void hideElementRecursive(MUIElement element, List<MUIElement> goingHidden) {
        if (element.getWidget() == null) {
            return;
        }
        if (element instanceof MWindow && element.getWidget() != null) {
            element.setVisible(false);
        }
        goingHidden.add(element);
        if (element instanceof MGenericTile) {
            MGenericTile container = (MGenericTile)element;
            for (MUIElement childElement : container.getChildren()) {
                this.hideElementRecursive(childElement, goingHidden);
            }
        } else if (element instanceof MGenericStack) {
            MGenericStack container = (MGenericStack)element;
            MUIElement curSel = container.getSelectedElement();
            this.hideElementRecursive(curSel, goingHidden);
        }
    }

    private void showElementRecursive(MUIElement element, List<MUIElement> becomingVisible) {
        if (!element.isToBeRendered()) {
            return;
        }
        if (element instanceof MPlaceholder) {
            this.swap((MPlaceholder)element);
            element = ((MPlaceholder)element).getRef();
        }
        if (element instanceof MWindow && element.getWidget() != null) {
            element.setVisible(true);
        }
        becomingVisible.add(element);
        if (element instanceof MGenericTile) {
            MGenericTile container = (MGenericTile)element;
            for (MUIElement childElement : container.getChildren()) {
                this.showElementRecursive(childElement, becomingVisible);
            }
        } else if (element instanceof MGenericStack) {
            MGenericStack container = (MGenericStack)element;
            MUIElement curSel = container.getSelectedElement();
            this.showElementRecursive(curSel, becomingVisible);
        }
    }

    private void combine(MPSCElement toInsert, MPSCElement relTo, MPartSashContainer newSash, boolean newFirst, int ratio) {
        MElementContainer curParent = relTo.getParent();
        int index = curParent.getChildren().indexOf((Object)relTo);
        curParent.getChildren().remove((Object)relTo);
        if (newFirst) {
            newSash.getChildren().add((Object)toInsert);
            newSash.getChildren().add((Object)relTo);
        } else {
            newSash.getChildren().add((Object)relTo);
            newSash.getChildren().add((Object)toInsert);
        }
        toInsert.setContainerData(Integer.toString(ratio));
        relTo.setContainerData(Integer.toString(100 - ratio));
        curParent.getChildren().add(index, (Object)newSash);
    }

    @Override
    public void insert(MPSCElement toInsert, MPSCElement relTo, int where, int ratio) {
        if (toInsert == null || relTo == null) {
            return;
        }
        if (ratio == 0) {
            ratio = 10;
        }
        if (ratio > 100) {
            ratio = 90;
        }
        boolean newFirst = where == 0 || where == 2;
        MElementContainer insertRoot = relTo.getParent();
        while (insertRoot != null && !(insertRoot instanceof MWindow) && !(insertRoot instanceof MPartSashContainer)) {
            relTo = (MPSCElement)insertRoot;
            insertRoot = insertRoot.getParent();
        }
        if (insertRoot instanceof MWindow) {
            MPartSashContainer newSash = ApplicationFactoryImpl.eINSTANCE.createPartSashContainer();
            newSash.setHorizontal(where == 2 || where == 3);
            this.combine(toInsert, relTo, newSash, newFirst, ratio);
        } else if (insertRoot instanceof MGenericTile) {
            MGenericTile curTile = (MGenericTile)insertRoot;
            if (curTile.isHorizontal() && (where == 0 || where == 1)) {
                MPartSashContainer newSash = ApplicationFactoryImpl.eINSTANCE.createPartSashContainer();
                newSash.setHorizontal(false);
                newSash.setContainerData(relTo.getContainerData());
                this.combine(toInsert, relTo, newSash, newFirst, ratio);
            } else if (!(curTile.isHorizontal() || where != 2 && where != 3)) {
                MPartSashContainer newSash = ApplicationFactoryImpl.eINSTANCE.createPartSashContainer();
                newSash.setHorizontal(true);
                newSash.setContainerData(relTo.getContainerData());
                this.combine(toInsert, relTo, newSash, newFirst, ratio);
            } else {
                int relToIndex = relTo.getParent().getChildren().indexOf((Object)relTo);
                if (newFirst) {
                    curTile.getChildren().add(relToIndex, (Object)toInsert);
                } else {
                    curTile.getChildren().add(relToIndex + 1, (Object)toInsert);
                }
                int relToWeight = 100;
                if (relTo.getContainerData() != null) {
                    try {
                        relToWeight = Integer.parseInt(relTo.getContainerData());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                int toInsertWeight = (int)((double)ratio / 100.0 * (double)relToWeight + 0.5);
                relTo.setContainerData(Integer.toString(relToWeight -= toInsertWeight));
                toInsert.setContainerData(Integer.toString(toInsertWeight));
            }
        }
    }

    @Override
    public void detach(MPSCElement element) {
        MElementContainer curParent = element.getParent();
        while (curParent != null && !(curParent instanceof MPerspective) && !(curParent instanceof MWindow)) {
            curParent = curParent.getParent();
        }
        if (curParent == null) {
            return;
        }
        MWindow newWindow = MApplicationFactory.eINSTANCE.createWindow();
        newWindow.setX(100);
        newWindow.setY(100);
        newWindow.setWidth(400);
        newWindow.setHeight(250);
        element.getParent().getChildren().remove((Object)element);
        newWindow.getChildren().add((Object)element);
        MElementContainer windowParent = curParent;
        windowParent.getChildren().add((Object)newWindow);
    }
}

