/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.editor.dnd.palette;

import org.eclipse.e4.xwt.tools.ui.designer.core.editor.Designer;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.dnd.DropAdapter;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.dnd.DropContext;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.text.StructuredTextHelper;
import org.eclipse.e4.xwt.tools.ui.palette.ContextType;
import org.eclipse.e4.xwt.tools.ui.palette.Entry;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.w3c.dom.Node;

public class PaletteDropAdapter
implements DropAdapter {
    static final int CARET_WIDTH = 2;
    protected int dropCaretOffset = -1;
    protected Designer designer;
    protected LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
    protected DropContext context;
    protected Entry entry;

    public PaletteDropAdapter(Designer designer, DropContext context) {
        this.designer = designer;
        this.context = context;
    }

    public void drop(DropTargetEvent event) {
        Object selection = this.getSelection();
        if (!this.isAccept() || !(selection instanceof Entry)) {
            return;
        }
        final Template template = this.createTemplate(this.entry);
        if (template == null) {
            return;
        }
        Runnable dropRunnable = new Runnable(){

            public void run() {
                PaletteDropAdapter.this.drop(template, PaletteDropAdapter.this.dropCaretOffset, 0);
            }
        };
        this.designer.formatWithCompound(dropRunnable);
    }

    protected void drop(Template template, int dropCaretOffset, int length) {
        TemplateContextType type;
        DocumentTemplateContext templateContext;
        IDocument document = this.designer.getTextViewer().getDocument();
        ContextTypeRegistry registry = XMLUIPlugin.getDefault().getTemplateContextRegistry();
        if (registry != null && (templateContext = new DocumentTemplateContext(type = registry.getContextType(template.getContextTypeId()), document, new Position(dropCaretOffset, length))).canEvaluate(template)) {
            try {
                TemplateBuffer templateBuffer = templateContext.evaluate(template);
                String templateString = templateBuffer.getString();
                document.replace(dropCaretOffset, length, templateString);
                StyledText styledText = this.designer.getTextWidget();
                int position = this.getCursorOffset(templateBuffer) + dropCaretOffset;
                styledText.setCaretOffset(position);
                styledText.setFocus();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Template createTemplate(Entry entry) {
        return new Template(entry.getName(), "", this.getContextType().getName(), entry.getContent(), true);
    }

    protected int getCursorOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    public void dragOver(DropTargetEvent event) {
        if (!this.isAccept() || !(this.getSelection() instanceof Entry)) {
            return;
        }
        this.entry = (Entry)this.getSelection();
        Node node = this.getCurrentNode(event);
        int position = this.context.findDropPosition(node, this.getScope(), this.getContextType(), this.getCursor(event));
        if (position < 0) {
            event.detail = 0;
        } else {
            StyledText styledText = this.designer.getTextWidget();
            this.setDropCaretOffset(position);
            this.refreshCaret(styledText, this.getDropCaretOffset());
            event.detail = 1;
        }
    }

    protected Node getCurrentNode(DropTargetEvent event) {
        StructuredTextViewer textViewer = this.designer.getTextEditor().getTextViewer();
        return StructuredTextHelper.getNode((ITextViewer)textViewer, this.getCursor(event));
    }

    protected int getCursor(DropTargetEvent event) {
        StructuredTextViewer textViewer = this.designer.getTextEditor().getTextViewer();
        return StructuredTextHelper.getOffsetAtPoint((ITextViewer)textViewer, new Point(event.x, event.y));
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
        StyledText styledText = this.designer.getTextWidget();
        if (this.getDropCaretOffset() != -1) {
            this.refreshCaret(styledText, this.getDropCaretOffset());
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    protected void refreshCaret(StyledText text, int newOffset) {
        if (newOffset != -1) {
            Point newPos = text.getLocationAtOffset(newOffset);
            int newHeight = text.getLineHeight(newOffset);
            text.redraw(newPos.x, newPos.y, 2, newHeight, false);
        }
    }

    public void setDesigner(Designer editor) {
        this.designer = editor;
    }

    public Designer getDesigner() {
        return this.designer;
    }

    protected Object getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.transfer.getSelection();
        if (selection != null) {
            return selection.getFirstElement();
        }
        return null;
    }

    public boolean isAccept() {
        Object selection = this.getSelection();
        if (selection == null) {
            return false;
        }
        return this.isAccept(selection);
    }

    protected boolean isAccept(Object selection) {
        return selection instanceof Entry;
    }

    public void setDropCaretOffset(int dropCaretOffset) {
        this.dropCaretOffset = dropCaretOffset;
    }

    public int getDropCaretOffset() {
        return this.dropCaretOffset;
    }

    public ContextType getContextType() {
        return this.entry.getContext();
    }

    public String getScope() {
        return this.entry.getScope();
    }
}

