/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.parts.tools;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.xwt.tools.ui.designer.core.parts.tools.SelectionHandle;
import org.eclipse.swt.graphics.Color;

public class FocusBorder
extends LineBorder {
    public FocusBorder() {
        this.setColor(ColorConstants.blue);
        this.setWidth(1);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        if (figure instanceof SelectionHandle) {
            IFigure ownerFigure = ((SelectionHandle)figure).getOwnerFigure();
            Rectangle r = ownerFigure.getBounds().getCopy();
            tempRect.setBounds(r);
        } else {
            Rectangle paintRectangle = FocusBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
            tempRect.setBounds(paintRectangle);
        }
        if (this.getWidth() % 2 == 1) {
            --FocusBorder.tempRect.width;
            --FocusBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.setLineWidth(this.getWidth());
        graphics.setLineStyle(this.getStyle());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.drawRectangle(tempRect);
    }

    public static Border getBorder(Color color, int width) {
        FocusBorder focusBorder = new FocusBorder();
        focusBorder.setColor(color);
        focusBorder.setWidth(width);
        return focusBorder;
    }

    public static Border getDefaultBorder() {
        return new FocusBorder();
    }
}

