/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.util.swt;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.swt.WidgetLocator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SWTTools {
    public static Shell activeShell() {
        Control focusControl;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if ((focusControl = display.getFocusControl()) != null && !focusControl.isDisposed()) {
            focusControl.getShell().open();
            return focusControl.getShell();
        }
        Shell shell = display.getActiveShell();
        if (shell != null) {
            return shell;
        }
        Shell[] shells = display.getShells();
        if (shells != null) {
            Shell[] shellArray = shells;
            if (shells.length != 0) {
                Shell topShell = shellArray[0];
                return topShell;
            }
        }
        return null;
    }

    public static Point getLocation(Widget widget) {
        if (widget == null || widget.isDisposed()) {
            return new Point(-1, -1);
        }
        if (widget instanceof Control) {
            Control control = (Control)widget;
            Point location = control.getLocation();
            if (control instanceof Shell) {
                location.x = 20;
                location.y = 20;
                return location;
            }
            Composite parent = control.getParent();
            if (parent instanceof Shell) {
                Point l = SWTTools.getOffset((Scrollable)((Shell)parent));
                location.x += l.x;
                location.y += l.y;
            } else if (SWTTools.checkStyle((Widget)parent, 2048)) {
                int borderWidth = parent.getBorderWidth();
                location.x += borderWidth;
                location.y += borderWidth;
            }
            return location;
        }
        return WidgetLocator.getLocation(widget);
    }

    public static Point getOffset(Scrollable scroll) {
        if (scroll == null || scroll.isDisposed()) {
            return new Point(0, 0);
        }
        Rectangle calced = scroll.computeTrim(0, 0, 0, 0);
        Point point = new Point(-calced.x, -calced.y);
        return point;
    }

    public static Point getSize(Control control) {
        if (control == null || control.isDisposed()) {
            return new Point(-1, -1);
        }
        Point size = control.getSize();
        return size;
    }

    public static Rectangle getBounds(Widget widget) {
        if (widget instanceof Control) {
            Control control = (Control)widget;
            Point l = SWTTools.getLocation((Widget)control);
            Point s = SWTTools.getSize(control);
            return new Rectangle(l.x, l.y, s.x, s.y);
        }
        return WidgetLocator.getBounds(widget, false);
    }

    public static Widget[] getChildren(Widget widget) {
        int n;
        Object[] objectArray;
        Menu menuBar;
        if (widget == null || widget.isDisposed()) {
            return new Widget[0];
        }
        ArrayList<Object> children = new ArrayList<Object>();
        if (widget instanceof Composite) {
            Control[] controlArray = ((Composite)widget).getChildren();
            int n2 = controlArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Control control = controlArray[n3];
                children.add(control);
                ++n3;
            }
        }
        if (widget instanceof Decorations && (menuBar = ((Decorations)widget).getMenuBar()) != null) {
            children.add(menuBar);
        }
        try {
            Object[] items;
            Method getItemsMethod = widget.getClass().getDeclaredMethod("getItems", new Class[0]);
            objectArray = items = (Object[])getItemsMethod.invoke((Object)widget, new Object[0]);
            n = items.length;
            int n4 = 0;
            while (n4 < n) {
                Object item = objectArray[n4];
                children.add((Widget)item);
                ++n4;
            }
        }
        catch (Exception exception) {}
        if (widget instanceof Item) {
            try {
                Method getControlMethod = widget.getClass().getDeclaredMethod("getControl", new Class[0]);
                Object control = getControlMethod.invoke((Object)widget, new Object[0]);
                if (control != null) {
                    children.add((Widget)control);
                }
            }
            catch (Exception exception) {}
        }
        try {
            Method getMenuMethod = widget.getClass().getDeclaredMethod("getMenu", new Class[0]);
            Object menu = getMenuMethod.invoke((Object)widget, new Object[0]);
            if (menu != null) {
                children.add((Widget)menu);
            }
        }
        catch (Exception exception) {}
        try {
            Object[] columns;
            Method getColumnsMethod = widget.getClass().getDeclaredMethod("getColumns", new Class[0]);
            objectArray = columns = (Object[])getColumnsMethod.invoke((Object)widget, new Object[0]);
            n = columns.length;
            int n5 = 0;
            while (n5 < n) {
                Object col = objectArray[n5];
                children.add((Widget)col);
                ++n5;
            }
        }
        catch (Exception exception) {}
        return children.toArray(new Widget[children.size()]);
    }

    public static boolean checkStyle(Widget widget, int style) {
        return widget != null && !widget.isDisposed() && SWTTools.checkStyle(widget.getStyle(), style);
    }

    public static boolean checkStyle(int styles, int style) {
        return (styles & style) != 0;
    }
}

