/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.commands;

import java.util.ArrayList;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.commands.Command;

public class AddItemsCommand
extends Command {
    private XamlElement parent;
    private String[] newItems;
    private String[] oldItems;

    public AddItemsCommand(XamlElement parent, String[] items) {
        this.parent = parent;
        this.newItems = items;
    }

    public boolean canExecute() {
        return this.parent != null;
    }

    public void execute() {
        IMetaclass metaclass = XWTUtility.getMetaclass((XamlNode)this.parent);
        if (metaclass == null || metaclass.findProperty("items") == null) {
            return;
        }
        this.addItems(this.newItems);
    }

    private void addItems(String[] newItems) {
        XamlElement xArray;
        XamlAttribute itemsAttr = this.parent.getAttribute("items", "http://www.eclipse.org/xwt/presentation");
        XamlElement xamlElement = xArray = itemsAttr == null ? null : itemsAttr.getChild("Array", "http://www.eclipse.org/xwt");
        if (itemsAttr == null) {
            itemsAttr = XamlFactory.eINSTANCE.createAttribute("items", "http://www.eclipse.org/xwt/presentation");
        }
        if (newItems == null || newItems.length == 0) {
            if (xArray != null) {
                itemsAttr.getChildNodes().remove((Object)xArray);
            } else {
                itemsAttr.getChildNodes().clear();
            }
            this.parent.getAttributes().remove((Object)itemsAttr);
            return;
        }
        ArrayList oldItemsElements = new ArrayList();
        if (xArray != null) {
            oldItemsElements.addAll(xArray.getChildNodes());
        } else {
            oldItemsElements.addAll(itemsAttr.getChildNodes());
        }
        ArrayList<String> items = new ArrayList<String>();
        for (XamlElement xamlElement2 : oldItemsElements) {
            items.add(xamlElement2.getValue());
        }
        if (!items.isEmpty()) {
            this.oldItems = items.toArray(new String[0]);
        }
        if (newItems.equals(this.oldItems)) {
            return;
        }
        if (oldItemsElements.isEmpty()) {
            int i = 0;
            while (i < newItems.length) {
                String item = newItems[i];
                XamlElement itemElement = XamlFactory.eINSTANCE.createElement("String", "clr-namespace:java.lang");
                itemElement.setValue(item);
                if (xArray != null) {
                    xArray.getChildNodes().add((Object)itemElement);
                } else {
                    itemsAttr.getChildNodes().add((Object)itemElement);
                }
                ++i;
            }
        } else {
            ArrayList removable = new ArrayList(oldItemsElements);
            int i = 0;
            while (i < newItems.length) {
                String item = newItems[i];
                XamlElement itemElement = null;
                try {
                    itemElement = (XamlElement)oldItemsElements.get(i);
                }
                catch (Exception exception) {}
                if (itemElement == null) {
                    itemElement = XamlFactory.eINSTANCE.createElement("String", "clr-namespace:java.lang");
                }
                removable.remove(itemElement);
                itemElement.setValue(item);
                if (xArray != null) {
                    if (!xArray.getChildNodes().contains((Object)itemElement)) {
                        xArray.getChildNodes().add((Object)itemElement);
                    }
                } else if (!itemsAttr.getChildNodes().contains((Object)itemElement)) {
                    itemsAttr.getChildNodes().add((Object)itemElement);
                }
                ++i;
            }
            for (XamlElement remove : removable) {
                if (xArray != null) {
                    xArray.getChildNodes().remove((Object)remove);
                    continue;
                }
                itemsAttr.getChildNodes().remove((Object)remove);
            }
        }
        if (!this.parent.getAttributes().contains((Object)itemsAttr)) {
            this.parent.getAttributes().add((Object)itemsAttr);
        }
    }

    public boolean canUndo() {
        return this.parent != null;
    }

    public void undo() {
        this.addItems(this.oldItems);
    }
}

