/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.commands;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.e4.xwt.tools.ui.designer.commands.ApplyAttributeSettingCommand;
import org.eclipse.e4.xwt.tools.ui.designer.core.parts.VisualEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.StringUtil;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.swt.SWTTools;
import org.eclipse.e4.xwt.tools.ui.designer.core.visuals.IVisualInfo;
import org.eclipse.e4.xwt.tools.ui.designer.parts.SashFormEditPart;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Widget;

public class ChangeWeightsCommand
extends Command {
    private SashFormEditPart parent;
    private ChangeBoundsRequest request;
    private Command command;
    private Integer[] weights;

    public ChangeWeightsCommand(SashFormEditPart parent, ChangeBoundsRequest request) {
        super("Change Weights");
        this.parent = parent;
        this.request = request;
    }

    public boolean canExecute() {
        if (this.parent == null || this.request == null || this.request.getEditParts() == null) {
            return false;
        }
        if (!(this.parent instanceof VisualEditPart)) {
            return false;
        }
        IVisualInfo visualInfo = this.parent.getVisualInfo();
        SashForm sashForm = (SashForm)visualInfo.getVisualObject();
        this.weights = this.computeWeights(sashForm);
        if (this.weights == null) {
            return false;
        }
        Integer[] integerArray = this.weights;
        int n = this.weights.length;
        int n2 = 0;
        while (n2 < n) {
            Integer integer = integerArray[n2];
            if (integer == null || integer < 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void execute() {
        this.command = new ApplyAttributeSettingCommand((XamlNode)this.parent.getModel(), "weights", "http://www.eclipse.org/xwt/presentation", StringUtil.format((Object[])this.weights));
        this.command.execute();
    }

    public boolean canUndo() {
        return this.command != null && this.command.canUndo();
    }

    public void undo() {
        this.command.undo();
    }

    private VisualEditPart getEditPart() {
        ArrayList editParts = new ArrayList(this.request.getEditParts());
        if (editParts.size() > 0) {
            return (VisualEditPart)editParts.get(0);
        }
        return null;
    }

    private Integer[] computeWeights(SashForm sashForm) {
        int[] weights;
        int[] newWeights = weights = sashForm.getWeights();
        VisualEditPart editPart = this.getEditPart();
        if (editPart != null) {
            XamlNode parentNode = (XamlNode)this.parent.getModel();
            int index = parentNode.getChildNodes().indexOf(editPart.getModel());
            Object visualObject = editPart.getVisualInfo().getVisualObject();
            if (index != -1) {
                int resizeDirection = this.request.getResizeDirection();
                Dimension sizeDelta = this.request.getSizeDelta();
                int offset = this.getResizeOffset((Control)visualObject, null, newWeights, index, sizeDelta.width, sizeDelta.height, resizeDirection == 16 || resizeDirection == 8);
                int i = 0;
                while (i < newWeights.length) {
                    if (i == index) {
                        int n = i;
                        newWeights[n] = newWeights[n] + offset;
                    } else {
                        int n = i;
                        newWeights[n] = newWeights[n] - offset / (newWeights.length - 1);
                    }
                    ++i;
                }
            } else {
                Sash sash = (Sash)visualObject;
                int sashIndex = this.getSashIndex(sashForm, sash);
                Point moveDelta = this.request.getMoveDelta();
                boolean horizontal = (sash.getStyle() & 0x200) != 0;
                Control[] controls = this.getControls(sashForm);
                if (controls != null) {
                    int resizeOffset = this.getResizeOffset(controls[sashIndex], sash, newWeights, sashIndex, moveDelta.x, moveDelta.y, horizontal);
                    int n = sashIndex;
                    newWeights[n] = newWeights[n] + resizeOffset;
                    int n2 = sashIndex + 1;
                    newWeights[n2] = newWeights[n2] - resizeOffset;
                }
            }
        }
        ArrayList<Integer> ws = new ArrayList<Integer>();
        int i = 0;
        while (i < newWeights.length) {
            ws.add(newWeights[i]);
            ++i;
        }
        return ws.toArray(new Integer[ws.size()]);
    }

    private int getSashIndex(SashForm sashForm, Sash sash) {
        try {
            Field field = SashForm.class.getDeclaredField("sashes");
            field.setAccessible(true);
            Sash[] sashes = (Sash[])field.get(sashForm);
            int i = 0;
            while (i < sashes.length) {
                if (sashes[i].equals(sash)) {
                    return i;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return -1;
    }

    private Control[] getControls(SashForm sashForm) {
        try {
            Field field = SashForm.class.getDeclaredField("controls");
            field.setAccessible(true);
            return (Control[])field.get(sashForm);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int getResizeOffset(Control control, Sash sash, int[] weights, int index, int x, int y, boolean horizontal) {
        float total = 0.0f;
        int[] nArray = weights;
        int n = weights.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            total += (float)i;
            ++n2;
        }
        Rectangle bounds = SWTTools.getBounds((Widget)control);
        if (horizontal) {
            int w = bounds.width;
            if (sash != null) {
                Rectangle sashBounds = SWTTools.getBounds((Widget)sash);
                w = Math.max(w, sashBounds.x - bounds.x);
            }
            float percent = (float)weights[index] / total;
            float width = (float)w / percent;
            float newPercent = (float)(w + x) / width;
            int newWeight = (int)(total * newPercent);
            return newWeight - weights[index];
        }
        int h = bounds.height;
        if (sash != null) {
            Rectangle sashBounds = SWTTools.getBounds((Widget)sash);
            h = Math.max(h, sashBounds.y - bounds.y);
        }
        float percent = (float)weights[index] / total;
        float height = (float)h / percent;
        float newPercent = (float)(h + y) / height;
        int newWeight = (int)(total * newPercent);
        return newWeight - weights[index];
    }
}

