/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.commands;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.tools.ui.designer.commands.AbstractCreateCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.ChangeConstraintCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.LayoutCommandsFactory;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.StringUtil;
import org.eclipse.e4.xwt.tools.ui.designer.utils.FigureUtil;
import org.eclipse.e4.xwt.tools.ui.designer.utils.XWTModelUtil;
import org.eclipse.e4.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class NullLayoutCommandsFactory
extends LayoutCommandsFactory {
    public NullLayoutCommandsFactory(EditPart host) {
        super(host);
    }

    public Command getCreateCommand(CreateRequest createRequest) {
        return new CreateCommand(this.getHost(), createRequest);
    }

    public Command getChangeConstraintCommand(Object constraint) {
        if (constraint instanceof Rectangle) {
            return new ChangeConstraintCommand(this.getHost(), (Rectangle)constraint, true);
        }
        return null;
    }

    class CreateCommand
    extends AbstractCreateCommand {
        private static final int DEFAULT_WIDTH_WIDGET = 48;
        private static final int DEFAULT_HEIGHT_WIDGET = 26;
        private static final int DEFAULT_HEIGHT_COMPOSITE = 100;
        private static final int DEFAULT_WIDTH_COMPOSITE = 100;

        public CreateCommand(EditPart parent, CreateRequest createRequest) {
            super(parent, createRequest);
        }

        protected void preExecute(XamlNode newNode, CreateRequest createRequest) {
            Point location = createRequest.getLocation();
            Dimension size = createRequest.getSize();
            if (location == null) {
                return;
            }
            location = FigureUtil.translateToRelative(this.parent, location);
            int x = location.x;
            int y = location.y;
            IMetaclass metaclass = XWTUtility.getMetaclass(newNode);
            if (metaclass == null) {
                return;
            }
            int width = 48;
            int height = 26;
            if (size != null) {
                width = size.width;
                height = size.height;
            } else if (Composite.class.isAssignableFrom(metaclass.getType())) {
                width = 100;
                height = 100;
            }
            String boundsValue = StringUtil.format((Object[])new Object[]{x, y, width, height});
            if (newNode instanceof XamlElement) {
                XamlElement childElement = (XamlElement)newNode;
                if (Viewer.class.isAssignableFrom(metaclass.getType())) {
                    XamlAttribute attribute = XWTModelUtil.getChildAttribute((XamlNode)childElement, "bounds", "http://www.eclipse.org/xwt/presentation");
                    if (attribute == null) {
                        XamlAttribute childAttr = childElement.getAttribute("control");
                        if (childAttr == null) {
                            childAttr = XamlFactory.eINSTANCE.createAttribute("control", "http://www.eclipse.org/xwt/presentation");
                            childElement.getAttributes().add((Object)childAttr);
                        }
                        attribute = XamlFactory.eINSTANCE.createAttribute("bounds", "http://www.eclipse.org/xwt/presentation");
                        childAttr.getAttributes().add((Object)attribute);
                    }
                    attribute.setValue(boundsValue);
                } else {
                    XamlAttribute boundsAttr = childElement.getAttribute("bounds", "http://www.eclipse.org/xwt/presentation");
                    if (boundsAttr == null) {
                        boundsAttr = XamlFactory.eINSTANCE.createAttribute("bounds", "http://www.eclipse.org/xwt/presentation");
                        childElement.getAttributes().add((Object)boundsAttr);
                    }
                    boundsAttr.setValue(boundsValue);
                }
            }
        }
    }
}

