/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.editor.model;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.e4.xwt.internal.xml.Attribute;
import org.eclipse.e4.xwt.tools.ui.designer.editor.model.XWTModelBuilder;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;

public class BraceHandler {
    private XamlElement root;
    private XamlNode current;
    private XamlNode forParse;
    private XamlDocument document;

    public BraceHandler(XamlDocument document) {
        this.document = document;
    }

    public XamlDocument getDocument() {
        return this.document;
    }

    public XamlNode parse(XamlNode element, String text) {
        this.forParse = element;
        if (this.root != null) {
            BraceHandler parser = new BraceHandler(this.document);
            return parser.parse(element, text);
        }
        this.current = element;
        StringTokenizer stringTokenizer = new StringTokenizer(text, "{}", true);
        String previous = null;
        String nextPrevious = null;
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (previous != null) {
                if (previous.equals("{")) {
                    if (token.equals("}")) {
                        if (stringTokenizer.hasMoreTokens()) {
                            this.handleBlock(stringTokenizer.nextToken(" \t\n\r\f"), false);
                        }
                    } else {
                        this.startBlock();
                    }
                } else if (previous.equals("}")) {
                    this.endBlock();
                } else {
                    String block = previous;
                    if (token.equals("{")) {
                        int level = 1;
                        block = String.valueOf(block) + token;
                        while (stringTokenizer.hasMoreTokens() && level >= 0) {
                            String value = stringTokenizer.nextToken();
                            if (value.equals("{")) {
                                ++level;
                            } else if (value.equals("}")) {
                                --level;
                            }
                            if (level < 0) continue;
                            block = String.valueOf(block) + value;
                        }
                    }
                    this.handleBlock(block, nextPrevious == null || !nextPrevious.equals("}"));
                }
            }
            nextPrevious = previous;
            previous = token;
        }
        XamlElement result = this.root;
        this.root = null;
        this.current = null;
        return result;
    }

    protected void startBlock() {
    }

    protected void endBlock() {
        if (this.current != null) {
            EObject container = this.current.eContainer();
            this.current = (XamlNode)container.eContainer();
        }
    }

    protected String expendNamespaces(XamlNode element, String value) {
        if (value.indexOf(58) == -1) {
            return value;
        }
        EMap declaredNamespaces = this.getDocument().getDeclaredNamespaces();
        int length = "clr-namespace:".length();
        for (String prefix : declaredNamespaces.keySet()) {
            String namespace = (String)declaredNamespaces.get((Object)prefix);
            if (!namespace.startsWith("clr-namespace:")) continue;
            String packageName = namespace.substring(length);
            value = value.replace(String.valueOf(prefix) + ":", String.valueOf(packageName) + '.');
        }
        return value;
    }

    protected void handleContent(XamlNode element, String text) {
        int index;
        if (text.startsWith("{") && text.endsWith("}")) {
            this.parse(element, text);
            return;
        }
        if (("Type".equals(element.getName()) || "Static".equals(element.getName())) && (index = text.indexOf(58)) != -1) {
            String ns = text.substring(0, index);
            String content = text.substring(index + 1);
            String namespace = this.getDocument().getDeclaredNamespace(ns);
            if (namespace != null) {
                XamlElement childElement = element.getChild(content, namespace);
                if (childElement == null) {
                    childElement = XamlFactory.eINSTANCE.createElement(content, namespace);
                    childElement.getChildNodes().add((Object)childElement);
                }
                return;
            }
        }
        if (element instanceof Attribute && "http://www.eclipse.org/xwt".equals(element.getNamespace()) && "Style".equalsIgnoreCase(element.getName())) {
            text = this.expendNamespaces(element, text);
        }
        element.setValue(text);
    }

    protected XamlElement createElement(String token) {
        int index = token.indexOf(58);
        String namespace = null;
        String name = token;
        if (index != -1) {
            String prefix = token.substring(0, index);
            name = token.substring(index + 1);
            namespace = this.document.getDeclaredNamespace(prefix);
        }
        if (namespace == null) {
            namespace = this.document.getDeclaredNamespace(null);
        }
        XamlElement element = null;
        if (this.current != null) {
            element = this.current.getChild(name, namespace);
        }
        if (element == null) {
            element = XamlFactory.eINSTANCE.createElement(name, namespace);
            element.setId(XWTModelBuilder.generateID(name));
        }
        if (this.current != null && this.current != this.forParse) {
            this.current.getChildNodes().add((Object)element);
        } else if (this.root == null) {
            this.root = element;
        }
        this.current = element;
        return element;
    }

    private XamlAttribute createAttribute(XamlNode parent, String name, String namespace) {
        XamlAttribute attribute = parent.getAttribute(name, namespace);
        if (attribute == null) {
            attribute = XamlFactory.eINSTANCE.createAttribute(name, namespace);
            attribute.setId(XWTModelBuilder.generateID(name));
        }
        return attribute;
    }

    protected void handleBlock(String content, boolean newElement) {
        XamlAttribute attribute;
        String rootPattern = " \t\n\r\f=,";
        StringTokenizer tokenizer = new StringTokenizer(content, rootPattern, true);
        String attributeName = null;
        String attributeValue = null;
        boolean equals = false;
        XamlElement element = null;
        if (!newElement && this.current instanceof XamlElement) {
            element = (XamlElement)this.current;
        }
        boolean skip = false;
        String token = null;
        while (skip || tokenizer.hasMoreTokens()) {
            if (!skip) {
                token = tokenizer.nextToken(rootPattern).trim();
            }
            skip = false;
            if (token.length() == 0) continue;
            if (element == null) {
                element = this.createElement(token);
            } else {
                if (token.equals("=")) {
                    equals = true;
                    if (!"xpath".equalsIgnoreCase(attributeName)) continue;
                    attributeValue = tokenizer.nextToken(",");
                    continue;
                }
                if (token.equals(",")) {
                    if (attributeName != null) {
                        if (attributeValue != null) {
                            attribute = this.createAttribute((XamlNode)element, attributeName, element.getNamespace());
                            if ("path".equalsIgnoreCase(attributeName) && "Binding".equalsIgnoreCase(element.getName())) {
                                attributeValue = this.expendNamespaces((XamlNode)element, attributeValue);
                            }
                            this.handleContent((XamlNode)attribute, attributeValue);
                            if (!element.getAttributes().contains((Object)attribute)) {
                                element.getAttributes().add((Object)attribute);
                            }
                            this.current = attribute;
                        } else {
                            element.setValue(attributeName);
                        }
                        attributeName = null;
                        attributeValue = null;
                        equals = false;
                    }
                } else if (attributeName == null) {
                    attributeName = token;
                } else {
                    String block = token;
                    if (token.startsWith("{")) {
                        int level = 1;
                        while (tokenizer.hasMoreTokens() && level > 0) {
                            String value = tokenizer.nextToken("{}");
                            if (value.equals("{")) {
                                ++level;
                            } else if (value.equals("}")) {
                                --level;
                            }
                            block = String.valueOf(block) + value;
                        }
                    }
                    attributeValue = block;
                    try {
                        token = tokenizer.nextToken(rootPattern).trim();
                        skip = true;
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
            }
            skip = false;
        }
        if (equals) {
            attribute = this.createAttribute((XamlNode)element, attributeName, element.getNamespace());
            if ("path".equalsIgnoreCase(attributeName) && "Binding".equalsIgnoreCase(element.getName())) {
                attributeValue = this.expendNamespaces((XamlNode)element, attributeValue);
            }
            if (attributeValue != null) {
                this.handleContent((XamlNode)attribute, attributeValue);
            } else {
                this.current = attribute;
            }
            if (!element.getAttributes().contains((Object)attribute)) {
                element.getAttributes().add((Object)attribute);
            }
        } else if (attributeName != null) {
            int index = attributeName.indexOf(":");
            if (index != -1) {
                element = this.createElement(attributeName);
                this.current = (XamlNode)this.current.eContainer();
            } else {
                this.current.setValue(attributeName);
            }
        }
    }
}

