/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.policies.layout;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.xwt.tools.ui.designer.commands.FormDataCreateCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.FormDataDeleteCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.ResizeCommand;
import org.eclipse.e4.xwt.tools.ui.designer.editor.dnd.EntryCreateRequest;
import org.eclipse.e4.xwt.tools.ui.designer.editor.palette.CreateReqHelper;
import org.eclipse.e4.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.e4.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.parts.ControlEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.policies.NewResizableEditPolicy;
import org.eclipse.e4.xwt.tools.ui.designer.policies.feedback.FeedbackHelper;
import org.eclipse.e4.xwt.tools.ui.designer.policies.feedback.FeedbackManager;
import org.eclipse.e4.xwt.tools.ui.designer.policies.layout.ILayoutEditPolicy;
import org.eclipse.e4.xwt.tools.ui.designer.policies.layout.form.FormDataFigure;
import org.eclipse.e4.xwt.tools.ui.designer.policies.layout.form.FormLayoutData;
import org.eclipse.e4.xwt.tools.ui.designer.policies.layout.form.FormLayoutHelper;
import org.eclipse.e4.xwt.tools.ui.designer.utils.FigureUtil;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ForwardedRequest;
import org.eclipse.swt.widgets.Control;

public class FormLayoutEditPolicy
extends XYLayoutEditPolicy
implements ILayoutEditPolicy {
    private FeedbackManager fbm = new FeedbackManager((GraphicalEditPolicy)this);
    private FormLayoutHelper helper;
    private FormDataFigure feedback;

    protected Command getCreateCommand(CreateRequest request) {
        return this.getFormDataCommand((Request)request);
    }

    public void activate() {
        this.helper = new FormLayoutHelper((CompositeEditPart)this.getHost());
        super.activate();
    }

    public void refresh() {
    }

    private FormLayoutData computeData(Request request) {
        if (this.helper == null) {
            this.helper = new FormLayoutHelper((CompositeEditPart)this.getHost());
        }
        Point location = null;
        Dimension size = null;
        Control control = null;
        if ("create child" == request.getType()) {
            location = ((EntryCreateRequest)request).getLocation().getCopy();
            size = ((EntryCreateRequest)request).getInitSize();
        } else if ("move" == request.getType()) {
            location = ((ChangeBoundsRequest)request).getLocation().getCopy();
            EditPart part = (EditPart)((ChangeBoundsRequest)request).getEditParts().get(0);
            if (part != null && part instanceof ControlEditPart && (control = (Control)((ControlEditPart)part).getWidget()) != null && !control.isDisposed()) {
                size = ((ControlEditPart)part).getVisualInfo().getBounds().getSize();
            }
        }
        if (location != null && size != null) {
            Point relative = FigureUtil.translateToRelative(this.getHost(), location.getCopy());
            FormLayoutData layoutData = this.helper.computeData(new Rectangle(relative, size), control);
            if (layoutData != null) {
                layoutData.bounds = new Rectangle(location, size);
            }
            return layoutData;
        }
        return null;
    }

    private Command getFormDataCommand(Request request) {
        EditPart part;
        EditPart parent = this.getHost();
        XamlNode forCreate = null;
        if ("create child".equals(request.getType())) {
            CreateReqHelper reqHelper = new CreateReqHelper((CreateRequest)request);
            if (reqHelper.canCreate(parent)) {
                forCreate = reqHelper.getNewObject();
            }
        } else if ("move children".equals(request.getType()) && (part = (EditPart)((ChangeBoundsRequest)request).getEditParts().get(0)) != null) {
            forCreate = (XamlNode)part.getModel();
        }
        if (forCreate == null) {
            return null;
        }
        FormLayoutData layoutData = null;
        if (this.feedback != null) {
            layoutData = this.feedback.getLayoutData();
        }
        if (layoutData == null) {
            layoutData = this.computeData(request);
        }
        if (layoutData == null || layoutData.data == null) {
            return null;
        }
        return new FormDataCreateCommand(parent, forCreate, layoutData.data);
    }

    protected void showLayoutTargetFeedback(Request request) {
        if ("create child".equals(request.getType()) && FeedbackHelper.showCreationFeedback(this.fbm, (CreateRequest)request)) {
            return;
        }
        FormLayoutData data = this.computeData(request);
        if (data != null) {
            this.showFormdataFeedback(data);
        } else {
            super.showLayoutTargetFeedback(request);
        }
    }

    private void showFormdataFeedback(FormLayoutData layoutData) {
        if (layoutData == null || layoutData.data == null || layoutData.bounds == null) {
            return;
        }
        if (this.feedback == null) {
            this.feedback = new FormDataFigure(layoutData);
        }
        this.feedback.setLayoutData(layoutData);
        this.feedback.setBounds(this.getHostFigure().getBounds());
        this.addFeedback((IFigure)this.feedback);
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.feedback != null) {
            this.removeFeedback((IFigure)this.feedback);
            this.feedback = null;
        }
        super.eraseLayoutTargetFeedback(request);
        this.fbm.eraseFeedback(request);
    }

    public LayoutType getType() {
        return LayoutType.FormLayout;
    }

    protected Command getMoveChildrenCommand(Request request) {
        return this.getFormDataCommand(request);
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand command = new CompoundCommand();
        Dimension growth = request.getSizeDelta();
        List editParts = request.getEditParts();
        for (EditPart child : editParts) {
            command.add((Command)new ResizeCommand(child, growth));
        }
        return command.unwrap();
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command getDeleteDependantCommand(Request request) {
        ForwardedRequest forwarded = (ForwardedRequest)request;
        EditPart sender = forwarded.getSender();
        return new FormDataDeleteCommand(this.getHost(), sender);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NewResizableEditPolicy(29, true);
    }
}

