/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.policies.layout.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.xwt.tools.ui.designer.commands.ApplyAttributeSettingCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.GridLayoutCommandsFactory;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.swt.GridLayoutHelper;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.swt.GridLayoutHelper_30;
import org.eclipse.e4.xwt.tools.ui.designer.core.visuals.VisualInfo;
import org.eclipse.e4.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.e4.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.parts.ShellEditPart;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.e4.xwt.tools.ui.xaml.tools.AnnotationTools;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridLayoutPolicyHelper {
    public static final String FILLER_DATA = "Filter_DATA";
    private static final String NO_MODS = "NOMODS";
    private static final int NOT_MODIFIED_SPAN = -1;
    private static final int SET_TO_DEFAULT_SPAN = -2;
    public final GridComponent EMPTY_GRID = new GridComponent(null);
    private XamlElement gridLayout;
    private CompositeEditPart host;
    protected GridComponent[][] glayoutTable;
    protected int numColumns = -1;
    protected int originalNumColumns;
    protected int defaultHorizontalSpan;
    protected int defaultVerticalSpan;
    protected GridComponent first;
    protected GridComponent last;
    private List<XamlNode> deletedComponents = new ArrayList<XamlNode>();
    private List<XamlNode> orphanedComponents;
    private GridLayoutCommandsFactory factory;

    public GridLayoutPolicyHelper() {
        this.initializeDefaults();
    }

    public void setHost(CompositeEditPart host) {
        this.host = host;
        this.gridLayout = host.getLayoutModel();
        this.factory = new GridLayoutCommandsFactory(host);
    }

    protected void initializeDefaults() {
        GridData gd = new GridData();
        this.defaultHorizontalSpan = gd.horizontalSpan;
        this.defaultVerticalSpan = gd.verticalSpan;
    }

    public Rectangle getLayoutSpacing() {
        Rectangle result = new Rectangle();
        GridLayout layout = (GridLayout)XWTProxy.createValue(this.gridLayout);
        if (layout == null) {
            layout = new GridLayout();
        }
        result.x = layout.marginWidth;
        result.y = layout.marginHeight;
        result.width = layout.horizontalSpacing;
        result.height = layout.verticalSpacing;
        return result;
    }

    public int[][] getLayoutDimensions() {
        Composite composite = this.getComposite();
        if (composite == null) {
            return null;
        }
        int[][] result = new int[2][];
        int[] widths = null;
        int[] heights = null;
        int version = SWT.getVersion();
        if (version > 3100) {
            GridLayoutHelper helper = new GridLayoutHelper();
            helper.setComposite(composite);
            widths = helper.widths;
            heights = helper.heights;
        } else {
            GridLayoutHelper_30 helper = new GridLayoutHelper_30();
            helper.setComposite(composite);
            widths = helper.widths;
            heights = helper.heights;
        }
        result[0] = widths == null ? new int[0] : widths;
        result[1] = heights == null ? new int[0] : heights;
        return result;
    }

    private Composite getComposite() {
        if (this.host == null) {
            return null;
        }
        VisualInfo visualComp = (VisualInfo)this.host.getVisualInfo();
        if (visualComp == null || visualComp.getVisualObject() == null) {
            return null;
        }
        return (Composite)visualComp.getVisualObject();
    }

    public GridComponent[][] getLayoutTable() {
        if (this.glayoutTable == null) {
            Control[] children;
            int[][] dimensions = this.getLayoutDimensions();
            if (dimensions == null) {
                return null;
            }
            Composite composite = this.getComposite();
            if (composite == null) {
                return null;
            }
            GridLayout layout = this.getGridLayout();
            if (layout == null) {
                return null;
            }
            this.glayoutTable = new GridComponent[dimensions[0].length][dimensions[1].length];
            this.originalNumColumns = layout.numColumns;
            this.numColumns = dimensions[0].length;
            if (this.glayoutTable.length < 1 || this.glayoutTable[0].length < 1) {
                return this.glayoutTable;
            }
            int row = 0;
            int col = 0;
            int childNum = 0;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                int verticalSpan;
                int horizontalSpan;
                Control child = controlArray[n2];
                XamlNode model = (XamlNode)child.getData("XWTDesigner.Model");
                GridComponent gcomp = new GridComponent(model);
                gcomp.filler = AnnotationTools.isAnnotated((XamlNode)model, (String)FILLER_DATA);
                this.addGridComponent(gcomp);
                Object layoutData = child.getLayoutData();
                if (layoutData == null || !(layoutData instanceof GridData)) {
                    horizontalSpan = this.defaultHorizontalSpan;
                    verticalSpan = this.defaultVerticalSpan;
                } else {
                    GridData gd = (GridData)layoutData;
                    horizontalSpan = gd.horizontalSpan;
                    verticalSpan = gd.verticalSpan;
                }
                Rectangle r = new Rectangle();
                while (row < this.glayoutTable[0].length && this.glayoutTable[col][row] != null) {
                    if (++col < this.numColumns) continue;
                    ++row;
                    col = 0;
                }
                if (col != 0 && col + horizontalSpan - 1 >= this.numColumns) {
                    ++row;
                    col = 0;
                }
                int maxColSpan = Math.min(col + horizontalSpan, this.glayoutTable.length);
                int maxRowSpan = Math.min(row + verticalSpan, this.glayoutTable[col].length);
                int coli = col;
                while (coli < maxColSpan) {
                    int rowj = row;
                    while (rowj < maxRowSpan) {
                        this.glayoutTable[coli][rowj] = gcomp;
                        ++rowj;
                    }
                    ++coli;
                }
                r.x = col;
                r.y = row;
                r.width = maxColSpan - col;
                r.height = maxRowSpan - row;
                gcomp.gridDimension = r;
                if (r.width != horizontalSpan) {
                    gcomp.setSpanWidth(r.width);
                }
                if (r.height != verticalSpan) {
                    gcomp.setSpanHeight(r.height);
                }
                ++childNum;
                col += r.width - 1;
                ++n2;
            }
        }
        int i = 0;
        while (i < this.glayoutTable.length) {
            int j = 0;
            while (j < this.glayoutTable[i].length) {
                if (this.glayoutTable[i][j] == null) {
                    this.glayoutTable[i][j] = this.EMPTY_GRID;
                }
                ++j;
            }
            ++i;
        }
        return this.glayoutTable;
    }

    public Rectangle getClientArea() {
        if (this.host instanceof ShellEditPart) {
            return this.host.getVisualInfo().getClientArea();
        }
        return this.host.getFigure().getBounds();
    }

    protected void insertGridGomponentAtBeginning(GridComponent gc) {
        gc.next = this.first;
        gc.prev = null;
        if (this.first == null) {
            this.last = gc;
        } else {
            this.first.prev = gc;
        }
        this.first = gc;
    }

    protected void insertGridComponentBefore(GridComponent gc, GridComponent before) {
        if (before != null) {
            if (before == this.first) {
                this.first = gc;
            } else {
                before.prev.next = gc;
            }
            gc.next = before;
            gc.prev = before.prev;
            before.prev = gc;
        } else {
            this.addGridComponent(gc);
        }
    }

    private void addGridComponent(GridComponent gc) {
        if (this.last == null) {
            this.insertGridGomponentAtBeginning(gc);
        } else {
            this.last.next = gc;
            gc.prev = this.last;
            gc.next = null;
            this.last = gc;
        }
    }

    private GridLayout getGridLayout() {
        Composite composite = this.getComposite();
        if (composite != null && !composite.isDisposed()) {
            return (GridLayout)composite.getLayout();
        }
        return null;
    }

    public CompositeEditPart getEditPart() {
        return this.host;
    }

    public void refresh() {
        this.glayoutTable = null;
        this.last = null;
        this.first = null;
        this.originalNumColumns = -1;
        this.numColumns = -1;
    }

    protected XamlNode getLayoutData(Object parent) {
        if (parent == null || !(parent instanceof XamlNode)) {
            return null;
        }
        XamlNode model = (XamlNode)parent;
        XamlNode layoutData = null;
        XamlAttribute attr = model.getAttribute("layoutData", "http://www.eclipse.org/xwt/presentation");
        if (attr != null && !attr.getChildNodes().isEmpty()) {
            layoutData = (XamlNode)attr.getChildNodes().get(0);
        }
        return layoutData;
    }

    public boolean isEmptyAtCell(Point cell) {
        this.getLayoutTable();
        if (cell.x >= 0 && cell.x < this.glayoutTable.length && cell.y >= 0 && cell.y < this.glayoutTable[0].length) {
            return this.glayoutTable[cell.x][cell.y] == this.EMPTY_GRID;
        }
        return false;
    }

    public boolean isFillerLabelAtCell(Point cell) {
        if (cell.x >= 0 && cell.x < this.glayoutTable.length && cell.y >= 0 && cell.y < this.glayoutTable[0].length) {
            return this.glayoutTable[cell.x][cell.y].isFillerLabel();
        }
        return false;
    }

    public Rectangle getChildDimensions(Point cell) {
        this.getLayoutTable();
        if (cell.x < 0 || cell.x >= this.glayoutTable.length || cell.y < 0 || cell.y >= this.glayoutTable[0].length) {
            return null;
        }
        GridComponent gc = this.glayoutTable[cell.x][cell.y];
        if (gc != this.EMPTY_GRID) {
            return gc.gridDimension;
        }
        return null;
    }

    public Rectangle getChildDimensions(EObject child) {
        this.getLayoutTable();
        GridComponent gc = this.getComponent(child);
        if (gc != null) {
            return gc.gridDimension;
        }
        return null;
    }

    public void startRequest() {
        this.getLayoutTable();
        this.deletedComponents.clear();
        if (this.orphanedComponents != null) {
            this.orphanedComponents.clear();
        }
    }

    private GridComponent getComponentIfMove(EObject childEObject, Object requestType) {
        if ("create child".equals(requestType) || "add children".equals(requestType)) {
            return null;
        }
        return this.getComponent(childEObject);
    }

    protected GridComponent getComponent(EObject childEObject) {
        if (childEObject == null) {
            return null;
        }
        GridComponent gc = this.first;
        while (gc != null) {
            if (gc.model == childEObject) {
                return gc;
            }
            gc = gc.next;
        }
        return null;
    }

    protected void deleteComponent(GridComponent gcomp) {
        if (gcomp.requestType != null && !gcomp.requestType.equals("add children") && !gcomp.requestType.equals("create child")) {
            this.addToDeleted(gcomp.model);
        }
    }

    protected void addToDeleted(XamlNode child) {
        if (this.deletedComponents == null) {
            this.deletedComponents = new ArrayList<XamlNode>();
        }
        this.deletedComponents.add(child);
    }

    protected void addToOrphaned(XamlNode child) {
        if (this.orphanedComponents == null) {
            this.orphanedComponents = new ArrayList<XamlNode>();
        }
        this.orphanedComponents.add(child);
    }

    public void deleteChild(XamlNode child) {
        GridComponent gc = this.getComponent((EObject)child);
        if (gc != null) {
            this.removeChild(gc, true, false);
        } else {
            this.addToDeleted(child);
        }
    }

    public void orphanChild(XamlNode child) {
        GridComponent gc = this.getComponent((EObject)child);
        if (gc != null) {
            this.removeChild(gc, false, true);
        }
        this.addToOrphaned(child);
    }

    public void orphanChildren(List<XamlNode> children) {
        for (XamlNode child : children) {
            this.orphanChild(child);
        }
    }

    protected void removeChild(GridComponent oldChild, boolean delete, boolean forceRemove) {
        int toCol = oldChild.gridDimension.x + oldChild.gridDimension.width - 1;
        int toRow = oldChild.gridDimension.y + oldChild.gridDimension.height - 1;
        if (!oldChild.isFillerLabel() || forceRemove) {
            int row;
            this.removeGridComponent(oldChild);
            if (delete) {
                this.deleteComponent(oldChild);
            }
            int col = oldChild.gridDimension.x;
            while (col <= toCol) {
                row = oldChild.gridDimension.y;
                while (row <= toRow) {
                    this.glayoutTable[col][row] = this.EMPTY_GRID;
                    ++row;
                }
                ++col;
            }
            col = oldChild.gridDimension.x;
            while (col <= toCol) {
                row = oldChild.gridDimension.y;
                while (row <= toRow) {
                    this.replaceEmptyCell(this.createFillerComponent(), col, row);
                    ++row;
                }
                ++col;
            }
        }
        int remRow = toRow;
        while (remRow >= oldChild.gridDimension.y) {
            this.removeRowIfEmpty(remRow);
            --remRow;
        }
        int remCol = toCol;
        while (remCol >= oldChild.gridDimension.x) {
            this.removeColIfEmpty(remCol);
            --remCol;
        }
    }

    protected boolean removeRowIfEmpty(int row) {
        GridComponent gc;
        int col = 0;
        while (col < this.glayoutTable.length) {
            gc = this.glayoutTable[col][row];
            if (gc != this.EMPTY_GRID && !gc.isFillerLabel()) {
                return false;
            }
            ++col;
        }
        col = 0;
        while (col < this.glayoutTable.length) {
            gc = this.glayoutTable[col][row];
            if (gc != this.EMPTY_GRID) {
                this.removeGridComponent(gc);
                this.deleteComponent(gc);
            }
            ++col;
        }
        col = 0;
        while (col < this.glayoutTable.length) {
            GridComponent[] oldCol = this.glayoutTable[col];
            this.glayoutTable[col] = new GridComponent[oldCol.length - 1];
            GridComponent[] newCol = this.glayoutTable[col];
            System.arraycopy(oldCol, 0, newCol, 0, row);
            System.arraycopy(oldCol, row + 1, newCol, row, newCol.length - row);
            int rrow = row;
            while (rrow < newCol.length) {
                GridComponent gc2 = newCol[rrow];
                if (gc2 != this.EMPTY_GRID) {
                    if (gc2.gridDimension.x == col && gc2.gridDimension.y == rrow + 1) {
                        gc2.gridDimension.y = rrow;
                    }
                    rrow = gc2.gridDimension.y + gc2.gridDimension.height - 1;
                }
                ++rrow;
            }
            ++col;
        }
        return true;
    }

    protected boolean removeColIfEmpty(int col) {
        GridComponent gc;
        int row = 0;
        while (row < this.glayoutTable[col].length) {
            gc = this.glayoutTable[col][row];
            if (gc != this.EMPTY_GRID && !gc.isFillerLabel()) {
                return false;
            }
            ++row;
        }
        row = 0;
        while (row < this.glayoutTable[col].length) {
            gc = this.glayoutTable[col][row];
            if (gc != this.EMPTY_GRID) {
                this.removeGridComponent(gc);
                this.deleteComponent(gc);
            }
            ++row;
        }
        GridComponent[][] oldLayout = this.glayoutTable;
        this.glayoutTable = new GridComponent[this.glayoutTable.length - 1][];
        System.arraycopy(oldLayout, 0, this.glayoutTable, 0, col);
        System.arraycopy(oldLayout, col + 1, this.glayoutTable, col, this.glayoutTable.length - col);
        this.numColumns = this.glayoutTable.length;
        int rcol = col;
        while (rcol < this.glayoutTable.length) {
            int rrow = 0;
            while (rcol < this.glayoutTable.length && rrow < this.glayoutTable[rcol].length) {
                GridComponent gc2 = this.glayoutTable[rcol][rrow];
                if (gc2 != this.EMPTY_GRID) {
                    if (gc2.gridDimension.x == rcol + 1 && gc2.gridDimension.y == rrow) {
                        gc2.gridDimension.x = rcol;
                    }
                    rcol = gc2.gridDimension.x + gc2.gridDimension.width - 1;
                }
                ++rrow;
            }
            ++rcol;
        }
        return true;
    }

    protected void replaceEmptyCell(GridComponent child, int cellCol, int cellRow) {
        if (this.glayoutTable[cellCol][cellRow] != this.EMPTY_GRID) {
            return;
        }
        GridComponent movedComponent = this.getComponentIfMove((EObject)child.model, child.requestType);
        GridComponent before = this.findNextValidGC(cellCol, cellRow);
        GridComponent componentBeforeUs = before != null ? before.prev : this.last;
        Rectangle beforeUsDim = componentBeforeUs != null ? componentBeforeUs.gridDimension : new Rectangle();
        int startCol = beforeUsDim.x;
        int row = beforeUsDim.y;
        while (row <= cellRow) {
            int endCol = row != cellRow ? this.glayoutTable.length : cellCol;
            int col = startCol;
            while (col < endCol) {
                if (this.glayoutTable[col][row] == this.EMPTY_GRID) {
                    this.insertComponent(this.createFillerComponent(), before, col, row, 1, 1);
                }
                ++col;
            }
            startCol = 0;
            ++row;
        }
        if (movedComponent == null) {
            this.insertComponent(child, before, cellCol, cellRow, 1, 1);
        } else {
            child.setMovedComponent(movedComponent);
            this.insertComponent(child, before, cellCol, cellRow, 1, 1);
            this.removeChild(movedComponent, false, true);
        }
    }

    protected void insertComponent(GridComponent gc, GridComponent beforeComponent, int x, int y, int spanX, int spanY) {
        gc.gridDimension = new Rectangle(x, y, spanX, spanY);
        this.insertGridComponentBefore(gc, beforeComponent);
        int stopCol = x + spanX;
        int stopRow = y + spanY;
        int col = x;
        while (col < stopCol) {
            int row = y;
            while (row < stopRow) {
                this.glayoutTable[col][row] = gc;
                ++row;
            }
            ++col;
        }
    }

    private GridComponent findNextValidGC(int columnStart, int rowStart) {
        int row;
        if (this.glayoutTable.length == 0 || this.glayoutTable[0].length == 0) {
            return null;
        }
        int col = columnStart;
        int i = row = rowStart;
        while (i < this.glayoutTable[0].length) {
            int j = col;
            while (j < this.glayoutTable.length) {
                GridComponent child = this.glayoutTable[j][i];
                if (child != this.EMPTY_GRID && child.gridDimension.y == i) {
                    return child;
                }
                ++j;
            }
            col = 0;
            ++i;
        }
        return null;
    }

    private GridComponent createFillerComponent() {
        XamlElement filler = XamlFactory.eINSTANCE.createElement("Label", "http://www.eclipse.org/xwt/presentation");
        GridComponent gc = new GridComponent((XamlNode)filler, true);
        AnnotationTools.addAnnotation((XamlNode)filler, (String)FILLER_DATA, (String)FILLER_DATA);
        return gc;
    }

    public void replaceFiller(XamlNode child, Object requestType, Point cell) {
        if (!this.isFillerLabelAtCell(cell)) {
            return;
        }
        GridComponent movedComponent = this.getComponentIfMove((EObject)child, requestType);
        GridComponent compAtCell = this.glayoutTable[cell.x][cell.y];
        this.deleteComponent(compAtCell);
        if (movedComponent == null) {
            compAtCell.setComponent(child, requestType);
        } else {
            compAtCell.setComponent(child, requestType);
            compAtCell.setMovedComponent(movedComponent);
            this.removeChild(movedComponent, false, true);
        }
    }

    private void removeGridComponent(GridComponent gc) {
        if (this.first == gc) {
            this.first = gc.next;
        } else {
            gc.prev.next = gc.next;
        }
        if (this.last == gc) {
            this.last = gc.prev;
        } else {
            gc.next.prev = gc.prev;
        }
    }

    public boolean insertColWithinRow(Point cell) {
        GridComponent newFiller;
        if (cell.x < 0 || cell.x >= this.glayoutTable.length || cell.y < 0 || cell.y >= this.glayoutTable[0].length) {
            return false;
        }
        int col = cell.x;
        while (col < this.glayoutTable.length) {
            GridComponent gc = this.glayoutTable[col][cell.y];
            if (gc != this.EMPTY_GRID && gc.gridDimension.height > 1) {
                return false;
            }
            ++col;
        }
        GridComponent lastCol = this.glayoutTable[this.numColumns - 1][cell.y];
        if (lastCol != this.EMPTY_GRID && !this.last.isFillerLabel()) {
            this.createNewCol(this.numColumns);
        }
        if ((newFiller = this.glayoutTable[this.numColumns - 1][cell.y]) != this.EMPTY_GRID) {
            this.removeGridComponent(newFiller);
            this.deleteComponent(newFiller);
        }
        int col2 = this.glayoutTable.length - 2;
        int toCol = col2 + 1;
        while (col2 >= cell.x) {
            this.glayoutTable[toCol][cell.y] = this.glayoutTable[col2][cell.y];
            --col2;
            --toCol;
        }
        this.glayoutTable[cell.x][cell.y] = this.EMPTY_GRID;
        this.replaceEmptyCell(this.createFillerComponent(), cell.x, cell.y);
        return true;
    }

    public void replaceFillerOrEmpty(XamlNode newObject, Object requestType, Point cell) {
        if (this.isFillerLabelAtCell(cell)) {
            this.replaceFiller(newObject, requestType, cell);
        } else if (this.isEmptyAtCell(cell)) {
            this.replaceEmptyCell(newObject, requestType, cell);
        }
    }

    public void createNewCol(int newCol) {
        int row;
        if (newCol < 0 || newCol > this.glayoutTable.length) {
            return;
        }
        if (this.glayoutTable.length == 0) {
            this.numColumns = 1;
            this.glayoutTable = new GridComponent[1][1];
            this.glayoutTable[0][0] = this.EMPTY_GRID;
            this.replaceEmptyCell(this.createFillerComponent(), 0, 0);
            return;
        }
        this.numColumns = this.glayoutTable.length + 1;
        GridComponent[][] newLayoutTable = new GridComponent[this.numColumns][this.glayoutTable[0].length];
        int col = 0;
        while (col < newCol) {
            System.arraycopy(this.glayoutTable[col], 0, newLayoutTable[col], 0, this.glayoutTable[col].length);
            ++col;
        }
        Arrays.fill(newLayoutTable[newCol], this.EMPTY_GRID);
        GridComponent[][] oldLayoutTable = this.glayoutTable;
        this.glayoutTable = newLayoutTable;
        int col2 = oldLayoutTable.length - 1;
        int toCol = col2 + 1;
        while (col2 >= newCol) {
            int row2 = 0;
            while (row2 < oldLayoutTable[0].length) {
                GridComponent cellEntry = oldLayoutTable[col2][row2];
                if (cellEntry == this.EMPTY_GRID) {
                    this.glayoutTable[toCol][row2] = this.EMPTY_GRID;
                } else {
                    if (cellEntry.gridDimension.x == col2 && cellEntry.gridDimension.y == row2) {
                        cellEntry.gridDimension.x = toCol;
                    }
                    int spanHeight = cellEntry.gridDimension.height;
                    --row2;
                    while (spanHeight-- > 0) {
                        this.glayoutTable[toCol][++row2] = cellEntry;
                    }
                }
                ++row2;
            }
            --col2;
            --toCol;
        }
        int lastRow = oldLayoutTable[0].length - 1;
        if (newCol != oldLayoutTable.length) {
            row = 0;
            while (row <= lastRow) {
                GridComponent gc = oldLayoutTable[newCol][row];
                if (gc != this.EMPTY_GRID && gc.gridDimension.x < newCol) {
                    gc.setSpanWidth(gc.gridDimension.width + 1);
                    int spanHeight = gc.gridDimension.height;
                    --row;
                    while (spanHeight-- > 0) {
                        this.glayoutTable[newCol][++row] = gc;
                    }
                } else {
                    this.replaceEmptyCell(this.createFillerComponent(), newCol, row);
                }
                ++row;
            }
        } else {
            row = 0;
            while (row < this.glayoutTable[0].length) {
                this.replaceEmptyCell(this.createFillerComponent(), newCol, row);
                ++row;
            }
        }
    }

    public void createNewRow(int newRow) {
        int col;
        if (newRow < 0 || this.glayoutTable.length == 0 && newRow > 0 || newRow > this.glayoutTable[0].length) {
            return;
        }
        if (this.glayoutTable.length == 0) {
            this.numColumns = 1;
            this.glayoutTable = new GridComponent[1][1];
            this.glayoutTable[0][0] = this.EMPTY_GRID;
            this.replaceEmptyCell(this.createFillerComponent(), 0, 0);
            return;
        }
        GridComponent[][] newLayoutTable = new GridComponent[this.glayoutTable.length][this.glayoutTable[0].length + 1];
        if (newRow > 0) {
            col = 0;
            while (col < this.glayoutTable.length) {
                System.arraycopy(this.glayoutTable[col], 0, newLayoutTable[col], 0, newRow);
                ++col;
            }
        }
        col = 0;
        while (col < this.glayoutTable.length) {
            newLayoutTable[col][newRow] = this.EMPTY_GRID;
            ++col;
        }
        GridComponent[][] oldLayoutTable = this.glayoutTable;
        this.glayoutTable = newLayoutTable;
        if (newRow == oldLayoutTable[0].length) {
            this.replaceEmptyCell(this.createFillerComponent(), 0, newRow);
        } else {
            int row = oldLayoutTable[0].length - 1;
            int toRow = row + 1;
            while (row >= newRow) {
                int col2 = 0;
                while (col2 < oldLayoutTable.length) {
                    GridComponent cellEntry = oldLayoutTable[col2][row];
                    if (cellEntry == this.EMPTY_GRID) {
                        this.glayoutTable[col2][toRow] = this.EMPTY_GRID;
                    } else {
                        if (cellEntry.gridDimension.y == row && cellEntry.gridDimension.x == col2) {
                            cellEntry.gridDimension.y = toRow;
                        }
                        int spanx = cellEntry.gridDimension.width;
                        --col2;
                        while (spanx-- > 0) {
                            this.glayoutTable[++col2][toRow] = cellEntry;
                        }
                    }
                    ++col2;
                }
                --row;
                --toRow;
            }
            int col3 = 0;
            while (col3 < oldLayoutTable.length) {
                GridComponent gc = oldLayoutTable[col3][newRow];
                if (gc != this.EMPTY_GRID && gc.gridDimension.y < newRow) {
                    gc.setSpanHeight(gc.gridDimension.height + 1);
                    int spanWidth = gc.gridDimension.width;
                    --col3;
                    while (spanWidth-- > 0) {
                        this.glayoutTable[++col3][newRow] = gc;
                    }
                } else {
                    this.replaceEmptyCell(this.createFillerComponent(), col3, newRow);
                }
                ++col3;
            }
        }
    }

    public void replaceEmptyCell(XamlNode newObject, Object requestType, Point cell) {
        if (this.glayoutTable[cell.x][cell.y] != this.EMPTY_GRID) {
            return;
        }
        this.replaceEmptyCell(new GridComponent(newObject, requestType), cell.x, cell.y);
    }

    public int getNumColumns() {
        if (this.numColumns == -1) {
            this.getLayoutTable();
        }
        return this.numColumns;
    }

    public int getNumRows() {
        this.getLayoutTable();
        return this.glayoutTable.length != 0 ? this.glayoutTable[0].length : 0;
    }

    private void handleSpanAtEnd(GridComponent gc, CompoundCommand cb) {
        if (gc.modSpanWidth != -1 || gc.modSpanHeight != -1) {
            int defaultHSpan;
            XamlNode gridData = gc.useGriddata == null ? this.getLayoutData(gc.model) : gc.useGriddata;
            XamlAttribute attribute = gridData == null ? null : gridData.getAttribute("horizontalSpan", "http://www.eclipse.org/xwt/presentation");
            switch (gc.modSpanWidth) {
                case -2: {
                    if (gridData == null || attribute == null || String.valueOf(defaultHSpan = new GridData().horizontalSpan).equals(attribute.getValue())) break;
                    cb.add(ApplyAttributeSettingCommand.createCommand(gridData, "horizontalSpan", "http://www.eclipse.org/xwt/presentation", String.valueOf(defaultHSpan)));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (gridData == null || gc.modSpanWidth <= 0) break;
                    defaultHSpan = new GridData().horizontalSpan;
                    if ((attribute != null || defaultHSpan == gc.modSpanWidth) && (attribute == null || String.valueOf(gc.modSpanWidth).equals(attribute.getValue()))) break;
                    cb.add(ApplyAttributeSettingCommand.createCommand(gridData, "horizontalSpan", "http://www.eclipse.org/xwt/presentation", String.valueOf(gc.modSpanWidth)));
                }
            }
            switch (gc.modSpanHeight) {
                case -2: {
                    int defaultVSpan;
                    if (gridData == null || attribute == null || String.valueOf(defaultVSpan = new GridData().verticalSpan).equals(attribute.getValue())) break;
                    cb.add(ApplyAttributeSettingCommand.createCommand(gridData, "verticalSpan", "http://www.eclipse.org/xwt/presentation", String.valueOf(defaultVSpan)));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (gridData == null || gc.modSpanHeight <= 0) break;
                    defaultHSpan = new GridData().verticalSpan;
                    if ((attribute != null || defaultHSpan == gc.modSpanHeight) && (attribute == null || String.valueOf(gc.modSpanHeight).equals(attribute.getValue()))) break;
                    cb.add(ApplyAttributeSettingCommand.createCommand(gridData, "verticalSpan", "http://www.eclipse.org/xwt/presentation", String.valueOf(gc.modSpanHeight)));
                }
            }
        }
    }

    public void spanChild(EObject child, Point newSpan, int spanDirection, XamlNode griddata) {
        block13: {
            int newgridDataHeight;
            GridComponent gc;
            block15: {
                block12: {
                    int newgridDataWidth;
                    block14: {
                        gc = this.getComponent(child);
                        if (gc == null) {
                            return;
                        }
                        gc.setGriddata(griddata);
                        if (spanDirection != 16 && spanDirection != 8) break block12;
                        newgridDataWidth = newSpan.x;
                        if (newgridDataWidth == gc.gridDimension.width) break block13;
                        if (newgridDataWidth <= gc.gridDimension.width) break block14;
                        int numColsIncrement = this.spanHorizontalIntoEmptyColumns(gc, gc.gridDimension.y, gc.gridDimension.x + gc.gridDimension.width, gc.gridDimension.height, newgridDataWidth - gc.gridDimension.width);
                        if (numColsIncrement <= 0) break block13;
                        int insertColAt = gc.gridDimension.x + gc.gridDimension.width;
                        while (numColsIncrement-- > 0) {
                            this.createNewCol(insertColAt);
                        }
                        this.spanHorizontalIntoEmptyColumns(gc, gc.gridDimension.y, gc.gridDimension.x + gc.gridDimension.width, gc.gridDimension.height, newgridDataWidth - gc.gridDimension.width);
                        break block13;
                    }
                    if (gc.gridDimension.x == 0 && gc.gridDimension.y > 0) {
                        boolean allEmpties = true;
                        int prevRow = gc.gridDimension.y - 1;
                        int numCols = newgridDataWidth;
                        int colToTest = this.glayoutTable.length - 1;
                        while (numCols > 0) {
                            if (this.glayoutTable[colToTest][prevRow] != this.EMPTY_GRID) {
                                allEmpties = false;
                                break;
                            }
                            --numCols;
                            --colToTest;
                        }
                        if (allEmpties) {
                            this.replaceEmptyCell(this.createFillerComponent(), this.glayoutTable.length - newgridDataWidth, prevRow);
                        }
                    }
                    int colToSpanOutOf = gc.gridDimension.x + gc.gridDimension.width - 1;
                    while (gc.gridDimension.width > newgridDataWidth) {
                        gc.setSpanWidth(gc.gridDimension.width - 1);
                        int nextRow = gc.gridDimension.y + gc.gridDimension.height;
                        Arrays.fill(this.glayoutTable[colToSpanOutOf], gc.gridDimension.y, nextRow, this.EMPTY_GRID);
                        int row = gc.gridDimension.y;
                        while (row < nextRow) {
                            this.replaceEmptyCell(this.createFillerComponent(), colToSpanOutOf, row);
                            ++row;
                        }
                        this.removeColIfEmpty(colToSpanOutOf);
                        --colToSpanOutOf;
                    }
                    break block13;
                }
                if (spanDirection != 4 || (newgridDataHeight = newSpan.y) == gc.gridDimension.height) break block13;
                if (newgridDataHeight <= gc.gridDimension.height) break block15;
                int numRowsIncrement = this.spanVerticalIntoEmptyRows(gc, gc.gridDimension.y + gc.gridDimension.height, gc.gridDimension.x, gc.gridDimension.width, newgridDataHeight - gc.gridDimension.height);
                if (numRowsIncrement <= 0) break block13;
                int insertRowAt = gc.gridDimension.y + gc.gridDimension.height;
                while (numRowsIncrement-- > 0) {
                    this.createNewRow(insertRowAt);
                }
                this.spanVerticalIntoEmptyRows(gc, gc.gridDimension.y + gc.gridDimension.height, gc.gridDimension.x, gc.gridDimension.width, newgridDataHeight - gc.gridDimension.height);
                break block13;
            }
            int rowToSpanOutOf = gc.gridDimension.y + gc.gridDimension.height - 1;
            while (gc.gridDimension.height > newgridDataHeight) {
                gc.setSpanHeight(gc.gridDimension.height - 1);
                int nextCol = gc.gridDimension.x + gc.gridDimension.width;
                int col = gc.gridDimension.x;
                while (col < nextCol) {
                    this.glayoutTable[col][rowToSpanOutOf] = this.EMPTY_GRID;
                    ++col;
                }
                col = gc.gridDimension.x;
                while (col < nextCol) {
                    this.replaceEmptyCell(this.createFillerComponent(), col, rowToSpanOutOf);
                    ++col;
                }
                this.removeRowIfEmpty(rowToSpanOutOf);
                --rowToSpanOutOf;
            }
        }
    }

    private int spanHorizontalIntoEmptyColumns(GridComponent spanGC, int atRow, int atColumn, int childHeight, int numColsIncrement) {
        if (atColumn < this.glayoutTable.length && atRow < this.glayoutTable[0].length) {
            int col = atColumn;
            while (col < this.glayoutTable.length && numColsIncrement != 0) {
                int toRow = atRow + childHeight - 1;
                if (!this.isHorizontalSpaceAvailable(col, atRow, toRow)) break;
                int row = atRow;
                while (row <= toRow) {
                    GridComponent gc = this.glayoutTable[col][row];
                    if (gc.isFillerLabel()) {
                        this.removeGridComponent(gc);
                        this.deleteComponent(gc);
                    }
                    this.glayoutTable[col][row] = spanGC;
                    ++row;
                }
                spanGC.setSpanWidth(spanGC.gridDimension.width + 1);
                --numColsIncrement;
                ++col;
            }
        }
        return numColsIncrement;
    }

    private int spanVerticalIntoEmptyRows(GridComponent spanGC, int atRow, int atColumn, int childWidth, int numRowsIncrement) {
        if (atColumn < this.glayoutTable.length && atRow < this.glayoutTable[0].length) {
            int row = atRow;
            while (row < this.glayoutTable[0].length && numRowsIncrement != 0) {
                int toCol = atColumn + childWidth - 1;
                if (!this.isVerticalSpaceAvailable(row, atColumn, toCol)) break;
                int col = atColumn;
                while (col <= toCol) {
                    GridComponent gc = this.glayoutTable[col][row];
                    if (gc.isFillerLabel()) {
                        this.removeGridComponent(gc);
                        this.deleteComponent(gc);
                    }
                    this.glayoutTable[col][row] = spanGC;
                    ++col;
                }
                spanGC.setSpanHeight(spanGC.gridDimension.height + 1);
                --numRowsIncrement;
                ++row;
            }
        }
        return numRowsIncrement;
    }

    private boolean isVerticalSpaceAvailable(int atRow, int columnStart, int columnEnd) {
        if (this.glayoutTable.length == 0 || this.glayoutTable[0].length == 0 || columnStart >= this.glayoutTable.length || columnEnd >= this.glayoutTable.length || atRow >= this.glayoutTable[0].length) {
            return false;
        }
        int col = columnStart;
        while (col <= columnEnd) {
            if (this.glayoutTable[col][atRow] != this.EMPTY_GRID && !this.glayoutTable[col][atRow].isFillerLabel()) {
                return false;
            }
            ++col;
        }
        return true;
    }

    private boolean isHorizontalSpaceAvailable(int atCol, int rowStart, int rowEnd) {
        if (this.glayoutTable.length == 0 || this.glayoutTable[0].length == 0 || rowStart >= this.glayoutTable[0].length || rowEnd >= this.glayoutTable[0].length || atCol >= this.glayoutTable.length) {
            return false;
        }
        int row = rowStart;
        while (row <= rowEnd) {
            if (this.glayoutTable[atCol][row] != this.EMPTY_GRID && !this.glayoutTable[atCol][row].isFillerLabel()) {
                return false;
            }
            ++row;
        }
        return true;
    }

    public Command stopRequest() {
        CompoundCommand cb = new CompoundCommand();
        if (this.numColumns != this.originalNumColumns) {
            this.createNumColumnsCommand(this.numColumns, cb);
        }
        GridComponent end = this.last;
        while (this.last != null && (this.last == this.EMPTY_GRID || this.last.isFillerLabel())) {
            GridComponent next = this.last.prev;
            if (this.last != this.EMPTY_GRID) {
                this.removeGridComponent(end);
                this.deleteComponent(end);
                this.glayoutTable[end.gridDimension.x][end.gridDimension.y] = this.EMPTY_GRID;
            }
            end = next;
        }
        XamlNode beforeComp = null;
        Object currentModState = null;
        ArrayList<GridComponent> currentComponentGCs = new ArrayList<GridComponent>();
        XamlNode prevComp = beforeComp;
        GridComponent gc = this.last;
        while (gc != null) {
            if (gc.requestType != NO_MODS) {
                if (!gc.requestType.equals(currentModState)) {
                    if (!currentComponentGCs.isEmpty()) {
                        this.getCommandForAddCreateMoveChildren(currentModState, currentComponentGCs, beforeComp, cb);
                        currentComponentGCs.clear();
                    }
                    beforeComp = prevComp;
                    currentModState = gc.requestType;
                }
                currentComponentGCs.add(0, gc);
            } else if (!currentComponentGCs.isEmpty()) {
                this.getCommandForAddCreateMoveChildren(currentModState, currentComponentGCs, beforeComp, cb);
                currentComponentGCs.clear();
                currentModState = null;
            }
            this.handleSpanAtEnd(gc, cb);
            prevComp = gc.model;
            gc = gc.prev;
        }
        if (!currentComponentGCs.isEmpty()) {
            this.getCommandForAddCreateMoveChildren(currentModState, currentComponentGCs, beforeComp, cb);
        }
        if (this.deletedComponents != null && !this.deletedComponents.isEmpty()) {
            cb.add(this.factory.getDeleteDependentCommand(this.deletedComponents));
        }
        if (this.orphanedComponents != null && !this.orphanedComponents.isEmpty()) {
            cb.add(this.factory.getOrphanChildrenCommand(this.orphanedComponents));
        }
        this.refresh();
        return cb;
    }

    private void createNumColumnsCommand(int numCols, CompoundCommand cb) {
        XamlElement parent = this.host.getLayoutModel();
        XamlAttribute attribute = parent.getAttribute("numColumns", "http://www.eclipse.org/xwt/presentation");
        int defaultNum = new GridLayout().numColumns;
        if (attribute == null && numCols != defaultNum || attribute != null && !String.valueOf(numCols).equals(attribute.getValue())) {
            Command cmd = ApplyAttributeSettingCommand.createCommand((XamlNode)parent, "numColumns", "http://www.eclipse.org/xwt/presentation", Integer.toString(numCols));
            cb.add(cmd);
        }
    }

    private void getCommandForAddCreateMoveChildren(Object requestType, List<GridComponent> childrenGC, Object beforeObject, CompoundCommand cb) {
        ArrayList<XamlNode> children = new ArrayList<XamlNode>(childrenGC.size());
        ArrayList<XamlNode> constraints = new ArrayList<XamlNode>(childrenGC.size());
        int i = 0;
        while (i < childrenGC.size()) {
            GridComponent gc = childrenGC.get(i);
            children.add(gc.model);
            constraints.add(gc.useGriddata);
            ++i;
        }
        if ("create child".equals(requestType)) {
            cb.add(this.factory.getCreateCommand(constraints, children, beforeObject));
        } else if ("add children".equals(requestType)) {
            cb.add(this.factory.getAddCommand(constraints, children, beforeObject));
        } else {
            cb.add(this.factory.getMoveChildrenCommand(children, (XamlNode)beforeObject));
        }
    }

    public boolean isRightToLeft() {
        return this.getEditPart().isRightToLeft();
    }

    public class GridComponent {
        private XamlNode model;
        private boolean filler;
        Object requestType = "NOMODS";
        int modSpanWidth = -1;
        int modSpanHeight = -1;
        Rectangle gridDimension;
        GridComponent prev;
        GridComponent next;
        XamlNode useGriddata;

        public GridComponent(XamlNode model) {
            this.model = model;
        }

        public GridComponent(XamlNode model, boolean filler) {
            this(model, "create child");
            this.filler = filler;
        }

        public GridComponent(XamlNode model, Object requestType) {
            this(model);
            this.requestType = requestType;
            this.setupUseGriddata(model, requestType);
        }

        public boolean isFillerLabel() {
            return this.filler;
        }

        public void setSpanWidth(int spanWidth) {
            this.gridDimension.width = this.modSpanWidth = spanWidth;
            if (spanWidth == 1) {
                this.modSpanWidth = -2;
            }
        }

        public void setSpanHeight(int spanHeight) {
            this.gridDimension.height = this.modSpanHeight = spanHeight;
            if (spanHeight == 1) {
                this.modSpanHeight = -2;
            }
        }

        void setMovedComponent(GridComponent gc) {
            this.requestType = GridLayoutPolicyHelper.NO_MODS.equals(gc.requestType) ? "move" : gc.requestType;
            this.modSpanHeight = -2;
            this.modSpanWidth = -2;
            this.filler = gc.filler;
            this.useGriddata = gc.useGriddata;
        }

        public void setComponent(XamlNode model, Object requestType) {
            this.model = model;
            this.requestType = requestType;
            this.modSpanHeight = -1;
            this.modSpanWidth = -1;
            this.filler = false;
            this.setupUseGriddata(model, requestType);
        }

        private void setupUseGriddata(XamlNode model, Object requestType) {
            XamlAttribute attr;
            this.useGriddata = null;
            if (("create child".equals(requestType) || "add children".equals(requestType)) && (attr = model.getAttribute("layoutData", "http://www.eclipse.org/xwt/presentation")) != null && !attr.getChildNodes().isEmpty()) {
                this.useGriddata = (XamlNode)attr.getChildNodes().get(0);
                this.modSpanWidth = -2;
                this.modSpanHeight = -2;
            }
        }

        public void setGriddata(XamlNode griddata) {
            if (this.useGriddata == null) {
                this.useGriddata = griddata;
            }
        }

        public XamlNode getModel() {
            return this.model;
        }

        public int getSpanWidth() {
            return this.gridDimension.width;
        }

        public int getSpanHeight() {
            return this.gridDimension.height;
        }
    }
}

