/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.properties.editors;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.e4.xwt.tools.ui.designer.properties.editors.AbstractCellEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ArrayCellEditor
extends AbstractCellEditor {
    public ArrayCellEditor(Composite parent) {
        super(parent);
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ArrayDialog dialog;
        Object value = this.getValue();
        String[] initValue = null;
        if (value instanceof String[]) {
            initValue = (String[])value;
        }
        if ((dialog = new ArrayDialog(cellEditorWindow.getShell(), initValue)).open() == 0) {
            initValue = dialog.getArray();
        }
        return initValue;
    }

    protected void updateContents(Object value) {
        super.updateContents("[...]");
    }

    class ArrayDialog
    extends Dialog {
        private Text text;
        private String result;
        private String[] initValue;

        protected ArrayDialog(Shell parentShell, String[] initValue) {
            super(parentShell);
            this.setShellStyle(1264);
            this.initValue = initValue;
        }

        protected Control createDialogArea(Composite parent) {
            Composite control = (Composite)super.createDialogArea(parent);
            control.setLayout((Layout)new FillLayout());
            this.text = new Text(control, 2114);
            if (this.initValue != null) {
                StringBuilder sb = new StringBuilder();
                String[] stringArray = this.initValue;
                int n = this.initValue.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    sb.append(item);
                    sb.append("\n");
                    ++n2;
                }
                this.result = sb.toString();
            }
            if (this.result != null) {
                this.text.setText(this.result);
            }
            this.text.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    ArrayDialog.this.result = ArrayDialog.this.text.getText();
                }
            });
            this.text.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 4) {
                        ArrayDialog.this.text.getParent().layout(true, true);
                        ArrayDialog.this.getDialogArea().getParent().layout();
                    }
                }
            });
            return control;
        }

        public String getResult() {
            return this.result;
        }

        public String[] getArray() {
            if (this.result == null) {
                return new String[0];
            }
            ArrayList<String> resultList = new ArrayList<String>();
            StringTokenizer stk = new StringTokenizer(this.result, "\n");
            while (stk.hasMoreElements()) {
                resultList.add(stk.nextToken().trim());
            }
            return resultList.toArray(new String[0]);
        }
    }
}

