/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.xaml.tools;

import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;

public class XamlCreateTools {
    public static XamlAttribute addAttribute(XamlNode parent, String name, String namespace, String value) {
        if (parent == null || name == null || namespace == null) {
            throw new NullPointerException();
        }
        XamlAttribute attribute = parent.getAttribute(name, namespace);
        boolean isNew = false;
        if (attribute == null) {
            attribute = XamlFactory.eINSTANCE.createAttribute(name, namespace);
            isNew = true;
        }
        if (value != null) {
            attribute.setValue(value);
        }
        if (isNew) {
            parent.getAttributes().add((Object)attribute);
        }
        return attribute;
    }

    public static XamlAttribute addAttribute(XamlNode parent, String name, String namespace) {
        return XamlCreateTools.addAttribute(parent, name, namespace, null);
    }

    public static XamlAttribute addComplexAttribute(XamlElement parent, String name, String namespace, String childName, String childNamespace) {
        return XamlCreateTools.addComplexAttribute(parent, name, namespace, childName, childNamespace, false);
    }

    public static XamlAttribute addComplexAttribute(XamlElement parent, String name, String namespace, String childName, String childNamespace, boolean allowMutilChild) {
        if (parent == null || name == null || namespace == null || childName == null || childNamespace == null) {
            throw new NullPointerException();
        }
        XamlAttribute attribute = parent.getAttribute(name, namespace);
        if (attribute == null) {
            attribute = XamlFactory.eINSTANCE.createAttribute(name, namespace);
            XamlElement child = XamlFactory.eINSTANCE.createElement(childName, childNamespace);
            attribute.getChildNodes().add((Object)child);
            parent.getAttributes().add((Object)attribute);
        } else if (attribute.getChild(childName, childNamespace) == null) {
            XamlElement child = XamlFactory.eINSTANCE.createElement(childName, childNamespace);
            if (!allowMutilChild) {
                attribute.getChildNodes().clear();
            }
            attribute.getChildNodes().add((Object)child);
        }
        return attribute;
    }

    private XamlCreateTools() {
    }
}

