/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.swt;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class AnimatedImage
extends CLabel {
    protected InputStream imageFile;
    protected boolean stop = true;
    protected boolean useGIFBackground = false;
    protected int horizontalAlignment = 16384;
    protected int verticalAlignment = 128;
    protected AnimationRunnable animateThread = new AnimationRunnable();

    public AnimatedImage(Composite parent, int style) {
        super(parent, style);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setImageFile(URL imageFile) throws IOException {
        if (!this.stop) {
            throw new IllegalStateException("Animation is running");
        }
        this.imageFile = imageFile.openStream();
        if (imageFile != null) {
            this.start();
        }
    }

    public void start() {
        this.stop = false;
        this.getDisplay().asyncExec((Runnable)this.animateThread);
    }

    public void stop() {
        this.stop = true;
    }

    public void dispose() {
        this.stop = true;
        super.dispose();
    }

    class AnimationRunnable
    implements Runnable {
        protected ImageLoader loader;
        protected Image image;
        protected ImageData[] imageDataArray;
        protected GC targetGC;
        protected Image offScreenImage;
        protected GC offScreenImageGC;
        protected int imageDataIndex = 0;
        protected int repeatCount;

        AnimationRunnable() {
        }

        public void run() {
            ImageData imageData;
            if (AnimatedImage.this.isDisposed() || AnimatedImage.this.stop) {
                this.clearStop();
                return;
            }
            Display display = AnimatedImage.this.getDisplay();
            Color background = AnimatedImage.this.getBackground();
            if (this.loader == null) {
                AnimatedImage.this.setText("");
                this.loader = new ImageLoader();
                this.imageDataArray = this.loader.load(AnimatedImage.this.imageFile);
                this.targetGC = new GC((Drawable)AnimatedImage.this);
                this.offScreenImage = new Image((Device)display, this.loader.logicalScreenWidth, this.loader.logicalScreenHeight);
                this.offScreenImageGC = new GC((Drawable)this.offScreenImage);
                this.offScreenImageGC.setBackground(background);
                this.offScreenImageGC.fillRectangle(0, 0, this.loader.logicalScreenWidth, this.loader.logicalScreenHeight);
                this.imageDataIndex = 0;
                imageData = this.imageDataArray[this.imageDataIndex];
                if (this.image != null && !this.image.isDisposed()) {
                    this.image.dispose();
                }
                this.image = new Image((Device)display, imageData);
                this.offScreenImageGC.drawImage(this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                this.repeatCount = this.loader.repeatCount;
            }
            try {
                imageData = this.imageDataArray[this.imageDataIndex];
                if (this.loader.repeatCount == 0 || this.repeatCount > 0) {
                    switch (imageData.disposalMethod) {
                        case 2: {
                            Color bgColor = null;
                            if (AnimatedImage.this.useGIFBackground && this.loader.backgroundPixel != -1) {
                                bgColor = new Color((Device)display, imageData.palette.getRGB(this.loader.backgroundPixel));
                            }
                            this.offScreenImageGC.setBackground(bgColor != null ? bgColor : background);
                            this.offScreenImageGC.fillRectangle(imageData.x, imageData.y, imageData.width, imageData.height);
                            if (bgColor == null) break;
                            bgColor.dispose();
                            break;
                        }
                        case 3: {
                            this.offScreenImageGC.drawImage(this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                        }
                    }
                    this.imageDataIndex = (this.imageDataIndex + 1) % this.imageDataArray.length;
                    imageData = this.imageDataArray[this.imageDataIndex];
                    this.image.dispose();
                    this.image = new Image((Device)display, imageData);
                    this.offScreenImageGC.drawImage(this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                    Rectangle container = AnimatedImage.this.getBounds();
                    Rectangle imageBound = this.offScreenImage.getBounds();
                    int x = 0;
                    int y = 0;
                    switch (AnimatedImage.this.horizontalAlignment) {
                        case 16384: {
                            break;
                        }
                        case 131072: {
                            x = container.width - imageBound.width;
                            break;
                        }
                        case 0x1000000: {
                            x = (container.width - imageBound.width) / 2;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("HorizontalAlignment " + AnimatedImage.this.horizontalAlignment);
                        }
                    }
                    switch (AnimatedImage.this.verticalAlignment) {
                        case 128: {
                            break;
                        }
                        case 0x1000000: {
                            y = (container.height - imageBound.height) / 2;
                            break;
                        }
                        case 1024: {
                            y = container.height - imageBound.height;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("VerticalAlignment " + AnimatedImage.this.verticalAlignment);
                        }
                    }
                    if (x < 0) {
                        x = 0;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    this.targetGC.drawImage(this.offScreenImage, x, y);
                    int ms = imageData.delayTime * 10;
                    if (ms < 20) {
                        ms += 30;
                    }
                    if (ms < 30) {
                        ms += 10;
                    }
                    AnimatedImage.this.getDisplay().timerExec(ms, (Runnable)this);
                    if (this.imageDataIndex == this.imageDataArray.length - 1) {
                        --this.repeatCount;
                    }
                } else {
                    this.clearStop();
                }
            }
            catch (SWTException sWTException) {
                System.out.println("There was an error animating the GIF");
            }
        }

        protected void clearStop() {
            if (this.offScreenImage != null && !this.offScreenImage.isDisposed()) {
                try {
                    this.offScreenImage.dispose();
                }
                catch (Exception exception) {}
            }
            if (this.offScreenImageGC != null && !this.offScreenImageGC.isDisposed()) {
                try {
                    this.offScreenImageGC.dispose();
                }
                catch (Exception exception) {}
            }
            if (this.image != null && !this.image.isDisposed()) {
                try {
                    this.image.dispose();
                }
                catch (Exception exception) {}
            }
            if (this.targetGC != null && !this.targetGC.isDisposed()) {
                try {
                    this.targetGC.dispose();
                }
                catch (Exception exception) {}
            }
            this.targetGC = null;
            this.image = null;
            this.offScreenImageGC = null;
            this.offScreenImage = null;
            this.loader = null;
            this.imageDataArray = null;
            this.imageDataIndex = 0;
            this.repeatCount = 0;
            AnimatedImage.this.stop = true;
        }
    }
}

