/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.databinding;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.IValueConverter;
import org.eclipse.e4.xwt.databinding.AbstractDataBinding;
import org.eclipse.e4.xwt.databinding.IBindingContext;
import org.eclipse.e4.xwt.internal.core.Binding;
import org.eclipse.e4.xwt.internal.core.BindingGate;
import org.eclipse.e4.xwt.internal.core.ScopeManager;
import org.eclipse.e4.xwt.internal.utils.UserData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDataBinding
extends AbstractDataBinding {
    private Object source;

    public ControlDataBinding(Object source, Binding binding, IDataProvider dataProvider) {
        super(binding, dataProvider);
        this.source = source;
    }

    @Override
    public Object getValue(Class<?> targetType) {
        IObservableValue observable;
        IObservableValue targetWidget = null;
        Object target = this.getControl();
        if (target != null && (observable = ScopeManager.observeValue(target, target, this.getTargetProperty(), this.getUpdateSourceTrigger())) instanceof IObservableValue) {
            targetWidget = observable;
        }
        if (this.source == null) {
            return null;
        }
        Object control = UserData.getWidget(this.source);
        if (control == null) {
            control = this.getControl();
        }
        IObservableValue observable2 = ScopeManager.observeValue(control, this.source, this.getSourceProperty(), this.getUpdateSourceTrigger());
        IObservableValue sourceWidget = null;
        if (observable2 instanceof IObservableValue) {
            sourceWidget = observable2;
        }
        if (targetWidget == null) {
            if (sourceWidget != null) {
                if (targetType != null && !targetType.isInstance(sourceWidget)) {
                    return sourceWidget;
                }
                Object value = sourceWidget.getValue();
                while (value instanceof IObservableValue) {
                    value = ((IObservableValue)value).getValue();
                }
                IValueConverter converter = this.getConverter();
                if (converter != null) {
                    value = converter.convert(value);
                }
                return value;
            }
            return this.source;
        }
        IBindingContext dataBindingContext = this.getDataBindingContext();
        BindingGate bindingGate = new BindingGate(dataBindingContext);
        bindingGate.bind((IObservable)sourceWidget, (IObservable)targetWidget, this);
        if (sourceWidget != null) {
            if (targetType != null && !targetType.isInstance(sourceWidget)) {
                return sourceWidget;
            }
            Object value = sourceWidget.getValue();
            while (value instanceof IObservableValue) {
                value = ((IObservableValue)value).getValue();
            }
            IValueConverter converter = this.getConverter();
            if (converter != null) {
                value = converter.convert(value);
            }
            return value;
        }
        return this.source;
    }

    protected Object getSource() {
        return this.source;
    }
}

