/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.core;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.IValidationRule;
import org.eclipse.e4.xwt.IValueConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.core.IBinding;
import org.eclipse.e4.xwt.core.IDynamicBinding;
import org.eclipse.e4.xwt.databinding.ControlDataBinding;
import org.eclipse.e4.xwt.databinding.DataBinding;
import org.eclipse.e4.xwt.internal.core.BindingExpressionPath;
import org.eclipse.e4.xwt.internal.core.DynamicBinding;
import org.eclipse.e4.xwt.internal.core.ScopeManager;
import org.eclipse.e4.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Binding
extends DynamicBinding {
    public static Binding[] EMPTY_ARRAY = new Binding[0];
    private String path;
    private Object source;
    private String elementName;
    private IValueConverter converter;
    private IValidationRule[] validationRules = IValidationRule.EMPTY_ARRAY;
    private IObservable observableSource;
    private UpdateSourceTrigger updateSourceTrigger = UpdateSourceTrigger.Default;
    private BindingExpressionPath pathSegments;

    public BindingExpressionPath getPathPropertySegments() {
        if (this.pathSegments == null) {
            this.pathSegments = new BindingExpressionPath(this.getPath());
        }
        return this.pathSegments;
    }

    public UpdateSourceTrigger getUpdateSourceTrigger() {
        return this.updateSourceTrigger;
    }

    public void setUpdateSourceTrigger(UpdateSourceTrigger updateSourceTrigger) {
        this.updateSourceTrigger = updateSourceTrigger;
    }

    public IValueConverter getConverter() {
        return this.converter;
    }

    public void setConverter(IValueConverter converter) {
        this.converter = converter;
    }

    public String getPath() {
        return this.path;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
        if (this.source instanceof IObservable) {
            this.observableSource = (IObservable)this.source;
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    protected Object getSourceObject() {
        if (this.source != null) {
            return this.source;
        }
        if (this.elementName != null) {
            return XWT.findElementByName(this.getControl(), this.elementName);
        }
        return null;
    }

    protected boolean isSelfBinding(Object data) {
        if (data != this) {
            return false;
        }
        Binding binding = (Binding)data;
        return BindingExpressionPath.isEmptyPath(binding.getPath());
    }

    @Override
    public Object createBoundSource() {
        Object value;
        Object control = this.getControl();
        Object source = this.getSourceObject();
        if (source == null) {
            source = XWT.getDataContext(control, IDynamicBinding.class);
            Object localDataContext = UserData.getLocalDataContext(control);
            if (localDataContext == this) {
                return source;
            }
        }
        if (source instanceof IDynamicBinding && (value = ((IDynamicBinding)source).createBoundSource()) != null && this.path != null) {
            Widget widget = UserData.getWidget(value);
            if (widget == null) {
                widget = UserData.getWidget(control);
            }
            return ScopeManager.observeValue((Object)widget, value, this.getPathPropertySegments(), this.getUpdateSourceTrigger());
        }
        if (source != null && !BindingExpressionPath.isEmptyPath(this.path)) {
            Widget widget = UserData.getWidget(source);
            if (widget == null) {
                widget = UserData.getWidget(control);
            }
            return ScopeManager.observeValue((Object)widget, source, this.getPathPropertySegments(), this.getUpdateSourceTrigger());
        }
        return source;
    }

    @Override
    public boolean isSourceControl() {
        IObservableValue observableValue;
        Object type;
        Object dataContextHost;
        Object source = this.getSourceObject();
        if (source == null && (dataContextHost = this.getDataContextHost()) != null) {
            source = UserData.getLocalDataContext(dataContextHost);
        }
        if (source instanceof IDynamicBinding) {
            return ((IDynamicBinding)source).isSourceControl();
        }
        if (source instanceof IBinding) {
            source = ((IBinding)source).getValue(null);
        }
        if (this.path == null) {
            return false;
        }
        int index = BindingExpressionPath.lastIndexOf(this.path);
        if (index == -1) {
            return source instanceof Control || source instanceof Viewer;
        }
        if (source instanceof IDataProvider) {
            return false;
        }
        String parentPath = this.path.substring(0, index);
        IObservableValue observable = ScopeManager.observeValue(this.getControl(), source, parentPath, this.getUpdateSourceTrigger());
        if (observable instanceof IObservableValue && (type = (observableValue = observable).getValueType()) != null) {
            return UserData.isUIElementType(type);
        }
        return false;
    }

    @Override
    public Object getValue(Class<?> targetType) {
        IDynamicBinding dynamicBinding;
        Object boundSource;
        Object dataContextHost;
        Object dataContext = this.getSourceObject();
        if (dataContext == null && (dataContextHost = this.getDataContextHost()) != null && (dataContext = UserData.getLocalDataContext(dataContextHost)) instanceof IDynamicBinding && (boundSource = (dynamicBinding = (IDynamicBinding)dataContext).createBoundSource()) != null) {
            dataContext = boundSource;
        }
        if (dataContext instanceof IBinding) {
            dataContext = ((IBinding)dataContext).getValue(null);
        }
        IDataProvider dataProvider = this.getDataProvider(dataContext);
        try {
            if (this.isSourceControl()) {
                ControlDataBinding controlDataBinding = new ControlDataBinding(dataContext, this, dataProvider);
                return controlDataBinding.getValue(targetType);
            }
        }
        catch (XWTException xWTException) {}
        DataBinding dataBinding = null;
        if (dataProvider != null && (this.path != null || dataContext instanceof IObservable)) {
            dataBinding = new DataBinding(this, dataProvider);
        }
        if (dataBinding != null) {
            return dataBinding.getValue(targetType);
        }
        return this.convertedValue(dataContext);
    }

    private Object convertedValue(Object value) {
        IValueConverter converter = this.getConverter();
        if (converter != null) {
            value = converter.convert(value);
        }
        return value;
    }

    public boolean isSourcePropertyReadOnly() {
        IDataProvider dataProvider = this.getDataProvider();
        try {
            return ScopeManager.isPropertyReadOnly(dataProvider, this.getPathPropertySegments());
        }
        catch (XWTException xWTException) {
            return false;
        }
    }

    public IObservable getObservableSource() {
        return this.observableSource;
    }

    public void setObservableSource(IObservable observableSource) {
        this.observableSource = observableSource;
    }

    public IValidationRule[] getValidationRules() {
        return this.validationRules;
    }

    public void setValidationRules(IValidationRule[] validationRules) {
        this.validationRules = validationRules;
    }

    public void setValidationRule(IValidationRule validationRule) {
        this.validationRules = new IValidationRule[]{validationRule};
    }

    @Override
    public void reset() {
        this.observableSource = null;
    }
}

