/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.utils;

import java.io.File;
import java.util.StringTokenizer;

public class PathHelper {
    public static final String URL_IDENTIFY_PREFIX = "file:";
    public static final String BACKWARD_SLASH = "\\";
    public static final String FORWARD_SLASH = "/";
    public static final String RELATIVE_PATH_SIG = "../";
    public static final String WHITE_SPACE_ASCII = "%20";

    public static String getRelativePath(String source, String target) {
        if (source == null || target == null) {
            return target;
        }
        File sourceFile = new File(source);
        if (!sourceFile.exists()) {
            return target;
        }
        File targetFile = new File(target);
        if (!targetFile.exists()) {
            return target;
        }
        source = PathHelper.switchToForwardSlashes(source);
        target = PathHelper.switchToForwardSlashes(target);
        int index = target.indexOf(FORWARD_SLASH);
        String container = null;
        while (index != -1) {
            container = target.substring(0, index);
            if (!source.startsWith(String.valueOf(container) + FORWARD_SLASH)) break;
            source = source.substring(index + 1);
            target = target.substring(index + 1);
            index = target.indexOf(FORWARD_SLASH);
        }
        index = source.indexOf(FORWARD_SLASH);
        while (index != -1) {
            target = RELATIVE_PATH_SIG + target;
            source = source.substring(index + 1);
            index = source.indexOf(FORWARD_SLASH);
        }
        return target;
    }

    public static String switchToForwardSlashes(String path) {
        path = path.replace(File.separatorChar, FORWARD_SLASH.charAt(0));
        path = path.replace(BACKWARD_SLASH.charAt(0), FORWARD_SLASH.charAt(0));
        return path;
    }

    public static String getAbsolutePath(String source, String relative) {
        int index;
        File file;
        if (source.indexOf(WHITE_SPACE_ASCII) != -1) {
            source = source.replace(WHITE_SPACE_ASCII, " ");
        }
        if (relative.indexOf(WHITE_SPACE_ASCII) != -1) {
            relative = relative.replace(WHITE_SPACE_ASCII, " ");
        }
        if (source.startsWith(FORWARD_SLASH)) {
            source = source.substring(1);
        }
        String prefix = null;
        if (source.startsWith(URL_IDENTIFY_PREFIX)) {
            prefix = URL_IDENTIFY_PREFIX;
            source = source.substring(URL_IDENTIFY_PREFIX.length());
            if (System.getProperty("os.arch").startsWith("Win")) {
                source = source.substring(1);
            }
        }
        if (!(file = new File(source)).exists()) {
            return relative;
        }
        if (file.isFile()) {
            source = file.getParent();
        }
        source = PathHelper.switchToForwardSlashes(source);
        if ((relative = PathHelper.switchToForwardSlashes(relative)).startsWith(FORWARD_SLASH)) {
            relative = relative.substring(1);
        }
        if ((index = relative.lastIndexOf(FORWARD_SLASH)) != -1) {
            String container = relative.substring(0, index);
            int i = source.indexOf(container);
            if (i != -1) {
                source = source.substring(0, i);
            } else {
                int j = relative.indexOf(RELATIVE_PATH_SIG);
                while (j != -1) {
                    relative = relative.substring(j + RELATIVE_PATH_SIG.length());
                    source = source.substring(0, source.lastIndexOf(FORWARD_SLASH));
                    j = relative.indexOf(RELATIVE_PATH_SIG);
                }
            }
        }
        if (System.getProperty("os.arch").startsWith("Win")) {
            source = FORWARD_SLASH + source;
        }
        return String.valueOf(prefix != null ? prefix : "") + source + FORWARD_SLASH + relative;
    }

    public static String convertToRelative(String input, String base) {
        StringTokenizer inputTokenizer = new StringTokenizer(input, FORWARD_SLASH);
        StringTokenizer baseTokenizer = new StringTokenizer(base, FORWARD_SLASH);
        String token1 = "";
        String token2 = "";
        while (inputTokenizer.hasMoreTokens() && baseTokenizer.hasMoreTokens() && (token1 = baseTokenizer.nextToken()).equals(token2 = inputTokenizer.nextToken())) {
        }
        String output = "";
        while (baseTokenizer.hasMoreTokens()) {
            baseTokenizer.nextToken();
            output = String.valueOf(output) + RELATIVE_PATH_SIG;
        }
        output = String.valueOf(output) + token2;
        while (inputTokenizer.hasMoreTokens()) {
            output = String.valueOf(output) + FORWARD_SLASH + inputTokenizer.nextToken();
        }
        return output;
    }
}

