/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.lang.reflect.Type;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.contexts.IContextRecorder;
import org.eclipse.e4.core.internal.contexts.RunAndTrackExt;

public class ContextObjectSupplier
extends PrimaryObjectSupplier {
    protected static final String ECLIPSE_CONTEXT_NAME = IEclipseContext.class.getName();
    private final IEclipseContext context;

    public ContextObjectSupplier(IEclipseContext context, IInjector injector) {
        this.context = context;
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public Object[] get(IObjectDescriptor[] descriptors, IRequestor requestor, boolean track, boolean group) {
        Object[] result = new Object[descriptors.length];
        String[] keys = new String[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            keys[i] = descriptors[i] == null ? null : this.getKey(descriptors[i]);
            ++i;
        }
        if (requestor != null && track) {
            ContextInjectionListener trackable = new ContextInjectionListener(this.context, result, keys, requestor, group);
            this.context.runAndTrack(trackable);
        } else {
            i = 0;
            while (i < descriptors.length) {
                if (keys[i] != null) {
                    result[i] = ECLIPSE_CONTEXT_NAME.equals(keys[i]) ? this.context : (this.context.containsKey(keys[i]) ? this.context.get(keys[i]) : IInjector.NOT_A_VALUE);
                }
                ++i;
            }
        }
        return result;
    }

    private String getKey(IObjectDescriptor descriptor) {
        if (descriptor.hasQualifier(Named.class)) {
            Named namedAnnotation = (Named)descriptor.getQualifier(Named.class);
            return namedAnnotation.value();
        }
        Type elementType = descriptor.getDesiredType();
        if (elementType instanceof Class) {
            return ((Class)elementType).getName();
        }
        return null;
    }

    public static ContextObjectSupplier getObjectSupplier(IEclipseContext context, IInjector injector) {
        if (context == null) {
            return null;
        }
        ContextObjectSupplier supplier = context.getLocal(ContextObjectSupplier.class);
        if (supplier != null) {
            return supplier;
        }
        ContextObjectSupplier objectSupplier = new ContextObjectSupplier(context, injector);
        context.set(ContextObjectSupplier.class, objectSupplier);
        return objectSupplier;
    }

    private static class ContextInjectionListener
    extends RunAndTrackExt {
        private final Object[] result;
        private final String[] keys;
        private final IRequestor requestor;
        private final IEclipseContext context;

        public ContextInjectionListener(IEclipseContext context, Object[] result, String[] keys, IRequestor requestor, boolean group) {
            super(group);
            this.result = result;
            this.keys = keys;
            this.requestor = requestor;
            this.context = context;
        }

        public boolean update(IEclipseContext eventsContext, int eventType, Object[] extraArguments, IContextRecorder recorder) {
            if (eventType == 0) {
                int i = 0;
                while (i < this.keys.length) {
                    if (this.keys[i] != null) {
                        if (ECLIPSE_CONTEXT_NAME.equals(this.keys[i])) {
                            this.result[i] = this.context;
                            this.context.getParent();
                        } else {
                            this.result[i] = this.context.containsKey(this.keys[i]) ? this.context.get(this.keys[i]) : IInjector.NOT_A_VALUE;
                        }
                    }
                    ++i;
                }
                return true;
            }
            if (eventType == 3) {
                if (eventsContext == this.context) {
                    ContextObjectSupplier originatingSupplier = eventsContext.getLocal(ContextObjectSupplier.class);
                    this.requestor.disposed((PrimaryObjectSupplier)originatingSupplier);
                    return false;
                }
            } else if (eventType == 4) {
                if (eventsContext == this.context) {
                    ContextObjectSupplier originatingSupplier = eventsContext.getLocal(ContextObjectSupplier.class);
                    return this.requestor.uninject(extraArguments[0], (PrimaryObjectSupplier)originatingSupplier);
                }
            } else {
                this.requestor.resolveArguments();
                if (recorder != null) {
                    recorder.stopAccessRecording();
                }
                try {
                    this.requestor.execute();
                }
                finally {
                    if (recorder != null) {
                        recorder.startAcessRecording();
                    }
                }
            }
            return true;
        }

        public boolean changed(IEclipseContext eventsContext) {
            return true;
        }

        public int hashCode() {
            int hashRresult = 1;
            hashRresult = 31 * hashRresult + (this.context == null ? 0 : this.context.hashCode());
            hashRresult = 31 * hashRresult + (this.requestor == null ? 0 : this.requestor.hashCode());
            return hashRresult;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContextInjectionListener other = (ContextInjectionListener)obj;
            if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
                return false;
            }
            return !(this.requestor == null ? other.requestor != null : !this.requestor.equals(other.requestor));
        }
    }
}

