/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dnd;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public abstract class JdtViewerDropAdapter
extends DropTargetAdapter {
    public static final int LOCATION_BEFORE = 1;
    public static final int LOCATION_AFTER = 2;
    public static final int LOCATION_ON = 3;
    public static final int LOCATION_NONE = 4;
    private Viewer viewer;
    private int currentOperation = 0;
    private int lastValidOperation = 0;
    private Object currentTarget;
    private int currentLocation;
    private boolean feedbackEnabled = true;
    private boolean scrollEnabled = true;
    private boolean expandEnabled = true;
    private boolean selectFeedbackEnabled = true;

    protected JdtViewerDropAdapter(Viewer viewer) {
        this.viewer = viewer;
    }

    protected int determineLocation(DropTargetEvent event) {
        if (!(event.item instanceof Item)) {
            return 4;
        }
        Item item = (Item)event.item;
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.viewer.getControl().toControl(coordinates);
        if (item != null) {
            Rectangle bounds = this.getBounds(item);
            if (bounds == null) {
                return 4;
            }
            if (coordinates.y - bounds.y < 5) {
                return 1;
            }
            if (bounds.y + bounds.height - coordinates.y < 5) {
                return 2;
            }
        }
        return 3;
    }

    protected Object determineTarget(DropTargetEvent event) {
        return event.item == null ? null : event.item.getData();
    }

    private void doDropValidation(DropTargetEvent event) {
        event.detail = this.currentOperation = this.determineOperation(this.currentTarget, this.lastValidOperation, event.currentDataType, event.operations);
        this.setFeedback(event, this.currentLocation);
    }

    public void dragEnter(DropTargetEvent event) {
        this.currentTarget = this.determineTarget(event);
        this.currentLocation = this.determineLocation(event);
        this.lastValidOperation = event.detail;
        this.doDropValidation(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.currentTarget = this.determineTarget(event);
        this.lastValidOperation = event.detail;
        this.doDropValidation(event);
    }

    public void dragOver(DropTargetEvent event) {
        Object target = this.determineTarget(event);
        int oldLocation = this.currentLocation;
        this.currentLocation = this.determineLocation(event);
        this.setFeedback(event, this.currentLocation);
        if (target != this.currentTarget || this.currentLocation != oldLocation) {
            this.currentTarget = target;
            this.doDropValidation(event);
        }
    }

    public void drop(DropTargetEvent event) {
        this.currentLocation = this.determineLocation(event);
        if (!this.performDrop(event.data)) {
            event.detail = 0;
        }
        this.currentOperation = event.detail;
    }

    public void dropAccept(DropTargetEvent event) {
        event.detail = this.determineOperation(this.currentTarget, event.detail, event.currentDataType, event.operations);
    }

    protected Rectangle getBounds(Item item) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getBounds();
        }
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds(0);
        }
        return null;
    }

    protected int getCurrentLocation() {
        return this.currentLocation;
    }

    protected int getCurrentOperation() {
        return this.currentOperation;
    }

    protected Object getCurrentTarget() {
        return this.currentTarget;
    }

    public boolean getFeedbackEnabled() {
        return this.feedbackEnabled;
    }

    protected Object getSelectedObject() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            return structured.getFirstElement();
        }
        return null;
    }

    protected Viewer getViewer() {
        return this.viewer;
    }

    protected void handleException(Throwable exception, DropTargetEvent event) {
        exception.printStackTrace();
        event.detail = 0;
    }

    public abstract boolean performDrop(Object var1);

    private void setFeedback(DropTargetEvent event, int location) {
        if (this.feedbackEnabled) {
            switch (location) {
                case 1: {
                    event.feedback = 2;
                    break;
                }
                case 2: {
                    event.feedback = 4;
                    break;
                }
                default: {
                    event.feedback = 1;
                }
            }
        }
        if (!this.selectFeedbackEnabled) {
            event.feedback &= 0xFFFFFFFE;
        }
        if (this.expandEnabled) {
            event.feedback |= 0x10;
        }
        if (this.scrollEnabled) {
            event.feedback |= 8;
        }
    }

    public void setFeedbackEnabled(boolean value) {
        this.feedbackEnabled = value;
    }

    public void setSelectionFeedbackEnabled(boolean value) {
        this.selectFeedbackEnabled = value;
    }

    public void setScrollExpandEnabled(boolean value) {
        this.expandEnabled = value;
        this.scrollEnabled = value;
    }

    public void setExpandEnabled(boolean value) {
        this.expandEnabled = value;
    }

    public void setScrollEnabled(boolean value) {
        this.scrollEnabled = value;
    }

    public abstract boolean validateDrop(Object var1, int var2, TransferData var3);

    protected int determineOperation(Object target, int operation, TransferData transferType, int operations) {
        if (!this.validateDrop(target, operation, transferType)) {
            return 0;
        }
        return operation;
    }
}

