/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.dnd;

import org.eclipse.e4.xwt.ui.editor.XWTEditor;
import org.eclipse.e4.xwt.ui.editor.dnd.DnDAdapter;
import org.eclipse.e4.xwt.vex.VEXContext;
import org.eclipse.e4.xwt.vex.VEXTextEditorHelper;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.w3c.dom.Node;

public abstract class DnDAdapterImpl
implements DnDAdapter {
    static final int CARET_WIDTH = 2;
    private int dropCaretOffset = -1;
    private XWTEditor editor;
    private LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();

    public DnDAdapterImpl(XWTEditor editor) {
        this.setEditor(editor);
    }

    public void drop(DropTargetEvent event) {
        Object selection = this.getSelection();
        if (!this.isAccept()) {
            return;
        }
        Template template = this.createTemplate(selection);
        if (template == null) {
            return;
        }
        this.drop(template, this.getDropCaretOffset(), 0);
    }

    protected void drop(Template template, int dropCaretOffset, int length) {
        TemplateContextType type;
        DocumentTemplateContext templateContext;
        IDocument document = this.editor.getTextEditor().getTextViewer().getDocument();
        ContextTypeRegistry registry = XMLUIPlugin.getDefault().getTemplateContextRegistry();
        if (registry != null && (templateContext = new DocumentTemplateContext(type = registry.getContextType(template.getContextTypeId()), document, new Position(dropCaretOffset, length))).canEvaluate(template)) {
            try {
                TemplateBuffer templateBuffer = templateContext.evaluate(template);
                String templateString = templateBuffer.getString();
                document.replace(dropCaretOffset, length, templateString);
                StyledText styledText = this.editor.getTextWidget();
                int position = this.getCursorOffset(templateBuffer) + dropCaretOffset;
                styledText.setCaretOffset(position);
                styledText.setFocus();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected abstract Template createTemplate(Object var1);

    private int getCursorOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    public void dragOver(DropTargetEvent event) {
        Node node;
        if (!this.isAccept()) {
            return;
        }
        VEXContext context = this.editor.getContext();
        int position = context.findDropPosition(node = this.getCurrentNode(event), this.getScope(), this.getContextType(), this.getCursor(event));
        if (position < 0) {
            event.detail = 0;
        } else {
            StyledText styledText = this.editor.getTextWidget();
            this.setDropCaretOffset(position);
            this.refreshCaret(styledText, this.getDropCaretOffset());
        }
    }

    protected Node getCurrentNode(DropTargetEvent event) {
        StructuredTextViewer textViewer = this.editor.getTextEditor().getTextViewer();
        return VEXTextEditorHelper.getNode((ITextViewer)textViewer, (int)this.getCursor(event));
    }

    protected int getCursor(DropTargetEvent event) {
        StructuredTextViewer textViewer = this.editor.getTextEditor().getTextViewer();
        return VEXTextEditorHelper.getOffsetAtPoint((ITextViewer)textViewer, (Point)new Point(event.x, event.y));
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
        StyledText styledText = this.editor.getTextWidget();
        if (this.getDropCaretOffset() != -1) {
            this.refreshCaret(styledText, this.getDropCaretOffset());
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    protected void refreshCaret(StyledText text, int newOffset) {
        if (newOffset != -1) {
            Point newPos = text.getLocationAtOffset(newOffset);
            int newHeight = text.getLineHeight(newOffset);
            text.redraw(newPos.x, newPos.y, 2, newHeight, false);
        }
    }

    public void setEditor(XWTEditor editor) {
        this.editor = editor;
    }

    public XWTEditor getEditor() {
        return this.editor;
    }

    protected Object getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.transfer.getSelection();
        if (selection != null) {
            return selection.getFirstElement();
        }
        return null;
    }

    public boolean isAccept() {
        Object selection = this.getSelection();
        if (selection == null) {
            return false;
        }
        return this.isAccept(selection);
    }

    protected abstract boolean isAccept(Object var1);

    public void setDropCaretOffset(int dropCaretOffset) {
        this.dropCaretOffset = dropCaretOffset;
    }

    public int getDropCaretOffset() {
        return this.dropCaretOffset;
    }
}

