/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.markers.internal.DialogMarkerProperties;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.Util;

public class DialogProblemProperties
extends DialogMarkerProperties {
    private Label severityLabel;
    private Label severityImage;

    public DialogProblemProperties(Shell parentShell) {
        super(parentShell);
        this.setType("org.eclipse.core.resources.problemmarker");
    }

    protected void createAttributesArea(Composite parent) {
        this.createSeperator(parent);
        super.createAttributesArea(parent);
        new Label(parent, 0).setText(MarkerMessages.propertiesDialog_severityLabel);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.severityImage = new Label(composite, 0);
        this.severityLabel = new Label(composite, 0);
    }

    protected void updateDialogFromMarker() {
        super.updateDialogFromMarker();
        IMarker marker = this.getMarker();
        if (marker == null) {
            return;
        }
        this.severityImage.setImage(Util.getImage(marker.getAttribute("severity", -1)));
        int severity = marker.getAttribute("severity", -1);
        if (severity == 2) {
            this.severityLabel.setText(MarkerMessages.propertiesDialog_errorLabel);
        } else if (severity == 1) {
            this.severityLabel.setText(MarkerMessages.propertiesDialog_warningLabel);
        } else if (severity == 0) {
            this.severityLabel.setText(MarkerMessages.propertiesDialog_infoLabel);
        } else {
            this.severityLabel.setText(MarkerMessages.propertiesDialog_noseverityLabel);
        }
    }
}

