/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.IPropertiesFilePartitions;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFilePartitionScanner;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;

public class PropertiesFileMergeViewer
extends TextMergeViewer {
    private List fSourceViewerConfigurations;
    private IPropertyChangeListener fPreferenceChangeListener;
    private IPreferenceStore fPreferenceStore;

    public PropertiesFileMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, 0x2000000, configuration);
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (!(textViewer instanceof SourceViewer)) {
            return;
        }
        if (this.fPreferenceStore == null) {
            this.fSourceViewerConfigurations = new ArrayList(3);
            this.fPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
            this.fPreferenceChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    Iterator iter = PropertiesFileMergeViewer.this.fSourceViewerConfigurations.iterator();
                    while (iter.hasNext()) {
                        ((PropertiesFileSourceViewerConfiguration)((Object)iter.next())).handlePropertyChangeEvent(event);
                    }
                    PropertiesFileMergeViewer.this.invalidateTextPresentation();
                }
            };
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
        }
        PropertiesFileSourceViewerConfiguration sourceViewerConfiguration = new PropertiesFileSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), this.fPreferenceStore, null, this.getDocumentPartitioning());
        this.fSourceViewerConfigurations.add(sourceViewerConfiguration);
        ((SourceViewer)textViewer).configure((SourceViewerConfiguration)sourceViewerConfiguration);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return new FastPartitioner((IPartitionTokenScanner)new PropertiesFilePartitionScanner(), IPropertiesFilePartitions.PARTITIONS);
    }

    protected String getDocumentPartitioning() {
        return "___pf_partitioning";
    }

    public String getTitle() {
        return CompareMessages.PropertiesFileMergeViewer_title;
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            this.fPreferenceStore = null;
            this.fPreferenceChangeListener = null;
            this.fSourceViewerConfigurations = null;
        }
        super.handleDispose(event);
    }
}

