/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import com.ibm.icu.text.MessageFormat;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.launching.LaunchingMessages;
import org.eclipse.wst.jsdt.launching.LibraryLocation;

public class JREContainer
implements IJsGlobalScopeContainer {
    private IVMInstall fVMInstall = null;
    private IPath fPath = null;
    private static Map fgClasspathEntries = null;
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    private static IIncludePathEntry[] getClasspathEntries(IVMInstall vm) {
        IIncludePathEntry[] entries;
        if (fgClasspathEntries == null) {
            fgClasspathEntries = new HashMap(10);
        }
        if ((entries = (IIncludePathEntry[])fgClasspathEntries.get(vm)) == null) {
            entries = JREContainer.computeClasspathEntries(vm);
            fgClasspathEntries.put(vm, entries);
        }
        return entries;
    }

    private static IIncludePathEntry[] computeClasspathEntries(IVMInstall vm) {
        LibraryLocation[] libs = vm.getLibraryLocations();
        boolean overridejsdoc = false;
        if (libs == null) {
            libs = JavaRuntime.getLibraryLocations(vm);
            overridejsdoc = true;
        }
        ArrayList<IIncludePathEntry> entries = new ArrayList<IIncludePathEntry>(libs.length);
        int i = 0;
        while (i < libs.length) {
            if (!libs[i].getSystemLibraryPath().isEmpty()) {
                IPath rootPath;
                IPath sourcePath = libs[i].getSystemLibrarySourcePath();
                if (sourcePath.isEmpty()) {
                    sourcePath = null;
                }
                if ((rootPath = libs[i].getPackageRootPath()).isEmpty()) {
                    rootPath = null;
                }
                URL javadocLocation = libs[i].getJavadocLocation();
                if (overridejsdoc && javadocLocation == null) {
                    javadocLocation = vm.getJavadocLocation();
                }
                IIncludePathAttribute[] attributes = null;
                attributes = javadocLocation == null ? new IIncludePathAttribute[]{} : new IIncludePathAttribute[]{JavaScriptCore.newIncludepathAttribute("javadoc_location", javadocLocation.toExternalForm())};
                entries.add(JavaScriptCore.newLibraryEntry(libs[i].getSystemLibraryPath(), sourcePath, rootPath, EMPTY_RULES, attributes, false));
            }
            ++i;
        }
        return entries.toArray(new IIncludePathEntry[entries.size()]);
    }

    public JREContainer(IVMInstall vm, IPath path) {
        this.fVMInstall = vm;
        this.fPath = path;
    }

    public IIncludePathEntry[] getClasspathEntries() {
        return this.getIncludepathEntries();
    }

    public IIncludePathEntry[] getIncludepathEntries() {
        return JREContainer.getClasspathEntries(this.fVMInstall);
    }

    public String getDescription() {
        return MessageFormat.format((String)LaunchingMessages.JREContainer_JRE_System_Library_1, (Object[])new String[0]);
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public String[] resolvedLibraryImport(String a) {
        return null;
    }
}

