/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.UpdateListener;

public class Update
extends Command {
    public static final Command.LocalOption CLEAR_STICKY = new Command.LocalOption("-A");
    public static final Command.LocalOption IGNORE_LOCAL_CHANGES = new Command.LocalOption("-C");
    public static final Command.LocalOption RETRIEVE_ABSENT_DIRECTORIES = new Command.LocalOption("-d");
    public static final Command.LocalOption JOIN = new Command.LocalOption("-j");
    private static final ICommandOutputListener DEFAULT_OUTPUT_LISTENER = new UpdateListener(null);
    public static final int STATE_NONE = 0;
    public static final int STATE_ADDED_LOCAL = 1;
    public static final int STATE_UNKOWN = 2;
    public static final int STATE_REMOTE_CHANGES = 3;
    public static final int STATE_DELETED = 4;
    public static final int STATE_MODIFIED = 5;
    public static final int STATE_CONFLICT = 6;
    public static final int STATE_MERGEABLE_CONFLICT = 7;

    public static Command.LocalOption makeTagOption(CVSTag tag) {
        int type = tag.getType();
        switch (type) {
            case 0: {
                return CLEAR_STICKY;
            }
        }
        return Command.makeTagOption(tag);
    }

    protected Update() {
    }

    protected String getRequestId() {
        return "update";
    }

    protected ICommandOutputListener getDefaultCommandOutputListener() {
        return DEFAULT_OUTPUT_LISTENER;
    }

    protected ICVSResource[] sendLocalResourceState(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        this.sendFileStructure(session, resources, localOptions, true, monitor);
        return resources;
    }

    protected IStatus commandFinished(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor, IStatus status) throws CVSException {
        if (status.getCode() == -10) {
            return status;
        }
        if (PRUNE_EMPTY_DIRECTORIES.isElementOf(localOptions)) {
            new PruneFolderVisitor().visit(session, resources);
        }
        return status;
    }

    protected Command.LocalOption[] filterLocalOptions(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions) {
        ArrayList<Command.LocalOption> newOptions = new ArrayList<Command.LocalOption>(Arrays.asList(localOptions));
        if (this.shouldRetrieveAbsentDirectories(session) && !RETRIEVE_ABSENT_DIRECTORIES.isElementOf(localOptions)) {
            newOptions.add(RETRIEVE_ABSENT_DIRECTORIES);
        }
        if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories() && !PRUNE_EMPTY_DIRECTORIES.isElementOf(localOptions) && !DO_NOT_CHANGE.isElementOf(globalOptions)) {
            newOptions.add(Command.PRUNE_EMPTY_DIRECTORIES);
        }
        localOptions = newOptions.toArray(new Command.LocalOption[newOptions.size()]);
        return super.filterLocalOptions(session, globalOptions, localOptions);
    }

    protected boolean shouldRetrieveAbsentDirectories(Session session) {
        IResource resource = null;
        RepositoryProvider provider = null;
        try {
            resource = session.getLocalRoot().getIResource();
            if (resource != null && (provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId())) != null && ((CVSTeamProvider)provider).getFetchAbsentDirectories()) {
                return true;
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        return provider == null && CVSProviderPlugin.getPlugin().getFetchAbsentDirectories();
    }

    protected void checkResourcesManaged(Session session, ICVSResource[] resources) throws CVSException {
        int i = 0;
        while (i < resources.length) {
            ICVSFolder folder = resources[i].isFolder() ? (((ICVSFolder)resources[i]).isCVSFolder() ? (ICVSFolder)resources[i] : resources[i].getParent()) : resources[i].getParent();
            if (folder == null || !folder.isCVSFolder() && folder.exists()) {
                if (folder == null) {
                    folder = (ICVSFolder)resources[i];
                }
                CVSStatus status = new CVSStatus(4, 4, NLS.bind((String)CVSMessages.Command_argumentNotManaged, (Object[])new String[]{folder.getName()}), session.getLocalRoot());
                throw new CVSException((IStatus)status);
            }
            ++i;
        }
    }

    protected IStatus doExecute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, String[] arguments, ICommandOutputListener listener, IProgressMonitor monitor) throws CVSException {
        session.setIgnoringLocalChanges(IGNORE_LOCAL_CHANGES.isElementOf(localOptions));
        try {
            IStatus iStatus = super.doExecute(session, globalOptions, localOptions, arguments, listener, monitor);
            return iStatus;
        }
        finally {
            session.setIgnoringLocalChanges(false);
        }
    }
}

