/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.ui.actions.ActionBase;
import org.eclipse.core.internal.resources.semantic.ui.actions.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.spi.ISemanticFileHistoryProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.SemanticResourceVariant;
import org.eclipse.core.resources.semantic.spi.SemanticResourceVariantComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;

public class DiffAction
extends ActionBase {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.getSelection().size() == 1 && this.checkSelectionNonLocalOnly() && this.getSelection().getFirstElement() instanceof ISemanticFile);
    }

    public void run(IAction action) {
        IRunnableWithProgress outerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ISemanticFile file = (ISemanticFile)DiffAction.this.getSelection().getFirstElement();
                    ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)file.getAdaptedFile().getLocationURI());
                    ISemanticFileHistoryProvider fhp = (ISemanticFileHistoryProvider)sfs.getEffectiveContentProvider().getAdapter(ISemanticFileHistoryProvider.class);
                    if (fhp == null) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openInformation((Shell)DiffAction.this.getShell(), (String)Messages.DiffAction_CompareAction_XGRP, (String)Messages.DiffAction_NoHistory_XMSG);
                            }
                        });
                        return;
                    }
                    IFileRevision[] revs = fhp.getResourceVariants(sfs, monitor);
                    if (revs == null || revs[1] == null) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openInformation((Shell)DiffAction.this.getShell(), (String)Messages.DiffAction_CompareAction_XGRP, (String)Messages.DiffAction_NoHistory_XMSG);
                            }
                        });
                        return;
                    }
                    IFileRevision hist = fhp.getWorkspaceFileRevision(sfs);
                    IResourceVariant[] var = new IResourceVariant[]{new SemanticResourceVariant(hist, sfs), new SemanticResourceVariant(revs[1], sfs)};
                    SyncInfo syncinfo = new SyncInfo((IResource)file.getAdaptedFile(), var[0], var[1], (IResourceVariantComparator)new SemanticResourceVariantComparator(var[0] != null));
                    syncinfo.init();
                    SyncInfoCompareInput input = new SyncInfoCompareInput("", syncinfo);
                    input.getCompareConfiguration().setLeftEditable(false);
                    CompareUI.openCompareEditor((CompareEditorInput)input);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        this.run(outerRunnable);
    }
}

