/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;

public class LaunchPluginValidator {
    public static final int DISPLAY_VALIDATION_ERROR_CODE = 1001;

    private static IPluginModelBase[] getSelectedWorkspacePlugins(ILaunchConfiguration configuration) throws CoreException {
        boolean usedefault = configuration.getAttribute("default", true);
        boolean useFeatures = configuration.getAttribute("usefeatures", false);
        IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
        if (usedefault || useFeatures || models.length == 0) {
            return models;
        }
        Set result = null;
        Map bundles = BundleLauncherHelper.getWorkspaceBundleMap(configuration, null, "selected_workspace_plugins");
        result = bundles.keySet();
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public static Set parsePlugins(ILaunchConfiguration configuration, String attribute) throws CoreException {
        HashSet<Object> set = new HashSet<Object>();
        String ids = configuration.getAttribute(attribute, null);
        if (ids != null) {
            String[] entries = ids.split(",");
            HashMap<String, IPluginModelBase> unmatchedEntries = new HashMap<String, IPluginModelBase>();
            int i = 0;
            while (i < entries.length) {
                int index = entries[i].indexOf(64);
                if (index < 0) {
                    entries[i] = entries[i].concat("@default:default");
                    index = entries[i].indexOf(64);
                }
                String idVersion = entries[i].substring(0, index);
                int versionIndex = entries[i].indexOf(42);
                String id = versionIndex > 0 ? idVersion.substring(0, versionIndex) : idVersion;
                String version = versionIndex > 0 ? idVersion.substring(versionIndex + 1) : null;
                ModelEntry entry = PluginRegistry.findEntry((String)id);
                if (entry != null) {
                    IPluginModelBase[] matchingModels = attribute.equals("selected_target_plugins") ? entry.getExternalModels() : entry.getWorkspaceModels();
                    int j = 0;
                    while (j < matchingModels.length) {
                        if (matchingModels[j].isEnabled()) {
                            if (version == null || matchingModels[j].getPluginBase().getVersion().equals(version)) {
                                set.add(matchingModels[j]);
                            } else if (matchingModels.length == 1 && unmatchedEntries.remove(id) == null) {
                                unmatchedEntries.put(id, matchingModels[j]);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            set.addAll(unmatchedEntries.values());
        }
        return set;
    }

    public static IProject[] getAffectedProjects(ILaunchConfiguration config) throws CoreException {
        if (config.getAttribute("restart", false)) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IPluginModelBase[] models = LaunchPluginValidator.getSelectedWorkspacePlugins(config);
        int i = 0;
        while (i < models.length) {
            IProject project = models[i].getUnderlyingResource().getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                projects.add(project);
            }
            ++i;
        }
        SearchablePluginsManager manager = PDECore.getDefault().getSearchablePluginsManager();
        IJavaProject proxy = manager.getProxyProject();
        if (proxy != null) {
            projects.add(proxy.getProject());
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public static void runValidationOperation(LaunchValidationOperation op, IProgressMonitor monitor) throws CoreException {
        op.run(monitor);
        if (op.hasErrors()) {
            String message = NLS.bind((String)PDEMessages.PluginValidation_error, (Object)op.getInput().toString());
            Status status = new Status(4, "org.eclipse.pde.launching", 1001, message, null);
            IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            if (statusHandler == null) {
                PDELaunchingPlugin.log((IStatus)status);
            } else {
                statusHandler.handleStatus((IStatus)status, (Object)op);
            }
        }
    }
}

