/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.e4.xwt.IConstants;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.callback.IBeforeParsingCallback;
import org.eclipse.e4.xwt.internal.xml.DocumentObject;
import org.eclipse.e4.xwt.internal.xml.DocumentRoot;
import org.eclipse.e4.xwt.internal.xml.Element;
import org.eclipse.e4.xwt.internal.xml.ElementHandler;
import org.eclipse.e4.xwt.internal.xml.XDataHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ElementManager {
    private DocumentRoot documentRoot = new DocumentRoot();
    private SAXParserFactory parserFactory;
    private ErrorHandler errorHandler;
    private String encoding;
    private Map<String, Element> elements = new HashMap<String, Element>();
    private Element rootElement;
    private Element xDataElement;
    private static Random RANDOM = new Random();

    public static String generateID(String typeName) {
        return String.valueOf(typeName) + RANDOM.nextInt(Integer.MAX_VALUE);
    }

    public ElementManager() {
        this.encoding = System.getProperty("file.encoding");
        this.parserFactory = SAXParserFactory.newInstance();
        this.parserFactory.setNamespaceAware(true);
        this.parserFactory.setValidating(true);
        this.errorHandler = new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                Exception cause = exception.getException();
                try {
                    if (cause != null) {
                        XWT.getLogger().error(cause);
                    } else {
                        XWT.getLogger().error(exception);
                    }
                }
                catch (Exception exception2) {
                    if (cause != null) {
                        throw new SAXException(exception.getLocalizedMessage(), cause);
                    }
                    throw new SAXException(exception);
                }
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                Exception cause = exception.getException();
                try {
                    if (cause != null) {
                        XWT.getLogger().error(cause);
                    } else {
                        XWT.getLogger().error(exception);
                    }
                }
                catch (Exception exception2) {
                    if (cause != null) {
                        throw new SAXException(exception.getLocalizedMessage(), cause);
                    }
                    throw new SAXException(exception);
                }
                throw new RuntimeException();
            }

            public void warning(SAXParseException exception) throws SAXException {
                Exception cause = exception.getException();
                try {
                    if (cause != null) {
                        XWT.getLogger().error(cause);
                    } else {
                        XWT.getLogger().error(exception);
                    }
                }
                catch (Exception exception2) {
                    if (cause != null) {
                        throw new SAXException(exception.getLocalizedMessage(), cause);
                    }
                    throw new SAXException(exception);
                }
            }
        };
    }

    public DocumentRoot getDocumentRoot() {
        return this.documentRoot;
    }

    public Element getElement(String id) {
        assert (id != null);
        return this.elements.get(id);
    }

    public String[] getElements() {
        return this.elements.keySet().toArray(IConstants.EMPTY_STRING_ARRAY);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public boolean hasElement(String id) {
        assert (id != null);
        return this.elements.containsKey(id);
    }

    protected void setEncoding(String encoding) {
        assert (encoding != null);
        this.encoding = encoding;
    }

    public Element load(URL url, IBeforeParsingCallback callback) throws Exception {
        this.reset();
        if (callback == null) {
            this.documentRoot.init(null, url.toString());
            InputStream input = url.openStream();
            try {
                this.doLoad(input);
            }
            finally {
                input.close();
            }
            input = this.documentRoot.openStream();
            try {
                this.loadXData(input);
            }
            finally {
                input.close();
            }
        }
        String content = callback.onParsing(url.toString());
        this.documentRoot.init(null, content);
        InputStream input = new ByteArrayInputStream(content.getBytes());
        try {
            this.doLoad(input);
        }
        finally {
            input.close();
        }
        input = this.documentRoot.openStream();
        try {
            this.loadXData(input);
        }
        finally {
            input.close();
        }
        return this.rootElement;
    }

    public Element load(InputStream stream, URL url) throws Exception {
        this.reset();
        PushbackInputStream pis = null;
        if (stream != null) {
            pis = stream instanceof PushbackInputStream ? (PushbackInputStream)stream : new PushbackInputStream(stream, 4);
        }
        this.documentRoot.init(pis, url.toString());
        InputStream input = pis;
        if (pis == null) {
            input = this.documentRoot.openStream();
        }
        this.doLoad(input);
        input = this.documentRoot.openStream();
        this.loadXData(input);
        input.close();
        return this.rootElement;
    }

    public void load(InputStream stream, DocumentObject parent) throws SAXException {
        assert (stream != null);
        ElementHandler contentHandler = new ElementHandler(parent, this);
        try {
            SAXParser parser = this.parserFactory.newSAXParser();
            parser.getXMLReader().setErrorHandler(this.errorHandler);
            parser.parse(stream, (DefaultHandler)contentHandler);
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce.getLocalizedMessage(), pce);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe.getLocalizedMessage(), ioe);
        }
    }

    private void loadXData(InputStream stream) {
        if (this.xDataElement != null) {
            try {
                SAXParser parser = this.parserFactory.newSAXParser();
                parser.getXMLReader().setErrorHandler(this.errorHandler);
                StringBuilder out = new StringBuilder();
                parser.parse(stream, (DefaultHandler)new XDataHandler(out));
                String content = out.toString();
                this.xDataElement.setContent(content);
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {}
        }
    }

    protected void preElement(Element element) {
        assert (element != null);
        assert (this.elements.containsKey(element.getId())) : "Element already exists in registry: " + element.getId();
        this.elements.put(element.getId(), element);
        if (element.getParent() == null && this.rootElement == null) {
            this.rootElement = element;
        }
    }

    protected void postElement(Element element) {
        assert (element != null);
        assert (!this.elements.containsKey(element.getId())) : "Element not found in registry: " + element.getId();
        if ("xdata".equalsIgnoreCase(element.getName()) && "http://www.eclipse.org/xwt".equals(element.getNamespace())) {
            this.xDataElement = element;
        }
    }

    private void doLoad(InputStream stream) throws Exception {
        assert (stream != null);
        ElementHandler contentHandler = new ElementHandler(this);
        try {
            SAXParser parser = this.parserFactory.newSAXParser();
            parser.getXMLReader().setErrorHandler(this.errorHandler);
            parser.parse(stream, (DefaultHandler)contentHandler);
        }
        catch (SAXException saxe) {
            throw saxe;
        }
        catch (ParserConfigurationException pce) {
            try {
                XWT.getLogger().error(pce);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw pce;
        }
        catch (IOException ioe) {
            try {
                XWT.getLogger().error(ioe);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw ioe;
        }
    }

    private void reset() {
        this.documentRoot.reset();
    }
}

