/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.help.internal.base.remote.RemoteStatusData;
import org.eclipse.help.internal.protocols.HelpURLStreamHandler;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.WebappPreferences;

public class StatusProducer
implements IHelpContentProducer {
    public static final String REMOTE_STATUS_HREF = "NetworkHelpStatus.html";
    public static final String MISSING_TOPIC_HREF = "MissingTopicStatus.html";
    public static final String SEARCH_REMOTE_STATUS_HREF = "SearchNetworkHelpStatus.html";
    private static final String TAB = "  ";
    private static final String INDEX = "/index.jsp";
    private static final String BEGIN_HEAD_HTML = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<html>\n" + StatusProducer.tab(1) + "<head>\n" + StatusProducer.tab(2) + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n";
    private static final String END_HEAD_HTML = String.valueOf(StatusProducer.tab(1)) + "</head>\n";
    private static final String END_BODY_HTML = String.valueOf(StatusProducer.tab(2)) + "</div>\n" + StatusProducer.tab(1) + "</body>\n</html>";

    public InputStream getInputStream(String pluginID, String href, Locale locale) {
        boolean allFailed;
        String errorPage;
        if (!(href.equalsIgnoreCase(REMOTE_STATUS_HREF) || href.equalsIgnoreCase(MISSING_TOPIC_HREF) || href.equalsIgnoreCase(SEARCH_REMOTE_STATUS_HREF))) {
            return null;
        }
        StringBuffer pageBuffer = new StringBuffer();
        ArrayList remoteSites = RemoteStatusData.getRemoteSites();
        ArrayList badSites = RemoteStatusData.checkSitesConnectivity((ArrayList)remoteSites);
        if (remoteSites.isEmpty()) {
            return null;
        }
        if (href.equalsIgnoreCase(MISSING_TOPIC_HREF) && (errorPage = Platform.getPreferencesService().getString("org.eclipse.help.base", "page_not_found", null, null)) != null && errorPage.length() > 0) {
            try {
                URL helpURL = new URL("help", null, -1, errorPage, HelpURLStreamHandler.getDefault());
                return helpURL.openStream();
            }
            catch (MalformedURLException e) {
                HelpWebappPlugin.logError("Unable to locate error page: " + errorPage, e);
            }
            catch (IOException e) {
                HelpWebappPlugin.logError("Unable to open error page: " + errorPage, e);
            }
        }
        pageBuffer.append(this.getHtmlHead(locale));
        pageBuffer.append(this.getBeginHtmlBody());
        if (remoteSites.size() == badSites.size()) {
            allFailed = true;
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h1>" + WebappResources.getString("allRemoteHelpUnavailable", locale) + "</h1>\n");
        } else {
            allFailed = false;
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h1>" + WebappResources.getString("someRemoteHelpUnavailable", locale) + "</h1>\n");
        }
        if (href.equalsIgnoreCase(REMOTE_STATUS_HREF)) {
            WebappPreferences prefs = new WebappPreferences();
            String homepage = "/help/topic" + prefs.getHelpHome();
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<div style=\"position:absolute;right:4px;top:4px;\">\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<table>\n" + StatusProducer.tab(5) + "<tr>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(6)) + "<td style=\"background-color:white;border-width:1px;border-style:solid;border-color:grey;\">" + this.makeAnchor(homepage, WebappResources.getString("Close", locale), "style=\"font-size:.8em;\"", false) + "</td>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(5)) + "</tr>\n" + StatusProducer.tab(4) + "</table>\n" + StatusProducer.tab(3) + "</div>\n");
        }
        if (href.equalsIgnoreCase(MISSING_TOPIC_HREF)) {
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<p>" + WebappResources.getString("topicUnavailable", locale) + "</p>\n");
        }
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<p>" + WebappResources.getString("potentialCauses", locale) + "</p>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<ul>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<li>" + WebappResources.getString("serversCouldBeDown", locale) + "</li>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<li>" + WebappResources.getString("mayNeedProxy", locale) + "</li>\n");
        if (allFailed) {
            pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<li>" + WebappResources.getString("networkCouldBeDown", locale) + "</li>\n");
        }
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "</ul>\n");
        if (remoteSites.size() > badSites.size()) {
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h2>" + WebappResources.getString("sitesWithConnectivity", locale) + "</h2>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<ul>\n");
            int r = 0;
            while (r < remoteSites.size()) {
                if (!badSites.contains(remoteSites.get(r))) {
                    pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<li>" + this.makeAnchor(remoteSites.get(r) + INDEX, remoteSites.get(r) + INDEX, "", true) + "</li>\n");
                }
                ++r;
            }
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "</ul>\n");
        } else {
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + WebappResources.getString("noRemoteSitesAvailable", locale) + "</br>\n");
        }
        if (!badSites.isEmpty()) {
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h2>" + WebappResources.getString("sitesWithoutConnectivity", locale) + "</h2>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<ul>\n");
            int b = 0;
            while (b < badSites.size()) {
                pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<li>" + badSites.get(b) + INDEX + "</li>\n");
                ++b;
            }
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "</ul>\n");
        }
        String activeLink = MessageFormat.format(WebappResources.getString("remotePreferences", locale), this.getActiveLink(locale));
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + activeLink);
        pageBuffer.append(END_BODY_HTML);
        ByteArrayInputStream bais = new ByteArrayInputStream(pageBuffer.toString().getBytes());
        return bais;
    }

    private String getHtmlHead(Locale locale) {
        return String.valueOf(BEGIN_HEAD_HTML) + '\n' + StatusProducer.tab(2) + "<meta name=\"copyright\" content=\"Copyright (c) IBM Corporation and others 2000, 2009. This page is made available under license. For full details see the LEGAL in the documentation book that contains this page.\" >\n" + StatusProducer.tab(2) + "<title>" + WebappResources.getString("remoteStatusTitle", locale) + "</title>\n" + StatusProducer.tab(2) + "<link rel=\"stylesheet\" href=\"PLUGINS_ROOT/org.eclipse.help.base/doc/book.css\" charset=\"utf-8\" type=\"text/css\">\n" + StatusProducer.tab(2) + "<script language=\"JavaScript\" src=\"PLUGINS_ROOT/org.eclipse.help/livehelp.js\"> </script>\n" + StatusProducer.tab(2) + "<script type=\"text/javascript\" src=\"../../../content/org.eclipse.help/livehelp.js\"></script>\n" + END_HEAD_HTML;
    }

    private String getBeginHtmlBody() {
        String body = StatusProducer.tab(1);
        body = ProductPreferences.isRTL() ? String.valueOf(body) + "<body dir=\"rtl\">" : String.valueOf(body) + "<body>";
        return String.valueOf(body) + '\n' + StatusProducer.tab(2) + "<div id=\"banner\"><img src=\"PLUGINS_ROOT/org.eclipse.help.base/doc/help_banner.jpg\" alt=\"Help banner\" width=\"1600\" height=\"36\"></div>\n" + StatusProducer.tab(2) + "<div id=\"content\">\n";
    }

    private String getActiveLink(Locale locale) {
        return "<img src=\"PLUGINS_ROOT/org.eclipse.help/command_link.png\"/><a class=\"command-link\" href='javascript:executeCommand(\"org.eclipse.ui.window.preferences(preferencePageId=org.eclipse.help.ui.contentPreferencePage)\")'>" + WebappResources.getString("remotePreferencesMenuSelect", locale) + "</a>";
    }

    private String makeAnchor(String url, String title, String style, boolean newWindow) {
        String target = "";
        if (newWindow) {
            target = "target=\"_blank\" ";
        }
        return "<a " + style + " " + target + "href=\"" + url + "\">" + title + "</a>";
    }

    private static String tab(int count) {
        String tabs = "";
        int i = 0;
        while (i < count) {
            tabs = String.valueOf(tabs) + TAB;
            ++i;
        }
        return tabs;
    }
}

