/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.breakpoints;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AbstractJavaBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugContentAssistProcessor;
import org.eclipse.jdt.internal.debug.ui.contentassist.TypeContext;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public final class JavaBreakpointConditionEditor
extends AbstractJavaBreakpointEditor {
    private Button fConditional;
    private Button fWhenTrue;
    private Button fWhenChange;
    private JDISourceViewer fViewer;
    private IContentAssistProcessor fCompletionProcessor;
    private IJavaLineBreakpoint fBreakpoint;
    private IHandlerService fHandlerService;
    private IHandler fHandler;
    private IHandlerActivation fActivation;
    private IDocumentListener fDocumentListener;
    public static final int PROP_CONDITION = 4097;
    public static final int PROP_CONDITION_ENABLED = 4098;
    public static final int PROP_CONDITION_SUSPEND_POLICY = 4099;
    static /* synthetic */ Class class$0;

    public void addPropertyListener(IPropertyListener listener) {
        super.addPropertyListener(listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        super.removePropertyListener(listener);
    }

    public void setInput(Object input) throws CoreException {
        try {
            this.suppressPropertyChanges(true);
            if (input instanceof IJavaLineBreakpoint) {
                this.setBreakpoint((IJavaLineBreakpoint)input);
            } else {
                this.setBreakpoint(null);
            }
        }
        finally {
            this.suppressPropertyChanges(false);
        }
    }

    private void setBreakpoint(IJavaLineBreakpoint breakpoint) throws CoreException {
        this.fBreakpoint = breakpoint;
        if (this.fDocumentListener != null) {
            this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
            this.fDocumentListener = null;
        }
        this.fViewer.unconfigure();
        Document document = new Document();
        JDIDebugUIPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.fViewer.setInput(document);
        String condition = null;
        IType type = null;
        boolean controlsEnabled = false;
        boolean conditionEnabled = false;
        boolean whenTrue = true;
        if (breakpoint != null) {
            controlsEnabled = true;
            if (breakpoint.supportsCondition()) {
                condition = breakpoint.getCondition();
                conditionEnabled = breakpoint.isConditionEnabled();
                whenTrue = breakpoint.isConditionSuspendOnTrue();
                type = BreakpointUtils.getType((IJavaBreakpoint)breakpoint);
            }
        }
        TypeContext context = null;
        if (type == null || breakpoint == null) {
            context = new TypeContext(null, -1);
        } else {
            String source = null;
            ICompilationUnit compilationUnit = type.getCompilationUnit();
            if (compilationUnit != null && compilationUnit.getJavaProject().getProject().exists()) {
                source = compilationUnit.getSource();
            } else {
                IClassFile classFile = type.getClassFile();
                if (classFile != null) {
                    source = classFile.getSource();
                }
            }
            int lineNumber = breakpoint.getMarker().getAttribute("lineNumber", -1);
            int position = -1;
            if (source != null && lineNumber != -1) {
                try {
                    position = new Document(source).getLineOffset(lineNumber - 1);
                }
                catch (BadLocationException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            context = new TypeContext(type, position);
        }
        this.fCompletionProcessor = new JavaDebugContentAssistProcessor(context);
        this.fViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration(){

            public IContentAssistProcessor getContentAssistantProcessor() {
                return JavaBreakpointConditionEditor.this.fCompletionProcessor;
            }
        });
        document.set(condition == null ? "" : condition);
        this.fViewer.setUndoManager((IUndoManager)new TextViewerUndoManager(10));
        this.fViewer.getUndoManager().connect((ITextViewer)this.fViewer);
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                JavaBreakpointConditionEditor.this.setDirty(4097);
            }
        };
        this.fViewer.getDocument().addDocumentListener(this.fDocumentListener);
        this.fConditional.setEnabled(controlsEnabled);
        this.fConditional.setSelection(conditionEnabled);
        this.fWhenTrue.setSelection(whenTrue);
        this.fWhenChange.setSelection(!whenTrue);
        this.setEnabled(conditionEnabled && breakpoint != null && breakpoint.supportsCondition(), false);
        this.setDirty(false);
    }

    public Control createControl(Composite parent) {
        Composite controls = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)768, (int)0, (int)0);
        this.fConditional = SWTFactory.createCheckButton((Composite)controls, (String)this.processMnemonics(PropertyPageMessages.JavaBreakpointConditionEditor_0), null, (boolean)false, (int)1);
        this.fConditional.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fConditional.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean checked = JavaBreakpointConditionEditor.this.fConditional.getSelection();
                JavaBreakpointConditionEditor.this.setEnabled(checked, true);
                JavaBreakpointConditionEditor.this.setDirty(4098);
            }
        });
        Composite radios = SWTFactory.createComposite((Composite)controls, (Font)controls.getFont(), (int)2, (int)1, (int)768, (int)0, (int)0);
        this.fWhenTrue = SWTFactory.createRadioButton((Composite)radios, (String)this.processMnemonics(PropertyPageMessages.JavaBreakpointConditionEditor_1));
        this.fWhenTrue.setLayoutData((Object)new GridData());
        this.fWhenChange = SWTFactory.createRadioButton((Composite)radios, (String)this.processMnemonics(PropertyPageMessages.JavaBreakpointConditionEditor_2));
        this.fWhenChange.setLayoutData((Object)new GridData());
        this.fWhenTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaBreakpointConditionEditor.this.setDirty(4099);
            }
        });
        this.fWhenChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaBreakpointConditionEditor.this.setDirty(4099);
            }
        });
        this.fViewer = new JDISourceViewer(parent, null, 0x2000B00);
        this.fViewer.setEditable(false);
        ControlDecoration decoration = new ControlDecoration(this.fViewer.getControl(), 16512);
        decoration.setShowOnlyOnFocus(true);
        FieldDecoration dec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        decoration.setImage(dec.getImage());
        decoration.setDescriptionText(dec.getDescription());
        GridData gd = new GridData(4, 4, true, true);
        GC gc = new GC((Drawable)this.fViewer.getTextWidget());
        gc.setFont(this.fViewer.getTextWidget().getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gd.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)40);
        gc.dispose();
        this.fViewer.getControl().setLayoutData((Object)gd);
        this.fHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                JavaBreakpointConditionEditor.this.fViewer.doOperation(13);
                return null;
            }
        };
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fHandlerService = (IHandlerService)iWorkbench.getAdapter((Class)clazz);
        this.fViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JavaBreakpointConditionEditor.this.activateContentAssist();
            }

            public void focusLost(FocusEvent e) {
                JavaBreakpointConditionEditor.this.deactivateContentAssist();
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JavaBreakpointConditionEditor.this.dispose();
            }
        });
        return parent;
    }

    protected void dispose() {
        super.dispose();
        this.deactivateContentAssist();
        if (this.fDocumentListener != null) {
            this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
        }
        this.fViewer.dispose();
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void doSave() throws CoreException {
        if (this.fBreakpoint != null && this.isDirty()) {
            this.fBreakpoint.setCondition(this.fViewer.getDocument().get().trim());
            this.fBreakpoint.setConditionEnabled(this.fConditional.getSelection());
            this.fBreakpoint.setConditionSuspendOnTrue(this.fWhenTrue.getSelection());
            this.setDirty(false);
        }
    }

    public IStatus getStatus() {
        if (this.fBreakpoint != null && this.fBreakpoint.supportsCondition() && this.fConditional.getSelection() && this.fViewer.getDocument().get().trim().length() == 0) {
            return new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), PropertyPageMessages.BreakpointConditionEditor_1);
        }
        return Status.OK_STATUS;
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public void setMnemonics(boolean mnemonics) {
        super.setMnemonics(mnemonics);
    }

    private void activateContentAssist() {
        this.fActivation = this.fHandlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", this.fHandler);
    }

    private void deactivateContentAssist() {
        if (this.fActivation != null) {
            this.fHandlerService.deactivateHandler(this.fActivation);
            this.fActivation = null;
        }
    }

    private void setEnabled(boolean enabled, boolean focus) {
        this.fViewer.setEditable(enabled);
        this.fViewer.getTextWidget().setEnabled(enabled);
        this.fWhenChange.setEnabled(enabled);
        this.fWhenTrue.setEnabled(enabled);
        if (enabled) {
            this.fViewer.updateViewerColors();
            if (focus) {
                this.setFocus();
            }
        } else {
            Color color = this.fViewer.getControl().getDisplay().getSystemColor(22);
            this.fViewer.getTextWidget().setBackground(color);
        }
    }

    public Object getInput() {
        return this.fBreakpoint;
    }
}

