/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.importexport.breakpoints;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.importexport.breakpoints.EmbeddedBreakpointsViewer;
import org.eclipse.debug.internal.ui.importexport.breakpoints.ImportExportMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.ExportBreakpointsOperation;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class WizardExportBreakpointsPage
extends WizardPage
implements Listener {
    private Button fOverwriteExistingFilesCheckbox = null;
    private Text fDestinationNameField = null;
    private Button fDestinationBrowseButton = null;
    private IPath fPath = null;
    private EmbeddedBreakpointsViewer fTView = null;
    private IStructuredSelection fSelection = null;
    private Button fSelectAll = null;
    private Button fDeselectAll = null;
    private static final String OVERWRITE_ALL_STATE = "overwrite";
    private static final String DESTINATION_FILE_NAME = "filename";

    public WizardExportBreakpointsPage(String pageName, IStructuredSelection selection) {
        super(pageName, ImportExportMessages.WizardExportBreakpoints_0, null);
        this.fSelection = selection;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.fDestinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        } else if (source == this.fDestinationNameField) {
            this.handlePathTextModifiedEvent();
        } else if (source == this.fSelectAll) {
            this.handleSelectAllPressed();
        } else if (source == this.fDeselectAll) {
            this.handleDeselectAllPressed();
        }
    }

    private void handleSelectAllPressed() {
        BreakpointsViewer viewer = this.fTView.getViewer();
        viewer.getTree().selectAll();
        viewer.setCheckedElements(((IStructuredSelection)viewer.getSelection()).toArray());
        viewer.setGrayedElements(new Object[0]);
        viewer.getTree().deselectAll();
        this.setPageComplete(this.detectPageComplete());
    }

    private void handleDeselectAllPressed() {
        BreakpointsViewer viewer = this.fTView.getViewer();
        viewer.setCheckedElements(new Object[0]);
        viewer.setGrayedElements(new Object[0]);
        this.setPageComplete(this.detectPageComplete());
    }

    protected void handlePathTextModifiedEvent() {
        this.setPageComplete(this.detectPageComplete());
    }

    protected void handleDestinationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.bkpt"});
        dialog.setText(ImportExportMessages.WizardExportBreakpoints_0);
        String file = dialog.open();
        if (file != null) {
            this.fPath = new Path(file);
            if (this.fPath != null) {
                this.setErrorMessage(null);
                if (this.fPath.getFileExtension() == null) {
                    this.fPath = this.fPath.addFileExtension("bkpt");
                } else if (!this.fPath.getFileExtension().equals("bkpt")) {
                    this.fPath = this.fPath.addFileExtension("bkpt");
                }
                this.fDestinationNameField.setText(this.fPath.toString());
            }
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1808);
        SWTFactory.createLabel(composite, ImportExportMessages.WizardExportBreakpointsPage_2, 1);
        this.fTView = new EmbeddedBreakpointsViewer(composite, DebugPlugin.getDefault().getBreakpointManager(), this.fSelection);
        this.fTView.getViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WizardExportBreakpointsPage.this.setPageComplete(WizardExportBreakpointsPage.this.detectPageComplete());
            }
        });
        this.fTView.getViewer().setSelection((ISelection)this.fSelection);
        this.fTView.getViewer().getTree().getHorizontalBar().setSelection(0);
        this.createButtonsGroup(composite);
        this.createDestinationGroup(composite);
        this.fOverwriteExistingFilesCheckbox = SWTFactory.createCheckButton(composite, ImportExportMessages.WizardBreakpointsPage_6, null, false, 1);
        this.setControl((Control)composite);
        this.setPageComplete(false);
        this.setMessage(ImportExportMessages.WizardBreakpointsPage_4);
        this.restoreWidgetState();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.debug.ui.export_breakpoints_wizard_page_context");
        Dialog.applyDialogFont((Control)parent);
    }

    public Image getImage() {
        return DebugUITools.getImage("IMG_WIZBAN_EXPORT_BREAKPOINTS");
    }

    private void createButtonsGroup(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 3, 1, 768, 0, 0);
        this.fSelectAll = SWTFactory.createPushButton(composite, ImportExportMessages.WizardBreakpointsPage_1, null);
        this.fSelectAll.addListener(13, (Listener)this);
        this.fDeselectAll = SWTFactory.createPushButton(composite, ImportExportMessages.WizardBreakpointsPage_2, null);
        this.fDeselectAll.addListener(13, (Listener)this);
    }

    private boolean detectPageComplete() {
        String filepath = this.fDestinationNameField.getText().trim();
        if (filepath.equals("")) {
            this.setErrorMessage(ImportExportMessages.WizardExportBreakpointsPage_0);
            return false;
        }
        Path path = new Path(filepath);
        if (!path.removeLastSegments(1).toFile().exists()) {
            this.setErrorMessage(ImportExportMessages.WizardExportBreakpointsPage_3);
            return false;
        }
        int size = this.fTView.getCheckedElements().size();
        if (size == 0) {
            this.setErrorMessage(ImportExportMessages.WizardExportBreakpointsPage_1);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(ImportExportMessages.WizardBreakpointsPage_4);
        return true;
    }

    protected void createDestinationGroup(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, parent.getFont(), 3, 1, 768, 0, 10);
        SWTFactory.createLabel(comp, ImportExportMessages.WizardBreakpointsPage_7, 1);
        this.fDestinationNameField = SWTFactory.createText(comp, 2052, 1, 768);
        this.fDestinationNameField.addListener(24, (Listener)this);
        this.fDestinationBrowseButton = SWTFactory.createPushButton(comp, ImportExportMessages.WizardBreakpointsPage_8, null);
        this.fDestinationBrowseButton.addListener(13, (Listener)this);
    }

    private void saveWidgetState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(OVERWRITE_ALL_STATE, this.fOverwriteExistingFilesCheckbox.getSelection());
            settings.put(DESTINATION_FILE_NAME, this.fDestinationNameField.getText().trim());
        }
    }

    private void restoreWidgetState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fOverwriteExistingFilesCheckbox.setSelection(Boolean.valueOf(settings.get(OVERWRITE_ALL_STATE)).booleanValue());
            String filename = settings.get(DESTINATION_FILE_NAME);
            if (filename != null) {
                this.fDestinationNameField.setText(filename);
            }
        }
    }

    public boolean finish() {
        block10: {
            if (this.fPath == null) {
                this.fPath = new Path(this.fDestinationNameField.getText().trim());
                if (this.fPath.getFileExtension() == null) {
                    this.fPath = this.fPath.addFileExtension("bkpt");
                } else if (!this.fPath.getFileExtension().equals("bkpt")) {
                    this.fPath = this.fPath.addFileExtension("bkpt");
                }
            }
            this.saveWidgetState();
            if (!this.fPath.toFile().exists() || this.fOverwriteExistingFilesCheckbox.getSelection() || MessageDialog.openQuestion(null, (String)ImportExportMessages.WizardBreakpointsPage_12, (String)MessageFormat.format((String)ImportExportMessages.ImportExportOperations_0, (Object[])new String[]{this.fPath.toPortableString()}))) break block10;
            return false;
        }
        try {
            Object[] elements = this.fTView.getCheckedElements().toArray();
            ArrayList<Object> breakpoints = new ArrayList<Object>();
            int i = 0;
            while (i < elements.length) {
                Object object = elements[i];
                if (object instanceof IBreakpoint) {
                    breakpoints.add(object);
                }
                ++i;
            }
            this.getContainer().run(false, true, (IRunnableWithProgress)new ExportBreakpointsOperation(breakpoints.toArray(new IBreakpoint[breakpoints.size()]), this.fPath.toOSString()));
        }
        catch (InterruptedException e) {
            DebugPlugin.log((Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            DebugPlugin.log((Throwable)e);
            return false;
        }
        return true;
    }
}

