/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.wizards.cheatsheet;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.CSWizardMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class BaseCSCreationOperation
extends WorkspaceModifyOperation {
    protected IFile fFile;

    public BaseCSCreationOperation(IFile file) {
        this.fFile = file;
    }

    public BaseCSCreationOperation(ISchedulingRule rule) {
        super(rule);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask(CSWizardMessages.BaseCSCreationOperation_task, 2);
        this.createContent();
        monitor.worked(1);
        this.openFile();
        monitor.done();
    }

    protected abstract void createContent() throws CoreException;

    private void openFile() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PDEUserAssistanceUIPlugin.getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null || !BaseCSCreationOperation.this.fFile.exists()) {
                    return;
                }
                IWorkbenchPart focusPart = page.getActivePart();
                if (focusPart instanceof ISetSelectionTarget) {
                    StructuredSelection selection = new StructuredSelection((Object)BaseCSCreationOperation.this.fFile);
                    ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                }
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)BaseCSCreationOperation.this.fFile);
                }
                catch (PartInitException partInitException) {}
            }
        });
    }

    public static String formatTextBold(String text) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<b>");
        buffer.append(text);
        buffer.append("</b>");
        return buffer.toString();
    }
}

