/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.XMLAssociationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMDocumentLoader {
    protected Document document;
    protected ModelQuery modelQuery;
    protected CMDocumentManager cmDocumentManager;
    protected boolean isInferredGrammarEnabled = true;
    protected CMDocumentLoadingNamespaceTable namespaceTable;
    protected int count = 0;

    public CMDocumentLoader(Document document, ModelQuery modelQuery) {
        this(document, modelQuery.getCMDocumentManager());
    }

    public CMDocumentLoader(Document document, CMDocumentManager cmDocumentManager) {
        this.document = document;
        this.cmDocumentManager = cmDocumentManager;
    }

    public void loadCMDocuments() {
        boolean walkDocument = false;
        this.cmDocumentManager.removeAllReferences();
        String[] doctypeInfo = XMLAssociationProvider.getDoctypeInfo(this.document);
        if (doctypeInfo != null) {
            walkDocument = this.handleGrammar(doctypeInfo[0], doctypeInfo[1], "DTD");
        } else {
            Element element = this.getRootElement(this.document);
            if (element != null) {
                this.namespaceTable = new CMDocumentLoadingNamespaceTable(this.document);
                this.namespaceTable.addElement(element);
                if (this.namespaceTable.isNamespaceEncountered()) {
                    walkDocument = true;
                } else {
                    this.namespaceTable = null;
                    walkDocument = this.isInferredGrammarEnabled;
                }
            }
        }
        if (walkDocument) {
            this.visitNode(this.document);
        }
    }

    public boolean handleGrammar(String publicId, String systemId, String type) {
        boolean result = false;
        int status = this.cmDocumentManager.getCMDocumentStatus(publicId);
        if (status == 0) {
            this.cmDocumentManager.addCMDocumentReference(publicId, systemId, type);
        } else if (status == 4) {
            result = true;
        }
        return result;
    }

    public void handleElement(Element element) {
        this.visitChildNodes(element);
    }

    public void handleElementNS(Element element) {
        this.namespaceTable.addElement(element);
        this.visitChildNodes(element);
    }

    public void visitNode(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 1) {
            ++this.count;
            Element element = (Element)node;
            if (this.namespaceTable == null) {
                this.handleElement(element);
            } else {
                this.handleElementNS(element);
            }
        } else if (nodeType == 9) {
            this.visitChildNodes(node);
        }
    }

    protected void visitChildNodes(Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            this.visitNode(child);
            child = child.getNextSibling();
        }
    }

    protected Element getRootElement(Document document) {
        Element result = null;
        NodeList nodeList = document.getChildNodes();
        int nodeListLength = nodeList.getLength();
        int i = 0;
        while (i < nodeListLength) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                result = (Element)node;
                break;
            }
            ++i;
        }
        return result;
    }

    protected class CMDocumentLoadingNamespaceTable
    extends NamespaceTable {
        protected List newNamespaceList;

        public CMDocumentLoadingNamespaceTable(Document document) {
            super(document);
        }

        public void addElement(Element element) {
            this.newNamespaceList = null;
            super.addElement(element);
            if (this.newNamespaceList != null) {
                Iterator i = this.newNamespaceList.iterator();
                while (i.hasNext()) {
                    NamespaceInfo info = (NamespaceInfo)i.next();
                    CMDocumentLoader.this.handleGrammar(info.uri, info.locationHint, "XSD");
                }
            }
        }

        protected void internalAddNamespaceInfo(String key, NamespaceInfo info) {
            super.internalAddNamespaceInfo(key, info);
            if (this.newNamespaceList == null) {
                this.newNamespaceList = new ArrayList();
            }
            this.newNamespaceList.add(info);
        }
    }
}

