/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.List;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.services.ActiveContextsFunction;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.ActiveChildLookupFunction;
import org.eclipse.e4.ui.internal.workbench.ActivePartLookupFunction;
import org.eclipse.e4.ui.internal.workbench.E4CommandProcessor;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.internal.workbench.WorkbenchLogger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MBindingTableContainer;
import org.eclipse.e4.ui.model.application.commands.MBindings;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MHandlerContainer;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IExceptionHandler;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.emf.common.notify.Notifier;
import org.osgi.framework.BundleContext;
import org.w3c.dom.css.CSSStyleDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class E4Workbench
implements IWorkbench {
    public static final String LOCAL_ACTIVE_SHELL = "localActiveShell";
    public static final String XMI_URI_ARG = "applicationXMI";
    public static final String CSS_URI_ARG = "applicationCSS";
    public static final String CSS_RESOURCE_URI_ARG = "applicationCSSResources";
    public static final String PRESENTATION_URI_ARG = "presentationURI";
    public static final String LIFE_CYCLE_URI_ARG = "lifeCycleURI";
    public static final String SAVE_AND_RESTORE = "saveAndRestore";
    public static final String INITIAL_WORKBENCH_MODEL_URI = "initialWorkbenchModelURI";
    public static final String INSTANCE_LOCATION = "instanceLocation";
    public static final String MODEL_RESOURCE_HANDLER = "modelResourceHandler";
    public static final String RENDERER_FACTORY_URI = "rendererFactoryUri";
    IEclipseContext appContext;
    IPresentationEngine renderer;
    MApplication appModel = null;

    public IEclipseContext getContext() {
        return this.appContext;
    }

    public E4Workbench(MApplicationElement uiRoot, IEclipseContext applicationContext) {
        this.appContext = applicationContext;
        this.appContext.set(IWorkbench.class.getName(), (Object)this);
        if (uiRoot instanceof MApplication) {
            this.appModel = (MApplication)uiRoot;
        }
        if (uiRoot instanceof MApplication) {
            this.init((MApplication)uiRoot);
        }
        ((Notifier)uiRoot).eAdapters().add((Object)new UIEventPublisher(this.appContext));
    }

    public void createAndRunUI(MApplicationElement uiRoot) {
        this.renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        if (this.renderer == null) {
            String presentationURI = (String)this.appContext.get(PRESENTATION_URI_ARG);
            if (presentationURI != null) {
                IContributionFactory factory = (IContributionFactory)this.appContext.get(IContributionFactory.class.getName());
                this.renderer = (IPresentationEngine)factory.create(presentationURI, this.appContext);
                this.appContext.set(IPresentationEngine.class.getName(), (Object)this.renderer);
            }
            if (this.renderer == null) {
                Logger logger = (Logger)this.appContext.get(Logger.class.getName());
                logger.error("Failed to create the presentation engine for URI: " + presentationURI);
            }
        }
        if (this.renderer != null) {
            this.renderer.run(uiRoot, this.appContext);
        }
    }

    private void init(MApplication appElement) {
        Activator.trace("/trace/workbench", "init() workbench", null);
        E4CommandProcessor.processCommands(appElement.getContext(), appElement.getCommands());
        E4CommandProcessor.processBindings(appElement.getContext(), (MBindingTableContainer)appElement);
        E4Workbench.processHierarchy(appElement);
    }

    @Override
    public boolean close() {
        if (this.renderer != null) {
            this.renderer.stop();
        }
        return true;
    }

    @Override
    public int run() {
        return 0;
    }

    public static IEclipseContext getServiceContext() {
        return EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getContext());
    }

    public MApplication getApplication() {
        return this.appModel;
    }

    public static IEclipseContext createWorkbenchContext(IEclipseContext applicationContext, IExtensionRegistry registry, IExceptionHandler exceptionHandler, IContributionFactory contributionFactory) {
        Activator.trace("/trace/eclipse.context", "createWorkbenchContext: initialize the workbench context with needed services", null);
        final IEclipseContext mainContext = applicationContext.createChild("WorkbenchContext");
        mainContext.set(Logger.class.getName(), ContextInjectionFactory.make(WorkbenchLogger.class, (IEclipseContext)mainContext));
        if (contributionFactory != null) {
            mainContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        }
        mainContext.set(ContextManager.class.getName(), (Object)new ContextManager());
        mainContext.set("activeContexts", (Object)new ActiveContextsFunction());
        mainContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        mainContext.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                Object o = mainContext.get("e4ActivePart");
                if (o instanceof MPart) {
                    mainContext.set("activePartId", (Object)((MPart)o).getElementId());
                }
                return true;
            }

            public String toString() {
                return "activePartId";
            }
        });
        mainContext.set(IExceptionHandler.class.getName(), (Object)exceptionHandler);
        mainContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        mainContext.set("activeShell", (Object)new ActiveChildLookupFunction("activeShell", null));
        E4Workbench.initializeNullStyling(mainContext);
        return mainContext;
    }

    public static void processHierarchy(Object me) {
        MHandlerContainer container;
        MContext contextModel;
        if (me instanceof MHandlerContainer) {
            contextModel = (MContext)me;
            container = (MHandlerContainer)contextModel;
            IEclipseContext context = contextModel.getContext();
            if (context != null) {
                IContributionFactory cf = (IContributionFactory)context.get(IContributionFactory.class.getName());
                EHandlerService hs = (EHandlerService)context.get(EHandlerService.class.getName());
                List handlers = container.getHandlers();
                for (MHandler handler : handlers) {
                    String commandId = handler.getCommand().getElementId();
                    if (handler.getObject() == null) {
                        handler.setObject(cf.create(handler.getContributionURI(), context));
                    }
                    hs.activateHandler(commandId, handler.getObject());
                }
            }
        }
        if (me instanceof MBindings) {
            contextModel = (MContext)me;
            container = (MBindings)me;
            List bindingContexts = container.getBindingContexts();
            IEclipseContext context = contextModel.getContext();
            if (context != null && !bindingContexts.isEmpty()) {
                EContextService cs = (EContextService)context.get(EContextService.class.getName());
                for (String id : bindingContexts) {
                    cs.activateContext(id);
                }
            }
        }
        if (me instanceof MElementContainer) {
            List children = ((MElementContainer)me).getChildren();
            for (MUIElement e : children) {
                E4Workbench.processHierarchy(e);
            }
        }
    }

    public static IEclipseContext initializeContext(IEclipseContext parentContext, MContext contextModel) {
        IEclipseContext context = contextModel.getContext() != null ? contextModel.getContext() : parentContext.createChild("PartContext(" + contextModel + ')');
        Activator.trace("/trace/eclipse.context", "initializeContext(" + parentContext.toString() + ", " + contextModel + ")", null);
        E4Workbench.populateModelInterfaces(contextModel, context, contextModel.getClass().getInterfaces());
        List containedProperties = contextModel.getVariables();
        for (String name : containedProperties) {
            context.declareModifiable(name);
        }
        contextModel.setContext(context);
        return context;
    }

    private static void populateModelInterfaces(MContext contextModel, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace("/trace/eclipse.context", "Adding " + intf.getName() + " for " + contextModel.getClass().getName(), null);
            context.set(intf.getName(), (Object)contextModel);
            E4Workbench.populateModelInterfaces(contextModel, context, intf.getInterfaces());
            ++n2;
        }
    }

    private static void initializeNullStyling(IEclipseContext appContext) {
        appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

            public void setClassname(Object widget, String classname) {
            }

            public void setId(Object widget, String id) {
            }

            public void style(Object widget) {
            }

            public CSSStyleDeclaration getStyle(Object widget) {
                return null;
            }
        });
    }
}

