/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.stringconverter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.e4.tm.stringconverter.StringConverter;
import org.eclipse.e4.tm.stringconverter.StringConverterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStringConverter
implements StringConverter {
    protected boolean trim = false;
    private Pattern pattern;
    private Matcher matcher;
    protected StringConverterContext context = null;

    protected void throwConversionException(String source, Class<?> klass, Exception e) throws RuntimeException {
        throw new RuntimeException("Exception when converting " + source + " to " + klass + ": " + e, e);
    }

    protected String getRegex() {
        return null;
    }

    protected Matcher getMatcher() {
        return this.matcher;
    }

    protected String getSubstring(int i) {
        return this.matcher != null ? this.matcher.group(i) : null;
    }

    protected Object getObject(int i, Class<?> klass, StringConverterContext context) throws Exception {
        String s = this.getSubstring(i);
        return s != null ? context.convert(s, klass) : null;
    }

    protected boolean matches(String source) {
        if (this.getRegex() != null) {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.getRegex(), 32);
            }
            this.matcher = this.pattern.matcher(source);
            if (this.matcher.matches()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public <T> T convert(String source, Class<T> klass, StringConverterContext context) throws Exception {
        if (this.trim) {
            source = source.trim();
        }
        this.context = context;
        try {
            Object object = this.convert(source, context);
            return (T)object;
        }
        finally {
            this.context = null;
        }
    }

    public Object convert(String source, StringConverterContext context) throws Exception {
        return this.convert(source);
    }

    public Object convert(String source) throws Exception {
        return null;
    }

    protected <T> T convertThrowing(String source, Class<T> klass, StringConverterContext context) {
        T result = null;
        try {
            result = context.convert(source, klass);
        }
        catch (Exception e) {
            this.throwConversionException(source, klass, e);
        }
        return result;
    }
}

