/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class RefactoringDescriptor
implements Comparable {
    public static final int BREAKING_CHANGE = 1;
    public static final String ID_UNKNOWN = "org.eclipse.ltk.core.refactoring.unknown";
    public static final int MULTI_CHANGE = 4;
    public static final int NONE = 0;
    public static final int STRUCTURAL_CHANGE = 2;
    public static final int USER_CHANGE = 256;
    private String fComment;
    private String fDescription;
    private int fFlags;
    private String fProject;
    private final String fRefactoringId;
    private long fTimeStamp = -1L;

    protected RefactoringDescriptor(String id, String project, String description, String comment, int flags) {
        Assert.isNotNull((Object)id);
        Assert.isLegal((!"".equals(id) ? 1 : 0) != 0, (String)"Refactoring id must not be empty");
        Assert.isLegal((project == null || !"".equals(project) ? 1 : 0) != 0, (String)"Project must either be null or non-empty");
        Assert.isNotNull((Object)description);
        Assert.isLegal((!"".equals(description) ? 1 : 0) != 0, (String)"Description must not be empty");
        Assert.isLegal((flags >= 0 ? 1 : 0) != 0, (String)"Flags must be non-negative");
        this.fRefactoringId = id;
        this.fDescription = description;
        this.fProject = project;
        this.fComment = comment;
        this.fFlags = flags;
    }

    public final int compareTo(Object object) {
        if (object instanceof RefactoringDescriptor) {
            RefactoringDescriptor descriptor = (RefactoringDescriptor)object;
            long delta = this.fTimeStamp - descriptor.fTimeStamp;
            if (delta < 0L) {
                return -1;
            }
            if (delta > 0L) {
                return 1;
            }
        }
        return 0;
    }

    public abstract Refactoring createRefactoring(RefactoringStatus var1) throws CoreException;

    public final boolean equals(Object object) {
        if (object instanceof RefactoringDescriptor) {
            RefactoringDescriptor descriptor = (RefactoringDescriptor)object;
            return this.fTimeStamp == descriptor.fTimeStamp && this.getDescription().equals(descriptor.getDescription());
        }
        return false;
    }

    public final String getComment() {
        return this.fComment != null ? this.fComment : "";
    }

    public final String getDescription() {
        return this.fDescription;
    }

    public final int getFlags() {
        return this.fFlags;
    }

    public final String getID() {
        return this.fRefactoringId;
    }

    public final String getProject() {
        return this.fProject;
    }

    public final long getTimeStamp() {
        return this.fTimeStamp;
    }

    public final int hashCode() {
        int code = this.getDescription().hashCode();
        if (this.fTimeStamp >= 0L) {
            code = (int)((long)code + 17L * this.fTimeStamp);
        }
        return code;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    public void setDescription(String description) {
        Assert.isNotNull((Object)description);
        Assert.isLegal((!"".equals(description) ? 1 : 0) != 0, (String)"Description must not be empty");
        this.fDescription = description;
    }

    public void setFlags(int flags) {
        Assert.isLegal((flags >= 0 ? 1 : 0) != 0, (String)"Flags must be non-negative");
        this.fFlags = flags;
    }

    public void setProject(String project) {
        Assert.isLegal((project == null || !"".equals(project) ? 1 : 0) != 0, (String)"Project must either be null or non-empty");
        this.fProject = project;
    }

    public void setTimeStamp(long stamp) {
        Assert.isTrue((stamp >= 0L ? 1 : 0) != 0);
        this.fTimeStamp = stamp;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(this.getClass().getName());
        if (this.fRefactoringId.equals(ID_UNKNOWN)) {
            buffer.append("[unknown refactoring]");
        } else {
            buffer.append("[timeStamp=");
            buffer.append(this.fTimeStamp);
            buffer.append(",id=");
            buffer.append(this.fRefactoringId);
            buffer.append(",description=");
            buffer.append(this.fDescription);
            buffer.append(",project=");
            buffer.append(this.fProject);
            buffer.append(",comment=");
            buffer.append(this.fComment);
            buffer.append(",flags=");
            buffer.append(this.fFlags);
            buffer.append("]");
        }
        return buffer.toString();
    }
}

