/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.exporter.util;

import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ExporterUIUtil {

    public static abstract class CompositeEditorHelper
    implements Listener {
        protected Composite composite;
        protected ControlEditor compositeEditor;

        protected CompositeEditorHelper(Composite composite) {
            this.composite = composite;
            composite.addListener(13, (Listener)this);
            composite.addListener(14, (Listener)this);
            composite.addListener(12, (Listener)this);
            this.compositeEditor = this.createControlEditor(composite);
            this.compositeEditor.horizontalAlignment = 16384;
            this.compositeEditor.grabHorizontal = true;
        }

        protected ControlEditor createControlEditor(Composite composite) {
            return new ControlEditor(composite);
        }

        public void handleEvent(Event event) {
            if (event.widget == this.composite) {
                switch (event.type) {
                    case 13: 
                    case 14: {
                        this.compositeSelected(event);
                        break;
                    }
                    case 12: {
                        this.compositeDisposed();
                    }
                }
            }
        }

        protected void compositeSelected(Event event) {
            this.disposeOldEditorControl(this.compositeEditor.getEditor());
            Widget item = event.item;
            Control editorControl = this.createEditorControl(item);
            if (editorControl != null) {
                this.setEditor(editorControl, item);
            }
        }

        protected void compositeDisposed() {
            this.composite.removeListener(13, (Listener)this);
            this.composite.removeListener(14, (Listener)this);
            this.composite.removeListener(12, (Listener)this);
            this.composite = null;
        }

        protected void disposeOldEditorControl(Control control) {
            if (control != null && !control.isDisposed()) {
                control.removeListener(13, (Listener)this);
                control.dispose();
            }
        }

        protected void setEditor(Control editorControl, Widget item) {
            this.compositeEditor.setEditor(editorControl);
        }

        protected abstract Control createEditorControl(Widget var1);
    }

    public static abstract class TreeEditorHelper
    extends CompositeEditorHelper {
        public TreeEditorHelper(Tree tree) {
            super((Composite)tree);
        }

        protected ControlEditor createControlEditor(Composite composite) {
            return new TreeEditor((Tree)composite);
        }

        public void setColumn(int index) {
            TreeColumn treeColumn = ((Tree)this.composite).getColumn(index);
            TreeEditor treeEditor = (TreeEditor)this.compositeEditor;
            treeEditor.minimumWidth = treeColumn.getWidth();
            treeEditor.setColumn(index);
        }

        public int getColumn() {
            return ((TreeEditor)this.compositeEditor).getColumn();
        }

        protected void setEditor(Control editorControl, Widget item) {
            ((TreeEditor)this.compositeEditor).setEditor(editorControl, (TreeItem)item);
        }
    }
}

