/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.importing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.importing.CvsBundleImportDescription;
import org.eclipse.pde.internal.core.importing.provisional.BundleImportDescription;
import org.eclipse.pde.internal.core.importing.provisional.IBundleImporterDelegate;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProviderType;
import org.osgi.framework.BundleException;

public class CvsBundleImporterDelegate
implements IBundleImporterDelegate {
    private static Set SUPPORTED_VALUES;
    private static final String SCM = "scm:";
    private static final String CVS = "cvs";
    private static final String COLON = ":";
    private static final String PIPE = "|";
    private static final String ATTR_TAG = "tag";
    private static final String ATTR_PROJECT = "project";
    private static RepositoryProviderType CVS_PROVIDER_TYPE;

    static {
        CVS_PROVIDER_TYPE = RepositoryProviderType.getProviderType((String)"org.eclipse.team.cvs.core.cvsnature");
        SUPPORTED_VALUES = new HashSet();
        SUPPORTED_VALUES.add("scm:cvs:");
        SUPPORTED_VALUES.add("scm:cvs|");
    }

    public BundleImportDescription[] validateImport(Map[] manifests) {
        BundleImportDescription[] results = new BundleImportDescription[manifests.length];
        if (CVS_PROVIDER_TYPE != null) {
            int i = 0;
            while (i < manifests.length) {
                String prefix;
                Map manifest = manifests[i];
                String value = (String)manifest.get("Eclipse-SourceReferences");
                if (value != null && value.length() > 8 && SUPPORTED_VALUES.contains(prefix = value.substring(0, 8))) {
                    try {
                        ManifestElement[] elements = ManifestElement.parseHeader((String)"Eclipse-SourceReferences", (String)value);
                        int j = 0;
                        while (j < elements.length) {
                            String bsn;
                            ManifestElement element = elements[j];
                            String url = element.getValue();
                            String tag = element.getAttribute(ATTR_TAG);
                            String project = element.getAttribute(ATTR_PROJECT);
                            if (project == null && (bsn = (String)manifests[i].get("Bundle-SymbolicName")) != null) {
                                ManifestElement[] bsnElement = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)bsn);
                                project = bsnElement[0].getValue();
                            }
                            results[i] = this.createImportDescription(url, manifest, tag, project);
                            ++j;
                        }
                    }
                    catch (BundleException e) {
                        PDECore.log(e);
                    }
                }
                ++i;
            }
        }
        return results;
    }

    public IProject[] performImport(BundleImportDescription[] descriptions, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> references = new ArrayList<String>();
        int i = 0;
        while (i < descriptions.length) {
            references.add(this.createPSF((CvsBundleImportDescription)descriptions[i]));
            ++i;
        }
        if (!references.isEmpty()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)references.size());
            ProjectSetCapability psfCapability = CVS_PROVIDER_TYPE.getProjectSetCapability();
            if (psfCapability != null) {
                psfCapability.addToWorkspace(references.toArray(new String[references.size()]), new ProjectSetSerializationContext(), (IProgressMonitor)subMonitor);
            }
            subMonitor.done();
        }
        return null;
    }

    private BundleImportDescription createImportDescription(String url, Map manifest, String tag, String project) {
        String suffix = url.substring(8);
        String sep = url.substring(7, 8);
        String[] pieces = suffix.split(sep);
        String protocol = pieces[0];
        String module = pieces[pieces.length - 1];
        String path = pieces[pieces.length - 2];
        int index = pieces.length - 3;
        String server = null;
        try {
            Integer.parseInt(pieces[index]);
            server = pieces[--index];
        }
        catch (NumberFormatException numberFormatException) {
            server = pieces[index];
        }
        index = server.indexOf(64);
        if (index >= 0) {
            server = server.substring(index + 1);
        }
        if (project == null) {
            int slash = pieces[3].lastIndexOf(47);
            project = slash >= 0 ? pieces[3].substring(slash + 1) : pieces[3];
        }
        return new CvsBundleImportDescription(project, manifest, protocol, server, path, module, tag);
    }

    private String createPSF(CvsBundleImportDescription description) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("1.0,:");
        buffer.append(description.protocol);
        buffer.append(COLON);
        buffer.append(description.server);
        buffer.append(COLON);
        buffer.append(description.path);
        buffer.append(',');
        buffer.append(description.module);
        buffer.append(',');
        buffer.append(description.getProject());
        String tag = description.tag;
        if (tag != null) {
            buffer.append(',');
            buffer.append(tag);
        }
        return buffer.toString();
    }
}

