/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class NewMWindowTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        if (this.appContext instanceof IDisposable) {
            this.appContext.dispose();
        }
    }

    public void testCreateWindow() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setLabel("MyWindow");
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        Widget topWidget = (Widget)window.getWidget();
        NewMWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        NewMWindowTest.assertEquals((String)"MyWindow", (String)((Shell)topWidget).getText());
        NewMWindowTest.assertEquals((Object)topWidget, (Object)this.appContext.get("activeShell"));
    }

    public void testCreateView() {
        MWindow window = this.createWindowWithOneView();
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        Widget topWidget = (Widget)window.getWidget();
        NewMWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        NewMWindowTest.assertEquals((String)"MyWindow", (String)shell.getText());
        Control[] controls = shell.getChildren();
        NewMWindowTest.assertEquals((int)1, (int)controls.length);
        SashForm sash = (SashForm)controls[0];
        Control[] sashChildren = sash.getChildren();
        NewMWindowTest.assertEquals((int)1, (int)sashChildren.length);
        CTabFolder folder = (CTabFolder)sashChildren[0];
        NewMWindowTest.assertEquals((int)1, (int)folder.getItemCount());
        Control c = folder.getItem(0).getControl();
        NewMWindowTest.assertTrue((boolean)(c instanceof Composite));
        Control[] viewPart = ((Composite)c).getChildren();
        NewMWindowTest.assertEquals((int)1, (int)viewPart.length);
        NewMWindowTest.assertTrue((boolean)(viewPart[0] instanceof Tree));
    }

    public void testContextChildren() {
        MWindow window = this.createWindowWithOneView();
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        Widget topWidget = (Widget)window.getWidget();
        NewMWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        NewMWindowTest.assertEquals((String)"MyWindow", (String)shell.getText());
        IEclipseContext child = (IEclipseContext)this.appContext.getLocal("activeChildContext");
        NewMWindowTest.assertNotNull((Object)child);
        NewMWindowTest.assertEquals((Object)window.getContext(), (Object)child);
        MPart modelPart = this.getContributedPart(window);
        NewMWindowTest.assertNotNull((Object)modelPart);
        NewMWindowTest.assertEquals((Object)window, (Object)modelPart.getParent().getParent().getParent());
        AbstractPartRenderer factory = (AbstractPartRenderer)modelPart.getRenderer();
        factory.activate(modelPart);
        IEclipseContext next = (IEclipseContext)child.getLocal("activeChildContext");
        while (next != null) {
            child = next;
            if ((next = (IEclipseContext)child.getLocal("activeChildContext")) != child) continue;
            NewMWindowTest.fail((String)"Cycle detected in part context");
            break;
        }
        NewMWindowTest.assertFalse((window.getContext() == child ? 1 : 0) != 0);
        MPart contextPart = (MPart)child.get(MPart.class.getName());
        NewMWindowTest.assertNotNull((Object)contextPart);
        NewMWindowTest.assertEquals((Object)window, (Object)contextPart.getParent().getParent().getParent());
    }

    public void testCreateMenu() {
        MWindow window = this.createWindowWithOneViewAndMenu();
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        Widget topWidget = (Widget)window.getWidget();
        NewMWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        Menu menuBar = shell.getMenuBar();
        NewMWindowTest.assertNotNull((Object)menuBar);
        NewMWindowTest.assertEquals((int)1, (int)menuBar.getItemCount());
        MenuItem fileItem = menuBar.getItem(0);
        NewMWindowTest.assertEquals((String)"File", (String)fileItem.getText());
        Menu fileMenu = fileItem.getMenu();
        fileMenu.notifyListeners(22, null);
        NewMWindowTest.assertEquals((int)2, (int)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
        MMenu mainMenu = window.getMainMenu();
        MMenu modelFileMenu = (MMenu)mainMenu.getChildren().get(0);
        MMenuItem item2Model = (MMenuItem)modelFileMenu.getChildren().get(0);
        item2Model.setToBeRendered(false);
        fileMenu.notifyListeners(22, null);
        NewMWindowTest.assertEquals((int)1, (int)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
        item2Model.setToBeRendered(true);
        fileMenu.notifyListeners(22, null);
        NewMWindowTest.assertEquals((int)2, (int)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
    }

    private MPart getContributedPart(MWindow window) {
        MPartSashContainer psc = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)psc.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        NewMWindowTest.assertTrue((String)("part is incorrect type " + part), (boolean)(part instanceof MPart));
        return part;
    }

    private MWindow createWindowWithOneView() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(sash);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        sash.getChildren().add(stack);
        MPart contributedPart = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(contributedPart);
        contributedPart.setLabel("Sample View");
        contributedPart.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }

    private MWindow createWindowWithOneViewAndMenu() {
        MWindow window = this.createWindowWithOneView();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setLabel("File");
        fileMenu.setElementId("file");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        return window;
    }
}

