/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

public class ContextInjectionFactoryTest
extends TestCase {
    private TestObject testObject;
    private IEclipseContext context;

    protected void setUp() throws Exception {
        super.setUp();
        this.testObject = new TestObject();
        this.context = EclipseContextFactory.create();
    }

    public void testInvoke() throws Exception {
        ContextInjectionFactory.invoke((Object)this.testObject, Execute.class, (IEclipseContext)this.context, null);
        ContextInjectionFactoryTest.assertEquals((int)1, (int)this.testObject.getExecuted());
        ContextInjectionFactoryTest.assertEquals((int)0, (int)this.testObject.getExecutedWithParams());
    }

    public void testInvokeWithParameters() throws Exception {
        this.context.set(String.class.getName(), (Object)"");
        ContextInjectionFactory.invoke((Object)this.testObject, CanExecute.class, (IEclipseContext)this.context, null);
        ContextInjectionFactoryTest.assertEquals((int)0, (int)this.testObject.getExecuted());
        ContextInjectionFactoryTest.assertEquals((int)1, (int)this.testObject.getExecutedWithParams());
    }

    public void testConstructorInjectionBasic() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(ContextInjectionFactoryTest.class.getName(), (Object)this);
        Object basicResult = ContextInjectionFactory.make(TestConstructorObjectBasic.class, (IEclipseContext)context);
        ContextInjectionFactoryTest.assertNotNull((Object)basicResult);
        ContextInjectionFactoryTest.assertTrue((boolean)(basicResult instanceof TestConstructorObjectBasic));
        ContextInjectionFactoryTest.assertTrue((boolean)((TestConstructorObjectBasic)basicResult).defaultConstructorCalled);
    }

    static class TestConstructorObjectBasic {
        public boolean defaultConstructorCalled = true;
    }

    static class TestObject {
        private int executed = 0;
        private int executedWithParams = 0;

        TestObject() {
        }

        @Execute
        public void execute() {
            ++this.executed;
        }

        @CanExecute
        public void executeWithParams(String string) {
            ++this.executedWithParams;
        }

        public int getExecuted() {
            return this.executed;
        }

        public int getExecutedWithParams() {
            return this.executedWithParams;
        }
    }
}

