/*
	Copyright (c) 2004-2008, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/book/dojo-book-0-9/introduction/licensing
*/


/*=====
// this file is in place as a quick way to give summaries to all available dojox projects.

dojox = {
	// summary: A container for any Dojo Toolkit projects that are cutting-edge or experimental in nature.
	// description: 
	//	DojoX acts as a container for all sorts of on-the-edge ideas; it is also a breeding 
	//	ground for objects to be eventually added to either the Dojo project or to Dijit, and 
	//	finally can act as a place for basic extension utilities that are not commonly used in
	//	day-to-day web pages but are essential for application development.
}

dojox.charting = { 
	// summary: Vector Data Driven graphs and charts 
};

dojox.collections = { 
	// summary: A set of lists and hashes for easy use within your applications.
};

dojox.color = { 
	// summary: Advanced color methods, including HSV, HSL, and CMYK conversion, a color generator and advanced colorspace calculations.
};

dojox.cometd = { 
	// summary: A cometd client written in Dojo
};

dojox.crypto = { 
	// summary: Cryptography in JS.  DEPRECATED: use dojox.encoding instead.
};	

dojox.data = { 
	// summary: Additional dojo.data data stores and demos
};

dojox.date = { 	
	// summary: Additional date manipulation functions
};

dojox.dtl = { 
	// summary: Django Templating Language implementation	
};

dojox.encoding = { 
	// summary: Various encoding algorithms, including crypto and digests.
};

dojox.flash = { 
	// summary: Objects to support the Flash-based storage provider (dojox.storage).
};

dojox.fx = {
	// summary: Extension animations to the core dojo FX project
	//
	// description:
	//	A package of animations, and FX-related code, extending Dojo Core fx.
	//	Including this package includes all the Base and Core fx packages.
	//
	
	style: { // summary: Module to provide CSS animations
	},

	scroll: { // summary: Module to provide scroll-related FX 
	}
};
dojox.fx["ext-dojo"] = {
	// summary: Direct extensions to dojo.fx namespace
	NodeList: {
		// summary: module to include to support dojox.fx animations in dojo.query()
	}
};

dojox.gfx = { 
	// summary: Cross-browser vector drawing API
	// description: 
	//
	//	dojox.gfx is an advanced API providing normalized vector drawing
	//	in a variety of browsers. It has individual renderers for SVG, VML,
	//	Canvas, and Silverlight.
	//
};

dojox.gfx3d = { 
	// summary: A 3d API for dojox.gfx
};

dojox.grid = { 
	// summary: An advanced Grid project
};	

dojox.highlight = { 
	// summary: A client-side syntax highlighting engine.
	// description:
	//	This project parses pre > code nodes, and applies syntax highlighting for
	//	a wide variety of languages. Simply dojo.require() in all the 
	//	dojox.highlight.languages you wish to include in your highlighingting,
	//	and customize colors in the highlight.css.
	//
	//	It is provided as a dojo package, contributed under CLA 
	//	by Ivan Sagalaev and is available originally from:
	// 	http://softwaremaniacs.org/soft/highlight/en/	
	//	
};

dojox.image = { 
	// summary: A collection of image related widgets
};

dojox.io = { 
	// summary: Extensions to the Core dojo.io transports
};

dojox.jsonPath = { 
	// summary: A query system for JavaScript objects
};

dojox.layout = { 
	// summary: A collection of layout related Widgets
};

dojox.lang = { 
	// summary: Language specific extensions
	functional: {
		// summary: Functional language constructs, including currying and lambda.
	}
};

dojox.math = { 
	// summary: A collection of various advanced math functions.
};

dojox.off = { 
	// summary: the Dojo Offline project
};

dojox.presentation = {
	// summary: A simple, experimental PowerPoint-like presentation project
};

dojox.regexp = { 
	// summary: Additional pre-made regular expressions for use
};

dojox.sql = { 
	// summary: objects to support Dojo Offline (dojox.off)
};

dojox.storage = { 
	// summary: Objects for mass storage within the browser.  For when cookies just aren't enough.
};

dojox.string = {
	// summary: A collection of various objects for advanced string manipulation, including a Builder and a tokenizer.
};

dojox.timing = {
	// summary: A set of objects to perform advanced time-based tasks, including a basic Timer.
};

dojox.uuid = { 
	// summary: Universally Unique Identifier (UUID) implementations, including an implementation of UUID 2
};

dojox.validate = { 
	// summary: Additional input validation methods
	ca : {
		// summary: Methods specific to the Canadian provinces
	},
	creditCard : {
		// summary: Validate various credit card types  
	}
};

dojox.widget = { 
	// summary: A Collection of un-categorized widgets, or code not requiring it's own package.
	// 
	// description: 
	// 	These are standalone widgets with varying levels of stability. Some are useful, 
	//	some were created for demonstration purposes, and learning tools. The each maintain
	//	their own .css file (typically dojox/widget/WidgetName/WidgetName.css)
	//
	//	
};

dojox.wire = { // FIXME:

};

dojox.xml = {
	// summary: XML utilities.  Currently only includes a DomParser, which returns a psuedo-XML document in JSON-like form.
};
=====*/
