/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import junit.framework.Assert;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class TestsContentProviderUtil {
    public static final QualifiedName TEMPLATE_PROP = new QualifiedName("org.eclipse.core.resources.semantic.test", "Hello");
    public static final QualifiedName DUMMY_PROP = new QualifiedName("org.eclipse.core.resources.semantic.test", "Dummy1");
    public static final QualifiedName DUMMY_PROP2 = new QualifiedName("org.eclipse.core.resources.semantic.test", "Dummy2");
    public final String projectName;
    public final String providerName;
    public IProject testProject;
    public final int options;
    public final boolean autoRefresh;

    public TestsContentProviderUtil(boolean withAutoRefresh, String projectName, String providerName) {
        this.projectName = projectName;
        this.providerName = providerName;
        if (withAutoRefresh) {
            this.options = 0;
            this.autoRefresh = true;
        } else {
            this.options = 2;
            this.autoRefresh = false;
        }
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        TestsContentProviderUtil.initTrace();
    }

    public static void initTrace() {
    }

    public static void resetTrace() {
    }

    public static void afterClass() throws Exception {
        TestsContentProviderUtil.resetTrace();
    }

    @Before
    public void beforeMethod() throws Exception {
        String[] roots;
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        if (project.exists()) {
            throw new IllegalStateException("Project exists");
        }
        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProjectDescription description = workspace.newProjectDescription(TestsContentProviderUtil.this.projectName);
                try {
                    description.setLocationURI(new URI("semanticfs:/" + TestsContentProviderUtil.this.projectName));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                project.create(description, monitor);
                project.open(monitor);
                RemoteStoreTransient store = (RemoteStoreTransient)project.getAdapter(RemoteStoreTransient.class);
                RemoteFolder f1 = store.getRootFolder().addFolder("Folder1");
                f1.addFolder("Folder11");
                try {
                    f1.addFile("File1", "Hello World".getBytes("UTF-8"), System.currentTimeMillis());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                RepositoryProvider.map((IProject)project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
                ISemanticProject spr = (ISemanticProject)project.getAdapter(ISemanticProject.class);
                HashMap<QualifiedName, String> properties = new HashMap<QualifiedName, String>();
                properties.put(TEMPLATE_PROP, "World");
                spr.addFolder("root", TestsContentProviderUtil.this.providerName, properties, TestsContentProviderUtil.this.options, monitor);
                project.refreshLocal(2, monitor);
            }
        };
        workspace.run(myRunnable, (ISchedulingRule)workspace.getRoot(), 1, null);
        this.testProject = project;
        String projectName1 = this.testProject.getName();
        String[] stringArray = roots = ((ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs")).getRootNames();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            if (root.equals(projectName1)) {
                return;
            }
            ++n2;
        }
        Assert.fail((String)"Project should be in the list of root names");
    }

    @After
    public void afterMethod() throws Exception {
        RemoteStoreTransient store = (RemoteStoreTransient)this.testProject.getAdapter(RemoteStoreTransient.class);
        store.reset();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        this.testProject = null;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.delete(true, monitor);
                project.refreshLocal(2, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    public void assertContentsEqual(IFile file, String test) {
        InputStream is = null;
        try {
            try {
                is = file.getContents();
                int size = is.available();
                byte[] buffer = new byte[size];
                is.read(buffer);
                Assert.assertEquals((String)"Wrong content", (String)test, (String)new String(buffer, "UTF-8"));
            }
            catch (Exception e) {
                Assert.fail((String)("Exception getting file content: " + e.getMessage()));
                Util.safeClose((InputStream)is);
            }
        }
        finally {
            Util.safeClose((InputStream)is);
        }
    }

    public void assertContentsNotEqual(IFile file, String test) {
        InputStream is = null;
        try {
            try {
                is = file.getContents();
                int size = is.available();
                byte[] buffer = new byte[size];
                is.read(buffer);
                if (new String(buffer, "UTF-8").equals(test)) {
                    Assert.fail((String)"Contents should differ");
                }
            }
            catch (Exception e) {
                Assert.fail((String)("Exception getting file content: " + e.getMessage()));
                Util.safeClose((InputStream)is);
            }
        }
        finally {
            Util.safeClose((InputStream)is);
        }
    }

    public File createTestFile(String fileName) {
        String tmpdir = System.getProperty("java.io.tmpdir");
        File file = new File(tmpdir, fileName);
        file.deleteOnExit();
        return file;
    }

    public URI createURI4File(File file) throws URISyntaxException {
        String filepath = file.getAbsolutePath().replace('\\', '/');
        if (!filepath.startsWith("/")) {
            filepath = "/" + filepath;
        }
        return new URI("file", "", filepath, null);
    }

    public void writeContentsToFile(File testfile, String contents, String encoding) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        FileOutputStream os = new FileOutputStream(testfile);
        try {
            ((OutputStream)os).write(contents.getBytes(encoding));
        }
        finally {
            Util.safeClose((OutputStream)os);
        }
    }
}

