/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CTabItemTest
extends CSSSWTTestCase {
    private CSSEngine engine;
    private Shell shell;

    protected void tearDown() throws Exception {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
        super.tearDown();
    }

    private void spinEventLoop() {
        while (this.shell.getDisplay().readAndDispatch()) {
        }
    }

    private CTabFolder createFolder(Composite composite) {
        CTabFolder folderToTest = new CTabFolder(composite, 2048);
        int i = 0;
        while (i < 4) {
            CTabItem item = new CTabItem(folderToTest, 0);
            item.setText("Item " + i);
            Button control = new Button((Composite)folderToTest, 8);
            item.setControl((Control)control);
            ++i;
        }
        return folderToTest;
    }

    private CTabFolder createTestTabFolder() {
        return this.createTestTabFolder(true);
    }

    private CTabFolder createTestTabFolder(boolean open) {
        Display display = Display.getDefault();
        this.shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        this.shell.setLayout((Layout)layout);
        CTabFolder folderToTest = this.createFolder((Composite)this.shell);
        if (open) {
            this.shell.open();
        }
        return folderToTest;
    }

    private CTabFolder createTestTabFolder(String styleSheet) {
        return this.createTestTabFolder(styleSheet, true);
    }

    protected CTabFolder createTestTabFolder(String styleSheet, boolean open) {
        CTabFolder folder = this.createTestTabFolder(open);
        this.engine = this.createEngine(styleSheet, folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        return folder;
    }

    public void testFontRegular() throws Exception {
        CTabFolder folder = this.createTestTabFolder("Button { font-family: Verdana; font-size: 12 }\nCTabItem { font-family: Verdana; font-size: 16 }");
        this.spinEventLoop();
        CTabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            FontData fontData = items[i].getFont().getFontData()[0];
            CTabItemTest.assertEquals((String)"Verdana", (String)fontData.getName());
            CTabItemTest.assertEquals((int)16, (int)fontData.getHeight());
            CTabItemTest.assertEquals((int)0, (int)fontData.getStyle());
            CTabItemTest.assertEquals((String)"Verdana", (String)this.engine.retrieveCSSProperty((Object)items[i], "font-family", null));
            CTabItemTest.assertEquals((String)"16", (String)this.engine.retrieveCSSProperty((Object)items[i], "font-size", null));
            Control button = items[i].getControl();
            fontData = button.getFont().getFontData()[0];
            CTabItemTest.assertEquals((String)"Verdana", (String)fontData.getName());
            CTabItemTest.assertEquals((int)12, (int)fontData.getHeight());
            CTabItemTest.assertEquals((int)0, (int)fontData.getStyle());
            ++i;
        }
    }

    public void testFontBold() throws Exception {
        CTabFolder folder = this.createTestTabFolder("Button { font-weight: bold }\nCTabItem { font-weight: bold }");
        this.spinEventLoop();
        CTabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            FontData fontData = items[i].getFont().getFontData()[0];
            CTabItemTest.assertEquals((int)1, (int)fontData.getStyle());
            CTabItemTest.assertEquals((String)"bold", (String)this.engine.retrieveCSSProperty((Object)items[i], "font-weight", null));
            Control button = items[i].getControl();
            fontData = button.getFont().getFontData()[0];
            CTabItemTest.assertEquals((int)1, (int)fontData.getStyle());
            ++i;
        }
    }

    public void testFontItalic() throws Exception {
        CTabFolder folder = this.createTestTabFolder("Button { font-weight: bold }\nCTabItem { font-style: italic }");
        this.spinEventLoop();
        CTabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            FontData fontData = items[i].getFont().getFontData()[0];
            CTabItemTest.assertEquals((int)2, (int)fontData.getStyle());
            CTabItemTest.assertEquals((String)"italic", (String)this.engine.retrieveCSSProperty((Object)items[i], "font-style", null));
            Control button = items[i].getControl();
            fontData = button.getFont().getFontData()[0];
            CTabItemTest.assertEquals((int)1, (int)fontData.getStyle());
            ++i;
        }
    }

    private void testSelectedFontBold(CTabFolder folder, int selectionIndex) throws Exception {
        folder.setSelection(selectionIndex);
        this.spinEventLoop();
        CTabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            FontData fontData = items[i].getFont().getFontData()[0];
            if (i == selectionIndex) {
                CTabItemTest.assertEquals((int)1, (int)fontData.getStyle());
            } else {
                CTabItemTest.assertEquals((int)0, (int)fontData.getStyle());
            }
            ++i;
        }
    }

    public void testSelectedFontBold() throws Exception {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            this.testSelectedFontBold(folder, i);
            ++i;
        }
    }

    public void testSelectedFontMerged() throws Exception {
        CTabFolder folder = this.createTestTabFolder("CTabItem { font-weight: normal; font-style: italic }\nCTabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItem item = folder.getItem(i);
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                CTabItemTest.assertEquals((int)3, (int)fd.getStyle());
            } else {
                CTabItemTest.assertEquals((int)2, (int)fd.getStyle());
            }
            ++i;
        }
    }

    public void testSelectedFontMerged2() throws Exception {
        CTabFolder folder = this.createTestTabFolder("CTabItem { font-style: italic }\nCTabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItem item = folder.getItem(i);
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                CTabItemTest.assertEquals((int)3, (int)fd.getStyle());
            } else {
                CTabItemTest.assertEquals((int)2, (int)fd.getStyle());
            }
            ++i;
        }
    }

    public void testSelectedFontMerged3() throws Exception {
        CTabFolder folder = this.createTestTabFolder("CTabItem { font-weight: bold }\nCTabItem:selected { font-style: italic; font-weight: normal }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItem item = folder.getItem(i);
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                CTabItemTest.assertEquals((int)2, (int)fd.getStyle());
            } else {
                CTabItemTest.assertEquals((int)1, (int)fd.getStyle());
            }
            ++i;
        }
    }

    private void testShowClose(boolean showClose) throws Exception {
        CTabFolder folder = this.createTestTabFolder("CTabItem { show-close: " + Boolean.toString(showClose) + " }");
        CTabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            CTabItemTest.assertEquals((boolean)showClose, (boolean)items[i].getShowClose());
            CTabItemTest.assertEquals((String)Boolean.toString(showClose), (String)this.engine.retrieveCSSProperty((Object)items[i], "show-close", null));
            ++i;
        }
    }

    public void testShowCloseFalse() throws Exception {
        this.testShowClose(false);
    }

    public void testShowCloseTrue() throws Exception {
        this.testShowClose(true);
    }

    public void testShowClose() throws Exception {
        CTabFolder folder = this.createTestTabFolder("CTabItem { show-close: true }");
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItemTest.assertEquals((boolean)true, (boolean)folder.getItem(i).getShowClose());
            ++i;
        }
        this.engine = this.createEngine("CTabItem { show-close: false }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        i = 0;
        while (i < folder.getItemCount()) {
            CTabItemTest.assertEquals((boolean)false, (boolean)folder.getItem(i).getShowClose());
            ++i;
        }
    }

    public void testShowClose2() throws Exception {
        CTabFolder folder = this.createTestTabFolder();
        CTabFolder folder2 = this.createFolder((Composite)folder.getShell());
        this.engine = this.createEngine("CTabItem { show-close: true }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItemTest.assertEquals((boolean)true, (boolean)folder.getItem(i).getShowClose());
            ++i;
        }
        i = 0;
        while (i < folder2.getItemCount()) {
            CTabItemTest.assertEquals((boolean)true, (boolean)folder2.getItem(i).getShowClose());
            ++i;
        }
        this.engine = this.createEngine("CTabItem { show-close: false }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        i = 0;
        while (i < folder.getItemCount()) {
            CTabItemTest.assertEquals((boolean)false, (boolean)folder.getItem(i).getShowClose());
            ++i;
        }
        i = 0;
        while (i < folder.getItemCount()) {
            CTabItemTest.assertEquals((boolean)false, (boolean)folder2.getItem(i).getShowClose());
            ++i;
        }
    }

    private void testSelectedShowClose(CTabFolder folder, int index) {
        CTabItem[] items = folder.getItems();
        folder.setSelection(index);
        this.spinEventLoop();
        int i = 0;
        while (i < items.length) {
            if (i == index) {
                CTabItemTest.assertEquals((boolean)true, (boolean)items[i].getShowClose());
                CTabItemTest.assertEquals((String)"true", (String)this.engine.retrieveCSSProperty((Object)items[i], "show-close", null));
            } else {
                CTabItemTest.assertEquals((boolean)false, (boolean)items[i].getShowClose());
                CTabItemTest.assertEquals((String)"false", (String)this.engine.retrieveCSSProperty((Object)items[i], "show-close", null));
            }
            ++i;
        }
    }

    public void testSelectedShowClose() throws Exception {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { show-close: true }");
        int i = 0;
        while (i < folder.getItemCount()) {
            this.testSelectedShowClose(folder, i);
            ++i;
        }
        this.engine = this.createEngine("CTabItem:selected { show-close: false }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        i = 0;
        while (i < folder.getItemCount()) {
            CTabItemTest.assertFalse((boolean)folder.getItem(i).getShowClose());
            ++i;
        }
    }

    public void testSelectedShowClose2() throws Exception {
        CTabFolder folder = this.createTestTabFolder("CTabItem { show-close: false }\nCTabItem:selected { show-close: true }");
        int i = 0;
        while (i < folder.getItemCount()) {
            this.testSelectedShowClose(folder, i);
            ++i;
        }
    }

    public void testBackground() throws Exception {
        CTabFolder folder = this.createTestTabFolder("CTabItem { background-color: #0000ff }", false);
        CTabItemTest.assertEquals((Object)new RGB(0, 0, 255), (Object)folder.getBackground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItemTest.assertEquals((String)"#0000ff", (String)this.engine.retrieveCSSProperty((Object)folder.getItem(i), "background-color", null));
            ++i;
        }
    }

    public void testBackground2() throws Exception {
        CTabFolder folder = this.createTestTabFolder(false);
        Color preStyledSelectionBackground = folder.getSelectionBackground();
        RGB rgb = new RGB(0, 0, 255);
        String colour = "#0000ff";
        if (rgb.equals((Object)preStyledSelectionBackground.getRGB())) {
            rgb = new RGB(0, 255, 0);
            colour = "#00ff00";
        }
        CSSEngine engine = this.createEngine("CTabItem { background-color: " + colour + " }", folder.getDisplay());
        engine.applyStyles((Object)folder, true);
        CTabItemTest.assertEquals((Object)rgb, (Object)folder.getBackground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItemTest.assertEquals((String)colour, (String)engine.retrieveCSSProperty((Object)folder.getItem(i), "background-color", null));
            ++i;
        }
        CTabItemTest.assertEquals((Object)preStyledSelectionBackground.getRGB(), (Object)folder.getSelectionBackground().getRGB());
    }

    public void testSelectionBackground() throws Exception {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { background-color: #00ff00 }", false);
        CTabItemTest.assertEquals((Object)new RGB(0, 255, 0), (Object)folder.getSelectionBackground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItemTest.assertEquals((String)"#00ff00", (String)this.engine.retrieveCSSProperty((Object)folder.getItem(i), "background-color", "selected"));
            ++i;
        }
    }
}

